#ifdef __hpux
#define _HPUX_SOURCE					/* ANSI prototypes */
#endif

#include <signal.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdarg.h>

struct itimerval value;
int itimer_real;

void alarm() {
    itimer_real += 1;
    signal( SIGALRM, alarm );				/* System V requires handler be reset */
    setitimer(ITIMER_REAL, &value, 0);
}

int uFprintf( FILE *stream, char *fmt, ... ) {
    int code;
    va_list args;
    va_start( args, fmt );
    code = _doprnt( fmt, args, stream );
    va_end( args );

    return code;
} /* uFprintf */

#define U_FNDELAY O_NONBLOCK
#define U_EWOULDBLK EAGAIN

int main() {
    int i, j, count, flags, tmperrno;
    char *v = "abc";

    value.it_value.tv_sec = 0;
    value.it_value.tv_usec = 10000;
    value.it_interval.tv_sec = 0;
    value.it_interval.tv_usec = 0;

    signal( SIGALRM, alarm );
    setitimer( ITIMER_REAL, &value, 0 );
    
    for ( j = 0; j < 400; j += 1 ) {
	for ( i = 0; ; i += 1 ) {
	    count = uFprintf( stdout, "%s", v );
	    tmperrno = errno;
	  if ( count != -1 ) break;			/* if the read was successful, break */
	  if ( tmperrno != EINTR && tmperrno != U_EWOULDBLK ) { /* if an error occurred, handle it */
		fprintf( stderr, "tmperrno:%d\n", tmperrno );
		break;
	    }
	    if ( i % 5000 == 0 ) printf( "still looking\n" );
	} /* for */
    } /* for */
    printf( "\n%d\n", itimer_real );
} /* main */

/* Local Variables: */
/* compile-command: "cc -Aa NonBlockingO.c" */
/* End: */
