#ifdef __hpux
#define _HPUX_SOURCE					/* ANSI prototypes */
#endif

#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdarg.h>

int uFscanf( FILE *stream, char *fmt, ... ) {
    int count;
    va_list args;

    va_start( args, fmt );
    count = _doscan( stream, fmt, args );
    va_end( args );

    return( count );
} /* uFscanf */

#define U_FNDELAY O_NONBLOCK
#define U_EWOULDBLK EAGAIN

int main() {
    int i, v, *args = &v, count, flags, tmperrno;
    
    for ( i = 0; ; i += 1 ) {
	flags = fcntl( fileno( stdin ), F_GETFL );
	flags = fcntl( fileno( stdin ), F_SETFL, flags | U_FNDELAY );
	count = uFscanf( stdin, "%d", &v );
	tmperrno = errno;
	flags = fcntl( fileno( stdin ), F_GETFL );
	flags = fcntl( fileno( stdin ), F_SETFL, flags & ~ U_FNDELAY );
      if ( count != -1 ) break;			/* if the read was successful, break */
      if ( feof( stdin ) ) {			/* check for eof */
	    fprintf( stderr, "eof\n" );
	    break;
	} /* if */
      if ( tmperrno != EINTR && tmperrno != U_EWOULDBLK ) { /* if an error occurred, handle it */
	    fprintf( stderr, "tmperrno:%d\n", tmperrno );
	    break;
	}
	if ( i % 5000 == 0 ) printf( "still looking\n" );
    } /* for */
    printf( "%d %d\n", v, count );
} /* main */

/* Local Variables: */
/* compile-command: "cc -Aa NonBlockingI.c" */
/* End: */
