
# line 41 "c-parse.y"
#include <stdio.h>

#include "c-parse.h" /* mpp */
#include "uType.h" /* mpp */
#include "uTable.h" /* mpp */
#include "uBuffer.h" /* mpp */
#include "uMpp.h" /* mpp */

/* Cause the `yydebug' variable to be defined.  */
#define YYDEBUG 0
# define IDENTIFIER 257
# define TYPENAME 258
# define SCSPEC 259
# define TYPESPEC 260
# define TYPE_QUAL 261
# define CONSTANT 262
# define STRING 263
# define ELLIPSIS 264
# define SIZEOF 265
# define ENUM 266
# define STRUCT 267
# define UNION 268
# define IF 269
# define ELSE 270
# define WHILE 271
# define DO 272
# define FOR 273
# define SWITCH 274
# define CASE 275
# define DEFAULT 276
# define BREAK 277
# define CONTINUE 278
# define RETURN 279
# define GOTO 280
# define ASM 281
# define TYPEOF 282
# define ALIGNOF 283
# define MONITOR 284
# define ENTRY 285
# define LOCAL 286
# define WAIT_ON 287
# define WITH 288
# define NOTIFY 289
# define WAIT_UNTIL 290
# define ASSIGN 291
# define OROR 292
# define ANDAND 293
# define EQCOMPARE 294
# define ARITHCOMPARE 295
# define LSHIFT 296
# define RSHIFT 297
# define UNARY 298
# define PLUSPLUS 299
# define MINUSMINUS 300
# define HYPERUNARY 301
# define POINTSAT 302

# line 113 "c-parse.y"
char *monitor_name = 0, *entry_name = 0, *cond_name = 0; /* mpp */
int cond_init_count = -1; /* mpp */
extern Monitor_type MonType; /* mpp */
extern void mon_type(); /* mpp */

static char *FrontType = 0, *BackType = 0; /* mpp */
static char *CondName = 0, *CondName2 = 0; /* mpp */
static int  entry_type = 0; /* mpp */
static int  monitor_seen = 0; /* mpp */
static int  anon_cnt = 0; /* mpp */
static int  entry_seen = 0; /* mpp */
static int  local_seen = 0; /* mpp */
static int  typedef_seen = 0; /* mpp */
static int  void_seen = 0; /* mpp */
static int  condition_seen = 0; /* mpp */
static int  void_entry = 0; /* mpp */
static int  star_seen = 0; /* mpp */
static int  identifier = 0; /* mpp */
static int  vector = 0; /* mpp */
static int  function = 0; /* mpp */
static int  pointer = 0; /* mpp */
static int  arg_list = 0; /* mpp */
static int  mark = 0; /* mpp */
static int  back_mark = 0; /* mpp */
static int  level = 1; /* mpp */

/* the declaration found for the last IDENTIFIER token read in.
   yylex must look this up to detect typedefs, which get token type TYPENAME,
   so it is left around in case the identifier is not a typedef but is
   used in a context which makes it a reference to a variable.  */

static char *last_id; /* mpp */

/* List of types and structure classes of the current declaration */

char *input_filename;		/* source file current line is coming from */
char *main_input_filename;	/* top-level source file */

static int yylex ();
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1272 "c-parse.y"


int lineno;			/* current line number in file being read */

FILE *finput;			/* input file.
				   Normally a pipe from the preprocessor.  */

/* lexical analyzer */

static int maxtoken;		/* Current nominal length of token buffer */
static char *token_buffer;	/* Pointer to token buffer.
				   Actual allocated length is maxtoken + 2.  */

static new_line_number; /* mpp */

#ifndef DOLLARS_IN_IDENTIFIERS
#define DOLLARS_IN_IDENTIFIERS 0
#endif
int dollars_in_ident = DOLLARS_IN_IDENTIFIERS;

#define MAXRESERVED 10 /* mpp */

/* frw[I] is index in `reswords' of the first word whose length is I;
   frw[I+1] is one plus the index of the last word whose length is I.
   The length of frw must be MAXRESERVED + 2 so there is an element
   at MAXRESERVED+1 for the case I == MAXRESERVED.  */

static char frw[MAXRESERVED+2] =
/*  0  1  2  3  4   5   6   7   8   9  10  11       mpp */
  { 0, 0, 0, 2, 5, 14, 21, 33, 36, 41, 42, 43 }; /* mpp */

/* Table of reserved words.  */

struct resword { char *name; short token; enum rid rid;};

#define NORID RID_UNUSED

static struct resword reswords[]
  = {{"if", IF, NORID},
     {"do", DO, NORID},
     {"int", TYPESPEC, RID_INT},
     {"for", FOR, NORID},
     {"asm", ASM, NORID},
     {"case", CASE, NORID},
     {"char", TYPESPEC, RID_CHAR},
     {"auto", SCSPEC, RID_AUTO},
     {"goto", GOTO, NORID},
     {"else", ELSE, NORID},
     {"long", TYPESPEC, RID_LONG},
     {"void", TYPESPEC, RID_VOID},
     {"enum", ENUM, NORID},
     {"with", WITH, NORID}, /* mpp */
     {"float", TYPESPEC, RID_FLOAT},
     {"short", TYPESPEC, RID_SHORT},
     {"union", UNION, NORID},
     {"break", BREAK, NORID},
     {"while", WHILE, NORID},
     {"const", TYPE_QUAL, RID_CONST},
     {"uWait", WAIT_ON, NORID}, /* mpp */
     {"double", TYPESPEC, RID_DOUBLE},
     {"static", SCSPEC, RID_STATIC},
     {"extern", SCSPEC, RID_EXTERN},
     {"struct", STRUCT, NORID},
     {"return", RETURN, NORID},
     {"sizeof", SIZEOF, NORID},
     {"typeof", TYPEOF, NORID},
     {"switch", SWITCH, NORID},
     {"signed", TYPESPEC, RID_SIGNED},
     {"inline", SCSPEC, RID_INLINE},
     {"uEntry", ENTRY, NORID}, /* mpp */
     {"uLocal", LOCAL, NORID}, /* mpp */
     {"uSignal", NOTIFY, NORID}, /* mpp */
     {"typedef", SCSPEC, RID_TYPEDEF},
     {"default", DEFAULT, NORID},
     {"uMonitor", MONITOR, NORID}, /* mpp */
     {"unsigned", TYPESPEC, RID_UNSIGNED},
     {"continue", CONTINUE, NORID},
     {"register", SCSPEC, RID_REGISTER},
     {"volatile", TYPE_QUAL, RID_VOLATILE},
     {"__alignof", ALIGNOF, NORID},
     {"uWaitUntil", WAIT_UNTIL, NORID}, /* mpp */
}; /* mpp */

int check_newline ();

void
init_lex ()
{
  extern char *malloc ();

  /* Start it at 0, because check_newline is called at the very beginning
     and will increment it to 1.  */
  lineno = 0;

  maxtoken = 40;
  token_buffer = malloc (maxtoken + 2);
  last_id = malloc (maxtoken + 2); /* mpp */
}

/* If C is not whitespace, return C.
   Otherwise skip whitespace and return first nonwhite char read.  */

static int
skip_white_space (c)
     register int c;
{
  register int inside;

  for (;;)
    {
      switch (c)
	{
	case '/':
	  c = getc (finput);
	  if (c != '*')
	    {
	      ungetc (c, finput);
	      return '/';
	    }

          echo ('/'); /* mpp */
          echo ('*'); /* mpp */
	  c = getc (finput);

	  inside = 1;
	  while (inside)
	    {
	      if (c == '*')
		{
		  while (c == '*')
		    { echo ('*'); c = getc (finput); } /* mpp */

		  if (c == '/')
		    {
                      echo ('/'); /* mpp */
		      inside = 0;
		      c = getc (finput);
		    }
		}
	      else if (c == '\n')
		{
                  echo ('\n'); /* mpp */
		  lineno++;
		  c = getc (finput);
		}
	      else if (c == EOF)
		{
		  break;
		}
	      else
		{ echo (c); c = getc (finput); } /* mpp */
	    }

	  break;

	case '\n':
          echo ('\n'); /* mpp */
	  c = check_newline ();
	  break;

	case ' ':
	case '\t':
	case '\f':
	case '\r':
	case '\b':
          echo (c); /* mpp */
	  c = getc (finput);
	  break;

	case '\\':
          echo ('\\'); /* mpp */
	  c = getc (finput);
          echo (c); /* mpp */
	  if (c == '\n')
	    lineno++;
	  c = getc (finput);
	  break;

	default:
	  return (c);
	}
    }
}



/* Make the token buffer longer, preserving the data in it.
   P should point to just beyond the last valid character in the old buffer.
   The value we return is a pointer to the new buffer
   at a place corresponding to P.  */

static char *
extend_token_buffer (p)
     char *p;
{
  int offset = p - token_buffer;

  maxtoken = maxtoken * 2 + 10;
  token_buffer = (char *) realloc (token_buffer, maxtoken + 2);
  if (token_buffer == 0)
    fatal ("virtual memory exceeded", 0, 0);
  last_id = (char *) realloc (last_id, maxtoken + 2); /* mpp */
  if (last_id == 0) /* mpp */
    fatal ("virtual memory exceeded", 0, 0); /* mpp */

  return token_buffer + offset;
}

/* At the beginning of a line, increment the line number
   and handle a #line directive immediately following.
   Return first nonwhite char of first non-# line following.  */

int
check_newline ()
{
  register int c;
  register int token;

  while (1)
    {
      lineno++;

      /* Read first nonwhite char on the line.  */

      c = getc (finput);
      while (c == ' ' || c == '\t')
	{ echo (c), c = getc (finput); } /* mpp */

      if (c != '#')
	{
	  /* If not #, return it so caller will use it.  */
	  return c;
	}

      /* Read first nonwhite char after the `#'.  */

      echo ('#'); /* mpp */
      c = getc (finput);
      while (c == ' ' || c == '\t')
	{ echo (c), c = getc (finput); } /* mpp */

      /* If a letter follows, then if the word here is `line', skip
	 it and ignore it; otherwise, ignore the line, with an error
	 if the word isn't `pragma'.  */

      if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
	{
	  if (c == 'l') /* mpp */
            { /* mpp */
              echo ('l'); /* mpp */
              if ((c = getc (finput)) == 'i') /* mpp */
                { /* mpp */
                  echo ('i'); /* mpp */
                  if ((c = getc (finput)) == 'n') /* mpp */
                    { /* mpp */
                      echo ('n'); /* mpp */
                      if ((c = getc (finput)) == 'e') /* mpp */
                        { /* mpp */
                          echo ('e'); /* mpp */
	                  if ((c = getc (finput)) == ' ' || c == '\t') /* mpp */
	                      goto linenum; /* mpp */
	                } /* mpp */
	            } /* mpp */
	        } /* mpp */
	    } /* mpp */

	noerror:

	  if (c == 0) /* mpp */
	    return 0; /* mpp */
          echo (c); /* mpp */

	  while ((c = getc (finput)) && c != '\n') echo (c); /* mpp */

	  if (c == 0)
	    return 0;
          echo ('\n'); /* mpp */
	  continue;
	}

    linenum:
      /* Here we have either `#line' or `# <nonletter>'.
	 In either case, it should be a line number; a digit should follow.  */

      while (c == ' ' || c == '\t')
	{ echo (c); c = getc (finput); } /* mpp */

      /* If the # is the only nonwhite char on the line,
	 just ignore it.  Check the new newline.  */
      if (c == '\n')
	{ echo ('\n'); continue; } /* mpp */

      /* Something follows the #; read a token.  */

      ungetc (c, finput);
      /* echo( 'l' ); echo( 'i' ); echo( 'n' ); echo( 'e' ); echo( ' ' ); */ /* mpp */
      token = yylex ();

      if (token == CONSTANT && yylval == 1) /* mpp */
	{
	  /* subtract one, because it is the following line that
	     gets the specified number */

          int string_length; /* mpp */
	  int l = new_line_number - 1; /* mpp */

	  /* Is this the last nonwhite stuff on the line?  */
	  c = getc (finput);
	  while (c == ' ' || c == '\t')
	    { echo(c); c = getc (finput); } /* mpp */
	  if (c == '\n')
	    {
              echo ('\n'); /* mpp */
	      /* No more: store the line number and check following line.  */
	      lineno = l;
	      continue;
	    }
	  ungetc (c, finput);

	  /* More follows: it must be a string constant (filename).  */

	  token = yylex ();
	  if (token != STRING) /* mpp */
	    {
	      return getc (finput);
	    }

          string_length = strlen(token_buffer); /* mpp */
          token_buffer[string_length - 1] = '\0'; /* mpp */
	  input_filename
            = (char *) malloc (string_length); /* mpp */
	  strcpy (input_filename, token_buffer + 1); /* mpp */
	  lineno = l;

	  if (main_input_filename == 0)
	    main_input_filename = input_filename;
	}

      /* skip the rest of this line.  */
      while ((c = getc (finput)) && c != '\n') echo (c); /* mpp */
      if (c == 0)
	return 0;
      echo ('\n'); /* mpp */
    }
}

#define isalnum(char) ((char >= 'a' && char <= 'z') || (char >= 'A' && char <= 'Z') || (char >= '0' && char <= '9'))
#define isdigit(char) (char >= '0' && char <= '9')
#define ENDFILE -1  /* token that represents end-of-file */


static int
readescape ()
{
  register int c = getc (finput);
  register int count, code;

  echo ('\\'); /* mpp */
  switch (c)
    {
    case 'x':
      code = 0;
      count = 0;
      while (1)
	{
	  c = getc (finput);
	  if (!(c >= 'a' && c <= 'f')
	      && !(c >= 'A' && c <= 'F')
	      && !(c >= '0' && c <= '9'))
	    {
	      ungetc (c, finput);
	      break;
	    }
	  code *= 16;
	  if (c >= 'a' && c <= 'f')
	    code += c - 'a' + 10;
	  if (c >= 'A' && c <= 'F')
	    code += c - 'A' + 10;
	  if (c >= '0' && c <= '9')
	    code += c - '0';
	  count++;
	}
      return code;

    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':
      code = 0;
      count = 0;
      while ((c <= '7') && (c >= '0') && (count++ < 3))
	{
          echo (c); /* mpp */
	  code = (code * 8) + (c - '0');
	  c = getc (finput);
	}
      ungetc (c, finput);
      return code;

    case '\\': case '\'': case '"':
      echo (c); /* mpp */
      return c;

    case '\n':
      echo ('\n'); /* mpp */
      lineno++;
      return -1;

    case 'n':
      echo ('n'); /* mpp */
      return 012; /* mpp */

    case 't':
      echo ('t'); /* mpp */
      return 011; /* mpp */

    case 'r':
      echo ('r'); /* mpp */
      return 015; /* mpp */

    case 'f':
      echo ('f'); /* mpp */
      return 014; /* mpp */

    case 'b':
      echo ('b'); /* mpp */
      return 010; /* mpp */

    case 'a':
      echo ('a'); /* mpp */
      return 007; /* mpp */

    case 'v':
      echo ('v'); /* mpp */
      return 013; /* mpp */

    case 'E':
      echo ('E'); /* mpp */
      return 033;

    case '?':
      /* `\(', etc, are used at beginning of line to avoid confusing Emacs.  */
    case '(':
    case '{':
    case '[':
      echo (c); /* mpp */
      return c;
    }
  echo (c); /* mpp */
  return c;
}

void
yyerror (string)
     char *string;
{
}

static int nextchar = -1;

static int
yylex ()
{
  register int c;
  register char *p;
  register int value;
  int wide_flag = 0;

  printbuffer (0); /* mpp */

  if (nextchar >= 0)
    c = nextchar, nextchar = -1;
  else
    c = getc (finput);

  /* Effectively do c = skip_white_space (c)
     but do it faster in the usual cases.  */
  while (1)
    switch (c)
      {
      case ' ':
      case '\t':
      case '\f':
      case '\r':
      case '\b':
        echo (c); /* mpp */
	c = getc (finput);
	break;

      case '\n':
      case '/':
      case '\\':
	c = skip_white_space (c);
      default:
	goto found_nonwhite;
      }
 found_nonwhite:

  token_buffer[0] = c;
  token_buffer[1] = 0;

  printbuffer (1); /* mpp */

/*  yylloc.first_line = lineno; */

  switch (c)
    {
    case EOF:
      token_buffer[0] = 0;
      value = ENDFILE;
      break;

    case '$':
      if (dollars_in_ident)
	goto letter;
      return '$';

    case 'L':
      /* Capital L may start a wide-string or wide-character constant.  */
      {
	register int c = getc (finput);
	if (c == '\'')
	  {
            echo ('L'); /* mpp */
	    wide_flag = 1;
	    goto char_constant;
	  }
	if (c == '"')
	  {
            echo ('L'); /* mpp */
	    wide_flag = 1;
	    goto string_constant;
	  }
	ungetc (c, finput);
      }

    case 'A':  case 'B':  case 'C':  case 'D':  case 'E':
    case 'F':  case 'G':  case 'H':  case 'I':  case 'J':
    case 'K':		  case 'M':  case 'N':  case 'O':
    case 'P':  case 'Q':  case 'R':  case 'S':  case 'T':
    case 'U':  case 'V':  case 'W':  case 'X':  case 'Y':
    case 'Z':
    case 'a':  case 'b':  case 'c':  case 'd':  case 'e':
    case 'f':  case 'g':  case 'h':  case 'i':  case 'j':
    case 'k':  case 'l':  case 'm':  case 'n':  case 'o':
    case 'p':  case 'q':  case 'r':  case 's':  case 't':
    case 'u':  case 'v':  case 'w':  case 'x':  case 'y':
    case 'z':
    case '_':
    letter:
      p = token_buffer;
      while (isalnum (c) || c == '_' || c == '$')
	{
	  if (p >= token_buffer + maxtoken)
	    p = extend_token_buffer (p);
	  if (c == '$' && ! dollars_in_ident)
	    break;

          echo (c); /* mpp */
	  *p++ = c;
	  c = getc (finput);
	}

      *p = 0;
      nextchar = c;

      value = IDENTIFIER;
      yylval = 0; /* mpp */

      /* Try to recognize a keyword.  */

      if (p - token_buffer <= MAXRESERVED)
	{
	  register int lim = frw [p - token_buffer + 1];
	  register int i = frw[p - token_buffer];
	  register struct resword *p = &reswords[i];

	  for (; i < lim; i++, p++)
	    if (p->name[0] == token_buffer[0]
		&& !strcmp (p->name, token_buffer))
	      {
		  yylval = (int) p->rid; /* mpp */
		  value = (int) p->token;
		break;
	      }
	}

      /* If we did not find a keyword, look for an identifier
	 (or a typename).  */

      if (value == IDENTIFIER)
	{
          if (lookup_id (token_buffer) == 0) /* mpp */
	    value = TYPENAME;
          strcpy (last_id, token_buffer); /* mpp */
	}

      break;

    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':  case '8':  case '9':
    case '.':
      {
	int base = 10;
	int count = 0;
	int largest_digit = 0;
	int numdigits = 0;
	/* for multi-precision arithmetic,
	   we store only 8 live bits in each short,
	   giving us 64 bits of reliable precision */
	short shorts[8];

	enum { NOT_FLOAT, AFTER_POINT, TOO_MANY_POINTS} floatflag
	  = NOT_FLOAT;

	for (count = 0; count < 8; count++)
	  shorts[count] = 0;

	p = token_buffer;
	*p++ = c;

	if (c == '0')
	  {
            echo ('0'); /* mpp */
	    *p++ = (c = getc (finput));
	    if ((c == 'x') || (c == 'X'))
	      {
                echo (c); /* mpp */
		base = 16;
		*p++ = (c = getc (finput));
	      }
	    else
	      {
		base = 8;
		numdigits++;
	      }
	  }

	/* Read all the digits-and-decimal-points.  */

	while (c == '.'
	       || (isalnum (c) && (c != 'l') && (c != 'L')
		   && (c != 'u') && (c != 'U')
		   && (floatflag == NOT_FLOAT || ((c != 'f') && (c != 'F')))))
	  {
	    if (c == '.')
	      {
                echo ('.'); /* mpp */
		if (floatflag == AFTER_POINT)
		    floatflag = TOO_MANY_POINTS;
		else
		  floatflag = AFTER_POINT;

		base = 10;
		*p++ = c = getc (finput);
		/* Accept '.' as the start of a floating-point number
		   only when it is followed by a digit.
		   Otherwise, unread the following non-digit
		   and use the '.' as a structural token.  */
		if (p == token_buffer + 2 && !isdigit (c))
		  {
		    if (c == '.')
		      {
                        echo ('.'); /* mpp */
			c = getc (finput);
			if (c == '.')
			  {
			    echo( '.' );
			    *p++ = c;
			    *p = 0;
			    return ELLIPSIS;
			  }
		      }
		    ungetc (c, finput);
		    token_buffer[1] = 0;
		    value = '.';
		    goto done;
		  }
	      }
	    else
	      {
		/* It is not a decimal point.
		   It should be a digit (perhaps a hex digit).  */

		if (isdigit (c))
		  {
                    echo (c); /* mpp */
		    c = c - '0';
		  }
		else if (base <= 10)
		  {
                    echo (c); /* mpp */
		    if ((c&~040) == 'E')
		      {
			base = 10;
			floatflag = AFTER_POINT;
			break;   /* start of exponent */
		      }
		    c = 0;
		  }
		else if (c >= 'a')
		  {
                    echo (c); /* mpp */
		    c = c - 'a' + 10;
		  }
		else
		  {
                    echo (c); /* mpp */
		    c = c - 'A' + 10;
		  }
		if (c >= largest_digit)
		  largest_digit = c;
		numdigits++;
	    
		for (count = 0; count < 8; count++)
		  {
		    (shorts[count] *= base);
		    if (count)
		      {
			shorts[count] += (shorts[count-1] >> 8);
			shorts[count-1] &= (1<<8)-1;
		      }
		    else shorts[0] += c;
		  }
    
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = (c = getc (finput));
	      }
	  }

	/* Remove terminating char from the token buffer and delimit the string */
	*--p = 0;

	if (floatflag != NOT_FLOAT)
	  {
	    char f_seen = 0;
	    char l_seen = 0;

	    /* Read explicit exponent if any, and put it in tokenbuf.  */

	    if ((c == 'e') || (c == 'E'))
	      {
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
		if ((c == '+') || (c == '-'))
		  {
                    echo (c); /* mpp */
		    *p++ = c;
		    c = getc (finput);
		  }
	        while (isdigit (c))
		  {
                    echo (c); /* mpp */
		    if (p >= token_buffer + maxtoken - 3)
		      p = extend_token_buffer (p);
		    *p++ = c;
		    c = getc (finput);
		  }
	      }

	    *p = 0;

	    /* Read the suffixes to choose a data type.  */
	    while (1)
	      {
		if (c == 'f' || c == 'F')
		  {
		    f_seen = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    l_seen = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			while (isalnum (c))
			  {
                            echo (c); /* mpp */
			    if (p >= token_buffer + maxtoken - 3)
			      p = extend_token_buffer (p);
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
                echo (c); /* mpp */
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
	      }

            yylval = 0; /* mpp */
	    ungetc (c, finput);
	    *p = 0;
	  }
	else
	  {
	    int spec_unsigned = 0;
	    int spec_long = 0;

	    while (1)
	      {
		if (c == 'u' || c == 'U')
		  {
		    spec_unsigned = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    spec_long = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			while (isalnum (c))
			  {
                            echo (c); /* mpp */
			    if (p >= token_buffer + maxtoken - 3)
			      p = extend_token_buffer (p);
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
                echo (c); /* mpp */
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
	      }

	    ungetc (c, finput);

	    /* This is simplified by the fact that our constant
	       is always positive.  */
            yylval = 1; /* mpp */
	    new_line_number = (shorts[3]<<24) + (shorts[2]<<16) + (shorts[1]<<8) + shorts[0]; /* mpp */

	  }

	value = CONSTANT; break;
      }

    case '\'':
    char_constant:
      echo ('\''); /* mpp */
      c = getc (finput);
      {
	register int code = 0;

      tryagain:

	if (c == '\\')
	  {
	    c = readescape ();
	    if (c < 0)
	      goto tryagain;
	  }
	else if (c == '\n')
	  {
            echo ('\n'); /* mpp */
	    lineno++;
	  }
        else /* mpp */
          echo (c); /* mpp */

	code = c;
	token_buffer[1] = c;
	token_buffer[2] = '\'';
	token_buffer[3] = 0;

	c = getc (finput);
        echo (c); /* mpp */

        yylval = 0; /* mpp */
	value = CONSTANT; break;
      }

    case '"':
    string_constant:
      {
        echo ('\"'); /* mpp */
	c = getc (finput);
	p = token_buffer + 1;

	while (c != 0 && c != '"') /* mpp */
	  {
	    if (c == '\\')
	      {
		c = readescape ();
		if (c < 0)
		  goto skipnewline;
	      }
	    else if (c == '\n')
	      {
                echo ('\n'); /* mpp */
		lineno++;
	      }
            else /* mpp */
              echo (c); /* mpp */

	    if (p == token_buffer + maxtoken)
	      p = extend_token_buffer (p);
	    *p++ = c;

	  skipnewline:
	    c = getc (finput);
	  }

        if (c == '\"') /* mpp */
           echo ('\"'); /* mpp */
	*p = 0;

        yylval = 0; /* mpp */

	*p++ = '"';
	*p = 0;

	value = STRING; break;
      }
      
    case '+':
    case '-':
    case '&':
    case '|':
    case '<':
    case '>':
    case '*':
    case '/':
    case '%':
    case '^':
    case '!':
    case '=':
      {
	register int c1;

      combine:

	switch (c)
	  {
	  case '+':
	  case '-':
	  case '&':
	  case '|':
	  case '*':
	  case '/':
	  case '%':
	  case '^':
	  case LSHIFT:
	  case RSHIFT:
	  case '<':
	  case '>':
            yylval = 0; break; /* mpp */
	  }	

	token_buffer[1] = c1 = getc (finput);
	token_buffer[2] = 0;

	if (c1 == '=')
	  {
            if (c != LSHIFT && c != RSHIFT) /* mpp */
              echo (c); /* mpp */
            echo (c1); /* mpp */
	    switch (c)
	      {
	      case '<':
		value = ARITHCOMPARE; yylval = 0; goto done; /* mpp */
	      case '>':
		value = ARITHCOMPARE; yylval = 0; goto done; /* mpp */
	      case '!':
		value = EQCOMPARE; yylval = 0; goto done; /* mpp */
	      case '=':
		value = EQCOMPARE; yylval = 0; goto done; /* mpp */
	      }	
	    value = ASSIGN; goto done;
	  }
	else if (c == c1)
	  switch (c)
	    {
	    case '+':
              echo ('+'); echo ('+'); /* mpp */
	      value = PLUSPLUS; goto done;
	    case '-':
              echo ('-'); echo ('-'); /* mpp */
	      value = MINUSMINUS; goto done;
	    case '&':
              echo ('&'); echo ('&'); /* mpp */
	      value = ANDAND; goto done;
	    case '|':
              echo ('|'); echo ('|'); /* mpp */
	      value = OROR; goto done;
	    case '<':
              echo ('<'); echo ('<'); /* mpp */
	      c = LSHIFT;
	      goto combine;
	    case '>':
              echo ('>'); echo ('>'); /* mpp */
	      c = RSHIFT;
	      goto combine;
	    }
	else if ((c == '-') && (c1 == '>'))
	  { echo ('-'); echo ('>'); value = POINTSAT; goto done; } /* mpp */
	ungetc (c1, finput);
	token_buffer[1] = 0;

        if (c != RSHIFT && c != LSHIFT) /* mpp */
          echo (c); /* mpp */
	if ((c == '<') || (c == '>'))
	  value = ARITHCOMPARE;
	else value = c;
	goto done;
      }

    default:
      echo (c); /* mpp */
      value = c;
    }

done:
/*  yylloc.last_line = lineno; */

  return value;
}
short yyexca[] ={
-1, 0,
	0, 1,
	-2, 274,
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 2,
	-2, 274,
-1, 215,
	61, 112,
	59, 112,
	44, 112,
	-2, 282,
-1, 231,
	61, 112,
	59, 112,
	44, 112,
	-2, 282,
-1, 307,
	61, 112,
	59, 112,
	44, 112,
	-2, 282,
-1, 332,
	59, 161,
	44, 161,
	-2, 280,
-1, 333,
	59, 161,
	44, 161,
	-2, 280,
-1, 364,
	257, 280,
	-2, 173,
-1, 365,
	257, 280,
	-2, 173,
-1, 404,
	58, 24,
	-2, 64,
-1, 405,
	58, 25,
	-2, 102,
-1, 452,
	257, 280,
	-2, 283,
-1, 588,
	257, 280,
	-2, 334,
-1, 591,
	257, 280,
	-2, 334,
	};
# define YYNPROD 340
# define YYLAST 1708
short yyact[]={

 383, 656, 658, 554, 256, 380, 493, 423, 298, 354,
 555, 370, 347, 573, 358, 215, 484,  64, 103, 224,
 447, 374, 495, 214, 503, 226,  33, 417, 134, 346,
 407,  70, 483, 156, 141, 488,  34,  35, 406, 132,
 225,  66, 363, 341, 373, 379,  92, 342, 432,  58,
  87, 339, 422,  15, 203,  65,  38, 382, 360,  63,
 155, 511,  67, 343, 112, 557, 310, 416, 114,  16,
  20, 289, 295,  76,  45, 110, 340,  77, 293, 541,
 469, 635,  98, 692, 181, 688, 659,  42,  59, 127,
 183, 120, 557, 479,  57, 557, 557,  74, 636, 190,
 452, 579, 455, 140, 510,   6, 145, 150,  10,   8,
   9, 140, 157, 193, 158, 151, 143, 148, 143, 142,
  93,  52,  53,  32, 198, 119, 200, 663,  81, 125,
 126, 614, 123, 137,  79, 182,  80, 217, 604, 220,
 494, 492, 489, 187, 188, 133, 194, 196, 144, 216,
 208, 159, 161, 212, 537, 311, 192, 157, 193, 158,
 117, 557, 160, 159, 231, 324,  55,  73, 109,  93,
 237, 232, 239,  83,  84,  85,  36,  46, 257, 211,
  29,  27,  28, 263, 138, 228, 557,  71, 115,  72,
 557, 236, 557, 238, 533, 336, 190, 167, 190, 296,
  73, 233, 165, 163, 284, 164, 271, 166, 159, 113,
 242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
 252, 253, 254, 255,  69, 258, 259,   6,  52,  53,
 301,   8,   9, 452,  51, 450, 313, 270, 290, 306,
 318, 536, 291,  47, 307,   3, 505, 312,  11, 319,
 312, 305, 286, 192, 292, 192, 303, 283, 317, 308,
  73, 486, 646, 111, 303, 122,  93, 624,  93, 167,
  93, 180,  93, 371, 165, 163,  73, 164, 366, 166,
 167, 172, 294, 322, 159, 165, 163, 219, 164, 562,
 166, 300, 556, 674, 558, 331, 139,  89, 297, 101,
  52,  53, 199, 120, 102,  59, 348,  99, 338, 350,
 309, 116, 410, 323, 351, 352, 337,  82, 353, 137,
 411, 304, 535, 367, 558, 100, 120, 240, 486, 349,
  25, 368,  23, 162, 357, 332, 333, 174,  29,  27,
  28, 107, 108, 185, 186,  93, 184, 120, 415, 229,
 160, 369,  93,  73,  26, 304, 418, 418, 642, 425,
 364, 356, 522, 439, 431, 285, 430, 372,  52,  53,
 138, 375,  68, 323, 323, 456, 365,  88, 304, 442,
 458, 457, 137, 639, 424, 465, 355, 612, 344, 567,
 474, 375, 471, 316, 210, 364, 448, 453, 438, 426,
 428, 420, 378, 691, 375, 294, 434, 440, 304, 441,
 167, 365, 128, 523,  42, 165, 163, 201, 164, 299,
 166, 462, 424, 375, 464, 449, 454, 202, 459, 487,
 490, 490, 241, 138, 501, 205,  42, 686, 496, 497,
 498, 681, 506, 677, 491, 502, 500, 675,  91, 302,
 667, 451, 329, 288, 171, 170, 168, 169, 551, 335,
 509, 419, 419, 524, 525, 237, 519, 526, 507, 529,
 465, 540, 530, 257, 543, 539, 189, 542, 129, 262,
 504, 545, 534, 549, 140, 527, 236, 548, 553, 521,
 531, 560, 528, 518, 364, 561, 569, 566, 260, 504,
 517, 274, 508, 281, 213, 414, 234, 375, 167, 172,
 365, 421, 664, 165, 163, 572, 164, 550, 166,  19,
 230, 661, 564, 418, 584, 485, 578, 570, 168, 169,
 563, 147, 580, 582, 660, 149, 443, 171, 170, 168,
 169, 234, 315, 581, 655, 654, 576, 588, 647, 577,
 598, 591, 583, 643, 589,  73, 640, 235, 534, 260,
  90, 602, 603, 574, 616, 599, 609, 610, 608, 605,
 137, 223, 277, 272, 683, 273, 504, 617, 601, 452,
 611, 455, 620, 375, 606, 607, 487, 615, 596, 671,
 568, 684, 235, 621, 625, 622, 632, 257, 623, 618,
 631, 633, 629, 634, 626, 627, 637, 638, 630, 628,
 512, 565, 559, 395, 552, 641, 648, 644, 619, 131,
 303, 138, 369, 303, 645, 369, 135, 222, 419, 452,
 159, 455, 147, 650, 575, 532, 547, 669, 334, 652,
 651,  50,  54,  56, 538, 649, 135, 227, 279, 157,
 279, 158, 662, 110, 670, 257, 665, 477, 104, 668,
  98, 147,  96, 106, 476, 105, 673, 468, 170, 168,
 169, 118, 678, 680, 679, 131, 146, 136, 427, 396,
 159, 330, 682, 436, 437,  25,  22,  23,  21, 206,
 130,  39, 571,  29,  27,  28, 666, 136, 110, 544,
 159, 586, 587, 104, 481,  98, 590,  96, 106,  26,
 105, 475, 320, 499, 593, 460,  18, 446,  25,  22,
  23,  21, 689, 279, 396, 690,  29,  27,  28, 118,
 279,  25,  22,  23,  21, 514, 154, 520, 515,  29,
  27,  28,  26, 193, 110, 452, 109, 450, 204, 104,
  71,  98,  72,  96, 106,  26, 105,  79,  48,  80,
 278, 685, 278, 676, 653, 171, 170, 168, 169, 280,
 396,  25, 600,  23,  94, 597, 594, 516, 513,  29,
  27,  28, 361, 445,  25,  22,  23,  21, 193, 444,
 467, 109,  29,  27,  28,  26, 159, 264, 265, 327,
 326,  75,  25,  22,  23,  21, 321, 269,  26, 167,
  29,  27,  28, 672, 165, 110, 268, 267, 118, 166,
 104, 266,  98, 595,  96, 106,  26, 105, 153, 152,
  25, 546,  23, 162, 193, 278, 482, 109,  29,  27,
  28, 396, 278, 473, 472,  84,  85,  25,  44,  23,
  43,  29,  27,  28,  26,  29,  27,  28, 167, 470,
 110, 613, 345, 165, 163, 104, 164,  98, 166,  96,
 106,  26, 105,  62,  49,  30, 381, 404, 405,  22,
  23,  21, 102,  59, 409,  99,  29,  27,  28, 403,
 408, 385, 386, 387, 388, 389, 390, 391, 392, 410,
 394, 393,  26, 100, 209, 193, 110, 411, 109, 412,
 413, 104,  17,  98,   4,  96, 106,  12, 105, 107,
 108, 466, 404,  53, 124,  61,  24, 102,  59,  40,
  99, 287, 207, 121, 403,  60, 385, 386, 387, 388,
 389, 390, 391, 392, 410, 394, 393,  31, 100,   7,
 193, 362, 411, 109, 412, 413, 435, 433, 359, 657,
 402, 401, 400, 451, 107, 108, 304, 466, 404,  53,
 399, 398, 397, 102,  59,  86,  99, 687, 478, 384,
 403, 325, 385, 386, 387, 388, 389, 390, 391, 392,
 410, 394, 393, 463, 100, 276,  78,  95, 411, 109,
 412, 413,  86, 261,  97,  37,  14, 110, 480,  13,
 107, 108, 104,   5,  98,   2,  96, 106,   1, 105,
   0, 110,   0,   0,   0, 429, 104,   0,  98,   0,
  96, 106,   0, 105,   0,   0,   0,   0,   0, 404,
  53,   0,   0,   0, 102,  59,   0,  99,   0,   0,
   0, 403,   0, 385, 386, 387, 388, 389, 390, 391,
 392, 410, 394, 393,   0, 100,   0,   0, 110, 411,
   0, 412, 413, 104,   0,  98,   0,  96, 106,   0,
 105, 107, 108, 191, 101,  25,   0,  23,  94, 102,
  59,   0,  99,  29,  27,  28, 110, 376,   0, 592,
 109, 104,   0,  98,   0,  96, 106,  86, 105,  26,
 100, 376,   0, 461, 109,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 107, 108,   0,   0,
 101,  25,   0,  23,  94, 102,  59,   0,  99,  29,
  27,  28, 110,   0,   0,   0,   0, 104,   0,  98,
   0,  96, 106,   0, 105,  26, 100,   0, 376,   0,
   0, 109,   0,   0,   0,   0,   0,   0,  86, 110,
   0,   0, 107, 108, 104,   0,  98,   0,  96, 106,
   0, 105,   0, 110,   0,   0, 324,   0, 104, 109,
  98,   0,  96, 106,   0, 105, 110,   0,   0,   0,
   0, 104, 585,  98,   0,  96, 106,   0, 105,   0,
 110,   0,   0,   0,   0, 104,   0,  98,   0,  96,
 106,   0, 105,   0,  25,  44,  23,  43,   0, 314,
 377, 101,  29,  27,  28, 109, 102,  59,   0,  99,
   0,   0,   0, 221, 377, 101,   0,   0,  26,   0,
 102,  59,   0,  99,   0,   0, 218, 100, 167, 172,
 110,   0, 109, 165, 163, 104, 164, 197, 166,  96,
 106, 100, 105, 107, 108,   0, 109,   0,   0,  41,
   0,   0, 178,   0, 177,   0,   0, 107, 108, 109,
   0, 377, 101,   0,   0,   0,   0, 102,  59, 277,
  99, 110,   0, 109,   0,   0, 104,   0, 195,   0,
  96, 106,   0, 105,   0, 174,   0,   0, 100,   0,
 101,   0,   0,   0,   0, 102,  59,   0,  99,   0,
   0, 167, 172,   0, 107, 108, 165, 163, 277, 164,
   0, 166,   0,   0,   0, 173, 100,   0,   0,   0,
   0, 277,   0, 109,   0,   0,   0, 177,   0,   0,
   0,   0, 107, 108,   0, 328, 101,   0,   0,   0,
   0, 102,  59,   0,  99,   0,   0,   0,   0,   0,
   0, 167, 172,   0,   0,   0, 165, 163, 174, 164,
   0, 166, 100, 101, 109,   0,   0,   0, 102,  59,
   0,  99,   0,   0, 282,   0,   0, 101, 107, 108,
   0,   0, 102,  59,   0,  99,   0, 275, 173, 100,
 101,   0,   0,   0,   0, 102,  59,   0,  99,   0,
   0,   0,   0, 100, 101, 107, 108,   0, 174, 102,
  59,   0,  99,   0,   0,   0, 100, 167, 172, 107,
 108,   0, 165, 163,   0, 164,   0, 166,   0,   0,
 100,   0, 107, 108,   0,   0,   0,   0, 173,   0,
   0,   0,   0,   0,   0,   0, 107, 108,  25,  44,
  23,  43,   0,   0, 101,   0,  29,  27,  28, 102,
  59,   0,  99,   0,   0,   0, 280,   0,  25,   0,
  23,  94,  26,   0, 174,   0,  29,  27,  28,   0,
 100,   0, 179, 176, 175, 171, 170, 168, 169,   0,
   0,   0,  26,   0,   0, 101, 107, 108,   0,   0,
 102,  59,   0,  99, 173, 280,   0,  25,   0,  23,
  94,   0,   0,   0,   0,  29,  27,  28, 280,   0,
  25, 100,  23,  94,   0,   0,   0,   0,  29,  27,
  28,  26,   0,   0,   0,   0,   0, 107, 108,   0,
   0,   0,   0,   0,  26,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 176, 175, 171, 170,
 168, 169,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 175, 171, 170,
 168, 169,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 171, 170, 168, 169 };
short yypact[]={

-176,-1000,-176,-1000,-1000, 460, 835,-134,-1000,-1000,
-1000,-1000,-1000,-1000,-1000, 632,1220,-1000, 118,-1000,
-1000,-1000,-1000,-1000,-1000,-1000, 834, 111,  43, -29,
-175, 833,-1000,-1000,-1000,-1000,-1000,-1000, 710,-1000,
-1000,-1000,-1000,-1000,-1000, 717,-1000,-1000, -86, 873,
 140,-1000,-1000,-1000,  86,-1000,  65,-136,  84,-1000,
   9,-127,-1000,-1000,-1000,-1000, 631,-111,-1000, 606,
 342, 710,-1000,-139, 717, -86, 617, 279,-1000, 717,
-1000,-141,-1000,-1000,-1000,-1000,-1000, 788, 787, 692,
 609,  72,1221,-1000,-1000,  44,1177,1177, 827,1268,
1227,-1000,-1000,-172,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-136, 704,-1000, 374, 630,
-1000,-1000,-1000,-1000, 138,-1000,-1000,-1000,-1000,-1000,
-1000, 710,-1000,-1000,-1000,-1000,1163,-1000,1150, 586,
 530,-1000,-1000,-1000, 588,  93,-1000, 710,-1000,-1000,
-1000,-1000,-1000,-1000,1177,-1000, 466, 609,-1000, 234,
-1000,-1000,-1000,1177,1177,1177,1177,1177,1177,1177,
1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,
 585,1177,1177,-136,-136,-1000,-1000,-1000,-1000, 780,
 776, 775, 766, 112,-1000, 827,-1000, 827,-1000,1292,
-1000,1279, 704,  79,-136,1177,-1000, -54,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-209,-1000, 205,-1000,-1000,
 198,-1000,-1000,-1000, 147,-1000,-1000,-1000,-1000,-1000,
-1000,-209,  94,1221,-1000,1136, 501,-1000,-1000,1177,
-1000, 585, 772, 772,-1000,-1000,-1000, 821, 821, 232,
 373, 160, 243, 471,1410,1344, 654,-1000,1221,1221,
-1000, 765, 692, 190,-1000,-1000,1063,-1000,-1000,-1000,
-1000,-1000, 759, 758,1240,-1000, 622,-1000,-1000, 572,
-1000, 513,-1000,  70,-1000,-1000,1221,-1000,-1000,-1000,
-1000,-1000,-1000, 544, 327, 822,-1000,-1000,-1000,-1000,
-1000,-1000, 606, 342,-1000,-1000,-1000,-209,-1000, 544,
 273,-1000, 526, 185,-1000,-1000,-1000, 117, 180,-1000,
1177,-1000,-1000,-1000,1035, 620,  42,  42,-1000,-1000,
-1000,-1000, 710, 710,-1000,-1000,-1000,-1000,-209,-1000,
 544,-1000, 619, 966,1035,-175,-1000, 427,-1000,-1000,
-1000,-1000,-1000,-1000,-1000, 544,-1000,1035,-1000,-1000,
 748, 742, 673,-1000, 193, 589,-1000,-1000,-1000, 466,
-1000,-1000,1294, 671,-1000,1221, 988,-1000, 620, 665,
-1000,-1000,-1000, 608,-190, 819, 782, 804, 803,1177,
 653, 605, 598,-168,-136, 646,-1000,-1000,-1000,-1000,
-1000,-1000,-1000, 796,-1000,-1000, 269,-114,-115,-116,
-1000,-1000,-1000,-1000,-1000,-1000, 669,-1000,-1000,-139,
 669,-1000, -10,-1000,-1000,-1000, 710,-1000, 717,-1000,
-1000,  63,-1000,-1000, 737, 694, 736,-1000,-1000,-1000,
-1000, -10,-1000,-1000,-1000,-1000, 473, 322, 342,-1000,
-1000,-1000, 539, 342,-1000,-1000,-1000,-1000,-1000,  69,
1035,-1000, 197,  29, 711,-1000,-1000,-1000,-1000, 782,
1177,-192,1177,1177, 641, 782,-1000,-1000, 791,-1000,
 577, 782,1177,-1000, 202, 555,-1000,1177,  36, 553,
1177,  33, 552, 133, 531,1177,-1000,-1000,-1000, 710,
-1000, 634,-1000,-1000,-1000,  35,-1000, 575, 487, 342,
-1000,-1000,-1000,-1000,-1000,-156,-1000,-1000, -10,-1000,
-1000,-1000,-1000,1109,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000, 974,-1000,-1000,-1000,
 735, 783, 529, 734, 782,-1000,-175,-1000,-1000, 731,
-1000, 519,-1000,-1000,-1000,-118, 510,-1000,-1000,-1000,
-1000,-1000, 507, 131,-125,-1000,-1000, 505,-1000,-1000,
-1000,1177,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000, 174,-1000,-1000,-1000, 705,-1000,
-1000,  60,-1000,-1000, 782,1177,1177, 782,-1000,  40,
 782,-1000,-1000, 127, 497,-1000,-1000,-1000,-1000,-1000,
-1000, 102, 494,   6, 489,1177,-1000,-1000,-1000,1221,
 587,-209,-1000,-1000,-1000,-1000,-1000,-1000, 322,-1000,
-1000,-1000, 723, 486,-1000, 485,-177,-1000,-1000, 475,
-1000,-1000, 462,-1000,-1000,-129, 453,-1000,-1000,1177,
-1000,-1000,-1000, 391,1177,-1000, 596, 545,-1000, 773,
-1000,-1000,  37, 388,-1000,-1000,1221,-1000, 722, 384,
-177,-177,1177,-1000, 382,-1000, 782,-1000, 533,-1000,
 720,-1000,-1000, 378,-178,-1000,-1000, 681,-1000, 344,
-180,-1000,-1000 };
short yypgo[]={

   0,1018,1015, 245, 914,1013,1009, 176,  17, 412,
1006,1005,  18, 912,  56,  73,  63,  47,  41,  23,
  39,  15,  78,  51,  52,  24,  13,  31, 613,1004,
   0, 297,1003,  46, 997, 377,  44,  54,   4,  57,
  76,  43,  70, 758, 317, 560, 271, 448, 926, 372,
  28, 996,  66,  21, 224, 149, 199,  29,  48,  61,
  14,   8,  34,  19,  11, 128,  40,  25,  12,   9,
  20, 302, 311, 995,  67,  27, 160,  60,  33, 155,
  45,   5, 993, 981, 979, 978,   1, 977, 972, 971,
 970, 962, 961, 960, 959,   2, 958, 957,  58, 956,
 951,  42, 949, 947, 935, 933, 932, 931,  26, 925,
 924, 904,  22,   7,  38,  32,  16,  30,  35,   3,
  10,   6, 890, 884, 861 };
short yyr1[]={

   0,   1,   1,   2,   2,   2,   2,   3,   3,   3,
  10,  10,  10,  10,  10,  10,  10,  10,   6,   6,
   6,   6,   6,   6,  28,  28,  29,  29,  29,  29,
  29,  29,  29,  30,  32,  32,  31,  31,  33,  33,
  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
  33,  33,  33,  33,  34,  34,  34,  34,  34,  34,
  34,  34,  34,  34,  34,  34,  12,  12,  23,  23,
  40,  40,  14,  41,  41,  41,  41,  17,  17,  43,
  43,  43,  16,  16,  16,  16,  45,  45,  46,  46,
  42,  42,  42,  42,  42,  44,  44,  44,  18,  18,
  15,  15,  52,  52,  49,  49,  51,  51,  53,  53,
  53,  53,  53,  36,  36,  19,  19,  54,  54,  54,
  54,  54,  54,  70,  70,  70,  70,  70,  27,  27,
  27,  27,  27,  27,  48,  48,  48,  48,  48,  48,
  48,  48,  48,  37,  37,  71,  71,  71,  73,  73,
  73,  74,  74,  74,  75,  75,  75,  72,  72,  76,
  76,  35,  35,  77,  77,  47,  47,  63,  63,  78,
  78,  78,  78,  78,  78,  78,  78,  78,  80,  80,
  80,  80,  82,  82,  83,  25,  25,  25,  39,  39,
  39,  84,  81,  81,  81,  81,  81,  81,  81,  81,
  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,
  81,  81,  81,  81,  81,  81,  81,  85,  85,  38,
  38,  86,  86,  94,  94,  95,  87,  87,  79,  57,
  97,  97,  97,  96,  96,  98,  98,  98, 100, 100,
 101, 101, 101, 101, 101,  99,  99,  13,   4,   4,
 102, 103, 103, 104, 104, 104, 104, 109, 110, 111,
 105, 106, 106, 107,   5,   5,   5, 108, 112, 113,
  65,  11,  22,  68,   7,  88,  88,  88,  88, 114,
 116, 115,  89,  89,  89,  89,  89,  89, 117, 118,
 120, 121, 119,  90,  90,  90, 122,  91,  91,  91,
 123,  92,  92,  92,  92,  93,  93,  93,  93,  93,
  93, 124,  24,  26,  62,  66,  67,  50,   8,  55,
  59,  20,  60,  61,  64,  69,  56,  58,  21,   9 };
short yyr2[]={

   0,   0,   1,   1,   1,   2,   2,   5,   5,   5,
   4,   5,   4,   2,   2,   2,   2,   1,  10,   4,
  11,   5,  10,   4,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   0,   1,   1,   3,   1,   2,
   2,   4,   7,   2,   4,   2,   4,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   5,   3,   3,   1,   1,   1,   3,   3,   3,
   4,   4,   3,   3,   2,   2,   1,   2,   0,   1,
   2,   3,   0,   4,   4,   2,   2,   2,   3,   0,
   2,   2,   1,   1,   2,   2,   2,   3,   0,   2,
   1,   1,   1,   4,   4,   1,   1,   1,   2,   4,
   2,   4,   0,   4,   6,   4,   6,   4,   1,   2,
   3,   4,   1,   1,   3,   1,   1,   3,   8,   5,
   4,   5,   6,   4,   5,   4,   5,   5,   8,   3,
   5,   5,   4,   5,   7,   6,   2,   7,   6,   2,
   6,   5,   2,   0,   1,   0,   4,   3,   3,   3,
   1,   0,   2,   4,   2,   4,   6,   1,   3,   1,
   3,   2,   2,   0,   1,   1,   2,   0,   2,   3,
   5,   4,   4,   5,   4,   4,   6,   3,   1,   2,
   2,   1,   0,   1,   0,   1,   2,   1,   2,   7,
   6,   5,   1,   2,   3,   1,   5,   7,   9,   5,
   4,   3,   2,   2,   6,   8,  10,  12,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   0,   1,   0,
   1,   0,   1,   1,   3,   4,   1,   3,   3,   3,
   2,   2,   2,   2,   2,   0,   1,   3,   1,   3,
   5,   5,   3,   5,   3,   1,   3,   0,   6,   4,
   2,   0,   2,   0,   3,   2,   3,   2,   2,   2,
   2,   0,   2,   2,   0,   2,   2,   0,   0,   0,
   0,   0,   0,   0,   0,   2,   3,   3,   4,   1,
   3,   1,   3,   5,   3,   4,   5,   6,   2,   3,
   2,   3,   2,   3,   3,   4,   2,   3,   3,   4,
   2,   4,   5,   5,   6,   5,   7,   5,   6,   7,
   8,   3,   1,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 };
short yychk[]={

-1000,  -1,  -2,  -3,  -4,  -5, 281,-102, 285, 286,
 284,  -3,  -4,  -6, -10, -17, -16, -13, 256,  59,
 -42, 261, 259, 260, -48, 258, 282, 267, 268, 266,
  40,-103, 257,-108,-108,-108,  -7, -11, -14,  59,
 -13,  59, -42, 261, 259, -14,  59, 125, -43,  40,
 -28, 123, 257, 258, -28, 123, -28, 123, -12, 263,
-104,-109,  40,-108,  -8,  -8, -18, -19, -49, -54,
 -27,  40,  42, -65, -14, -43, -15, -27, -51,  40,
  42, -65, -44, 259, 260, 261, -48, -30, -35, -31,
 -45, -47, -33, -42, 261, -34,  42, -29,  40, 265,
 283, 257, 262, -12,  38,  45,  43, 299, 300, 126,
  33, 123, -68, 123, -68, 123, -72, -76, -28,  41,
 263,-105, 256, 123,-110, 256, 257,-108,  -9,  -9,
  59,  44, -20, 256, -50,  40,  91,  40,  91, -54,
 -27, -62, 258, 257, -15, -27,  59,  44, -20, 256,
 -50, -62,  41,  41,  44, -77, -78,  40,  42,  91,
 -42, -77, 261,  43,  45,  42,  47,  37, 296, 297,
 295, 294,  38, 124,  94, 293, 292,  63,  61, 291,
 -46,  40,  91,  46, 302, 299, 300, -33, -33, -35,
 -30, 256, -39, 123, -33,  40, -33,  40, -68, -71,
 -68, -71, -72, -37,  44,  61,  59,-106,-108,-111,
 256,  41,-108, -49, -19, -21, -55, -30,  93, -55,
 -30,  93,  41,  41, -63, -66, -67,  59, -20, 256,
 -49, -21, -63, -33,  40,  91, -78, -68, -62, -68,
  93, -46, -33, -33, -33, -33, -33, -33, -33, -33,
 -33, -33, -33, -33, -33, -33, -38, -30, -33, -33,
 -44, -32, -31, -30, -28, -28,  41,  41,  41,  41,
 125, -68, -35, -35, -71, 125, -73,  59, -45, -47,
 256, -71, 125, -37, 125, -76, -33,-107,  -3, 125,
-108, -50, -20, -22, -52, 281, -56,  93, -61, -56,
  93, -61, -54, -27, 261, -67, -68, -21, -50, -22,
 -52, -79, -68, -30,  93,  41, -79, -63, -30, -61,
  58,  41,  93, -33, 123, -83,  41,  41, 125,  -7,
  59,  -8, -14, -14, 125,  -7, 125,-108, -21, -23,
 -40, -41, -17, -16,  61,  40, -57, -68, -61, -57,
 -61, -64, -64, -68, -69, -22, -23,  61, -60, -96,
 -98, 256,-100,-101, -17, -16,  93, -61, -60, -78,
 -64,  93, -33, -36, -53, -33, 123, 256, -40, -80,
 -81, 256, -39, -30, -84, 271, 272, 273, 274, 275,
 276, 277, 278, 281, 280, -28,  59, -88, -89, -90,
 -91, -92, -93, 269, 257, 258,-114,-117,-122,-123,
 279, 287, 289, 290,  -7,  -8, -74, -75, -19, -65,
 -74,  -7, -24,-113, -41,  -8, -14,  59, -14,  59,
 -53, -12, -58, -97, -98, -99, 256, 257, -58, -69,
 -23, -24, -53,  -7,  41,  41,  44, -70, -27, -77,
  42, 258,  40, -27, -77,  42, -61, -64, -61, -37,
  44, 125, -36, -82, -80, -81, 256, 125,  59, 270,
  40, -81,  40,  40, -30,  58,  59,  59, -85, 261,
 -28,  58,  40,-115,-116, 256,  59,-112,-118, 256,
-112,-118, 256,-121, 256,-112,-108,-108,-108,  44,
 -50, -21, -67, -25, -39, 256,  -8, -18, -15, -27,
  41, -59,  -7,  41,  41,  44,  41, -59, -24, -25,
 264,-101,  40,  91, -21, -21,  -8, -62, -66, -21,
  -8, -62,  -7, 125, -53, 125,  44, 125,  -7, -81,
 -30, 271, -38, -30,  58, -81,  40,  59, -81, -30,
-115, 256,  59, -30,-119,-120, 256,  59, 288,  59,
 -30,-119, 256,-114,-117,  59,-119, 256,  59, -30,
 -75,  58, -68, -26, -39,  59,  59, -20, -60, 257,
 -60, -25, -26, -57, -30,  93,  -7,  -7, -63, -67,
  -7, -63, 125,  -7,  41,  40,  59,  41, -81, -12,
  41,  59,-113,-121, 256,  59,-108,-108,-113,  59,
-119,-116, 256,-124, 256,-112,  59,-113, -50, -33,
 -69, -21, -26, -60,  93, -61,  -8,  -8, -70, -68,
  -8, -81, -30, -38, -81,  41,  58, -81,-119, 256,
  59,-119, 256,  59,-119,-120, 256,  59, -30,  58,
 -61, -64, -69,  41,  59,  59, -86, -94, -95, 263,
  59,  59,-121, 256,  59,-113, -33,  59, -38,  41,
  58,  44,  40,-119, 256,  59,  41,  59, -86, -95,
 -30,  59, -81,  41,  58,  41,  59, -87, 263,  41,
  44,  59, 263 };
short yydef[]={

  -2,  -2,  -2,   3,   4, 257,   0, 261, 277, 277,
 277,   5,   6, 284, 281,  82, 257,  82,   0,  17,
  89,  92,  93, 100, 101, 102,   0,   0,   0,   0,
   0, 263, 277, 275, 276, 260, 328, 328, 280,  14,
  82,  13,  89,  94,  95, 280,  15,  16,  87,   0,
 146, 283,  24,  25, 149, 283, 152,   0,   0,  76,
   0,   0, 277, 262, 339, 339,   0, 331, 327, 125,
 126, 280, 324,   0, 280,  88,   0, 331, 327, 280,
 324,   0,  90,  91, 105, 106, 107,   0,   0,  33,
 173, 173,  36,  98, 175,  38,   0,   0,   0,   0,
   0,  64,  65,  66,  26,  27,  28,  29,  30,  31,
  32, 283, 155, 283, 155,   0, 153, 167, 169,   0,
  77, 271, 259, 277,   0, 265, 277, 267,   7,   8,
  12, 280, 338,  19, 108, 329,   0, 329,   0,   0,
   0, 177, 325, 326,   0, 331,  10, 280, 338,  23,
 110, 177, 103, 104,   0, 171, 174, 283, 324, 283,
  98, 172, 176,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 229,   0,   0,
  96,  34,   0,   0,   0,  74,  75,  39,  40,   0,
   0,   0,   0, 283,  43,   0,  45,   0, 155,   0,
 155,   0, 153,   0, 154,   0,   9, 274, 270, 264,
 266, 277, 268, 327, 331,  -2, 336,   0, 333, 336,
   0, 333, 127, 139, 280, 326, 283,  11, 338,  21,
 327,  -2, 280,  37, 283,   0,   0, 283, 177,   0,
 333,  97,  47,  48,  49,  50,  51,  52,  53,  54,
  55,  56,  57,  58,  59,  60,   0, 230,  62,  63,
  99,   0,  35,   0,  72,  73,   0,  67,  68,  69,
 198, 194,   0,   0,   0, 284,   0, 328,  82,  82,
 160,   0, 284,   0, 151, 168, 170, 258, 272, 277,
 269, 109, 338,  78, 115,   0, 283, 333, 130, 283,
 333, 142, 334, 334, 178, 283, 335,  -2, 111,  78,
 117, 332, 245,   0, 333, 179, 332, 334,   0, 187,
   0,  70,  71,  41,   0,   0,  44,  46, 284, 145,
 328, 157,  -2,  -2, 284, 148, 150, 273, 112, 279,
  79, 328,  82,  82,   0,   0, 337, 245, 129, 337,
 141, 131, 140, 335, 143,  78, 279,   0, 182, 284,
   0,   0, 246, 248,  -2,  -2, 333, 184, 185, 334,
 181, 333,  61, 153, 123, 118,   0, 122, 192,   0,
 188, 191, 202,   0, 205,   0,   0,   0,   0,   0,
   0,   0,   0, 227,   0,   0, 220, 221, 222, 223,
 224, 225, 226,   0,  -2,  -2, 278, 278, 278, 278,
 289, 277, 277, 277, 144, 156, 158, 327, 338, 326,
 159, 147,   0, 322, 328,  80, 280,  85, 280,  86,
 114,   0, 330, 284,   0,   0,   0, 255, 330, 132,
 279,   0, 116, 238, 243, 244,   0, 338, 338, 328,
 324, 325,  -2, 338, 328, 324, 183, 180, 284,   0,
 154, 119,   0,   0, 193, 189, 190, 284, 203,   0,
   0,   0, 229,   0,   0,   0, 212, 213,   0, 228,
   0,   0,   0, 285,   0,   0, 291,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 298, 306, 310, 280,
 162, 164, 283, 323, 195, 197,  81,   0,   0, 331,
 113, 332, 239, 240, 241,   0, 242, 332,   0, 323,
 247, 249, 283,   0, 284, 284, 252, 177, 326, 284,
 254, 177, 186,  42, 124, 120,   0, 284, 200, 204,
   0,   0,   0,   0,   0, 211,   0, 218, 219,   0,
 286,   0, 287, 279, 292, 278,   0, 277, 277, 294,
 279, 303,   0, 278, 278, 304, 307,   0, 308, 279,
 327,   0, 335,  18, 196,  83,  84, 338, 128, 256,
 138, 323,  22, 332,   0, 333, 328, 328,  -2, 283,
 328,  -2, 121, 199,   0,   0, 229,   0, 210,   0,
   0, 288, 290,   0,   0, 295, 302, 300, 299, 305,
 311,   0,   0,   0,   0,   0, 309, 301, 163, 165,
   0, 112,  20, 133, 333, 135, 250, 251, 334, 335,
 253, 206,   0,   0, 209,   0, 231, 201, 293,   0,
 296, 312,   0, 313, 315, 278,   0, 317, 279,   0,
 134, 136, 137,   0, 229, 214,   0, 232, 233,   0,
 297, 314,   0,   0, 318, 321, 166, 207,   0,   0,
 231,   0,   0, 316,   0, 319,   0, 215,   0, 234,
   0, 320, 208,   0,   0, 235, 216,   0, 236,   0,
   0, 217, 237 };
/* $Copyright:	$
 * Copyright (c) 1984, 1985 Sequent Computer Systems, Inc.
 * All rights reserved
 *  
 * This software is furnished under a license and may be used
 * only in accordance with the terms of that license and with the
 * inclusion of the above copyright notice.   This software may not
 * be provided or otherwise made available to, or used by, any
 * other person.  No title to or ownership of the software is
 * hereby transferred.
 */

#ifndef lint
static char yaccpar_rcsid[] = "$Header: yaccpar 2.1 86/04/28 $";
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps >= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 64:
# line 260 "c-parse.y"
{ if ( ! strcmp( "U_CONDITION", last_id ) ) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     generate_cond_init(); } } break;
case 91:
# line 320 "c-parse.y"
{ if (( enum rid )yypvt[-0] == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } break;
case 93:
# line 331 "c-parse.y"
{ if (( enum rid )yypvt[-0] == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } break;
case 95:
# line 335 "c-parse.y"
{ if (( enum rid )yypvt[-0] == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } break;
case 100:
# line 358 "c-parse.y"
{ if (( enum rid )yypvt[-0] == RID_VOID && void_seen < level ) /* mpp */
		     void_seen += level; } break;
case 102:
# line 362 "c-parse.y"
{ int type = typedef_type (last_id); /* mpp */
		  if (type == 1 && void_seen < level ) /* mpp */
		     void_seen += level; /* mpp */
		  else if (type == -1 && condition_seen < level) { /* mpp */
		     if (monitor_seen == 0)
		        error("uCondition MAY ONLY BE USED INSIDE A MONITOR", 0, 0); /* mpp */
		     else /* mpp */
		        condition_seen += level;
		  } else if ( ! strcmp( last_id, "uCondition" ) && condition_seen < level ) /* mpp */
		     if (monitor_seen == 0)
		        error("uCondition MAY ONLY BE USED INSIDE A MONITOR", 0, 0); /* mpp */
		     else /* mpp */
		        condition_seen += level; } break;
case 129:
# line 445 "c-parse.y"
{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; } break;
case 130:
# line 448 "c-parse.y"
{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; } break;
case 132:
# line 452 "c-parse.y"
{ if ( entry_type == 1 ) {
		     if ( entry_name ) free( entry_name );
		     entry_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( entry_name, last_id );
		     entry_type = 2;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     back_mark = 0;
		     mark = 0;
		  } else if (condition_seen == 1 && typedef_seen == 0 && level == 2) {
		     if ( cond_name ) free( cond_name );
		     cond_init_count = -1;
		     cond_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( cond_name, last_id ); } } break;
case 141:
# line 495 "c-parse.y"
{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; } break;
case 142:
# line 498 "c-parse.y"
{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; } break;
case 143:
# line 501 "c-parse.y"
{ if ( entry_type == 1 ) {
		     if( entry_name ) free( entry_name );
		     entry_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( entry_name, last_id );
		     entry_type = 2;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     back_mark = 0;
		     mark = 0;
		  } else if (condition_seen == 1 && typedef_seen == 0 && level == 2) {
		     if ( cond_name ) free( cond_name );
		     cond_init_count = -1;
		     cond_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( cond_name, last_id ); } } break;
case 257:
# line 792 "c-parse.y"
{ if (entry_seen == 1)
		     add_type_int(); } break;
case 258:
# line 798 "c-parse.y"
{ monitor_seen = 0; } break;
case 259:
# line 800 "c-parse.y"
{ error( "Invalid uMonitor statement", 0, 0 );
		  monitor_seen = 0; } break;
case 260:
# line 806 "c-parse.y"
{ monitor_seen = 1; } break;
case 261:
# line 811 "c-parse.y"
{ if ( monitor_name ) free( monitor_name );
		  monitor_name = ( char * )xmalloc( 7 + 1 );
		  sprintf( monitor_name, "ANON%d", ++anon_cnt ); } break;
case 262:
# line 815 "c-parse.y"
{ if ( monitor_name ) free( monitor_name );
		  monitor_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		  strcpy( monitor_name, last_id ); } break;
case 263:
# line 822 "c-parse.y"
{ MonType = PriorityBlocking; } break;
case 265:
# line 825 "c-parse.y"
{ MonType = PriorityBlocking;
		  error( "Invalid uMonitor statement", 0, 0 ); } break;
case 266:
# line 828 "c-parse.y"
{ error( "Invalid uMonitor statement", 0, 0 ); } break;
case 268:
# line 837 "c-parse.y"
{ mon_type( last_id ); } break;
case 270:
# line 846 "c-parse.y"
{ generate_begin_monitor(); } break;
case 273:
# line 856 "c-parse.y"
{ generate_end_monitor(); } break;
case 275:
# line 862 "c-parse.y"
{ if (monitor_seen == 1) {
		     entry_seen = 1;
		     void_entry = 0;
		     no_echo = 1;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     entry_type = 1;
		  } else
		     error("ENTRY CAN ONLY BE USED IN A MONITOR", 0, 0); } break;
case 276:
# line 872 "c-parse.y"
{ if (monitor_seen == 1)
		     local_seen = 1;
		  else
		     error("LOCAL CAN ONLY BE USED IN A MONITOR", 0, 0); } break;
case 277:
# line 880 "c-parse.y"
{ PrBuffer[0] = '\0';
		  PrBuffer_length = 0; } break;
case 278:
# line 886 "c-parse.y"
{ no_echo = 1; 
		  MonBuffer[0] = '\0';
		  MonBuffer_length = 0;
		  if (PrBuffer_length > 0)
		     no_echo = 2; } break;
case 279:
# line 895 "c-parse.y"
{ no_echo = 0; } break;
case 280:
# line 900 "c-parse.y"
{ if (entry_type == 1) {
		     if ( FrontType ) free( FrontType );
		     FrontType = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( FrontType, MonBuffer ); } } break;
case 281:
# line 908 "c-parse.y"
{ if (monitor_seen == 1 && (entry_seen == 1 || local_seen == 1))
		     error("ENTRY OR LOCAL MUST PRECEDE A MONITOR ROUTINE", 0, 0); } break;
case 282:
# line 914 "c-parse.y"
{ if (monitor_seen == 1) {
		     monitor_seen = 2;
		     if (entry_seen == 0 && local_seen == 0) {
		        error("MONITOR ROUTINE WITHOUT ENTRY OR LOCAL - ASSUME LOCAL", 0, 0);
		        local_seen = 1; } } } break;
case 283:
# line 923 "c-parse.y"
{ level *= 2; 
		  push_level(); } break;
case 284:
# line 929 "c-parse.y"
{ level /= 2;
		  pop_level(); } break;
case 285:
# line 935 "c-parse.y"
{ if (entry_seen == 1)
		     generate_return(void_entry, 0); } break;
case 286:
# line 938 "c-parse.y"
{ if (entry_seen == 1)
		     generate_return(void_entry, 1, MonBuffer ); } break;
case 287:
# line 941 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID RETURN STATEMENT", 0, 0); } break;
case 288:
# line 944 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID RETURN STATEMENT", 0, 0); } break;
case 289:
# line 950 "c-parse.y"
{ if (entry_seen == 1) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0; } } break;
case 290:
# line 957 "c-parse.y"
{ if (entry_seen != 1)
		     fprintf(foutput, "%s", MonBuffer); } break;
case 291:
# line 963 "c-parse.y"
{ if (entry_seen == 1) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0; } } break;
case 292:
# line 970 "c-parse.y"
{ if (monitor_seen == 2 )
		     generate_wait_on( CondName, "0" ); } break;
case 293:
# line 973 "c-parse.y"
{ if (monitor_seen == 2 )
		     generate_wait_on( CondName, MonBuffer); } break;
case 294:
# line 976 "c-parse.y"
{ if (monitor_seen == 2 ) 
                     error("INVALID uWait STATEMENT", 0, 0); } break;
case 295:
# line 979 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); } break;
case 296:
# line 982 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); } break;
case 297:
# line 985 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); } break;
case 298:
# line 991 "c-parse.y"
{ if (monitor_seen != 2)
		      error("uWait MUST BE IN A MONITOR ROUTINE", 0, 0); } break;
case 299:
# line 997 "c-parse.y"
{ if (monitor_seen == 2) {
		     if ( CondName ) free( CondName );
		     CondName = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( CondName, MonBuffer ); } } break;
case 303:
# line 1017 "c-parse.y"
{ if (monitor_seen == 2)
		      generate_notify( CondName ); } break;
case 304:
# line 1020 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uSignal STATEMENT", 0, 0); } break;
case 305:
# line 1023 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uSignal STATEMENT", 0, 0); } break;
case 306:
# line 1029 "c-parse.y"
{ if (monitor_seen != 2)
		      error("uSignal MUST BE IN A MONITOR ROUTINE", 0, 0);
		  else if ( MonType == PriorityAutomaticSignal || MonType == NoPriorityAutomaticSignal ) 
		      error("uSignal IS NOT MEANINGFUL IN A AutomaticSignal MONITOR", 0, 0);
		  else if ( entry_seen == 0 && ( MonType == PriorityImmediateReturn || MonType == NoPriorityImmediateReturn ) )
		      error("uSignal MUST BE IN AN ENTRY ROUTINE FOR Immediate Return MONITOR", 0, 0); } break;
case 307:
# line 1039 "c-parse.y"
{ if ( monitor_seen == 2 && ( MonType == PriorityAutomaticSignal || MonType == NoPriorityAutomaticSignal ) )
		      generate_wait_until( MonBuffer ); } break;
case 308:
# line 1042 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uWaitUntil STATEMENT", 0, 0); } break;
case 309:
# line 1045 "c-parse.y"
{ if (monitor_seen == 2) 
                     error("INVALID uWaitUntil STATEMENT", 0, 0); } break;
case 311:
# line 1055 "c-parse.y"
{ if (monitor_seen == 2)
		      generate_notify_return( CondName, void_entry, 0 ); } break;
case 312:
# line 1058 "c-parse.y"
{ if (monitor_seen == 2)
		      generate_notify_return( CondName, void_entry, 1, MonBuffer ); } break;
case 313:
# line 1061 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and return STATEMENT", 0, 0); } break;
case 314:
# line 1064 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and return STATEMENT", 0, 0); } break;
case 315:
# line 1070 "c-parse.y"
{ if (monitor_seen == 2)
		      generate_notify_wait_on( CondName, CondName2, "0" ); } break;
case 316:
# line 1073 "c-parse.y"
{ if (monitor_seen == 2)
		      generate_notify_wait_on( CondName, CondName2, MonBuffer ); } break;
case 317:
# line 1076 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); } break;
case 318:
# line 1079 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); } break;
case 319:
# line 1082 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); } break;
case 320:
# line 1085 "c-parse.y"
{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); } break;
case 321:
# line 1091 "c-parse.y"
{ if (monitor_seen == 2) {
		     if ( CondName2 ) free( CondName2 );
		     CondName2 = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( CondName2, MonBuffer ); } } break;
case 322:
# line 1099 "c-parse.y"
{ if (entry_seen == 1) {
		      generate_begin_entry( void_entry, FrontType, BackType, MonBuffer );
		      entry_type = 0; } } break;
case 323:
# line 1106 "c-parse.y"
{ if (entry_seen == 1)
		      generate_end_entry( void_entry ); } break;
case 324:
# line 1112 "c-parse.y"
{ if (star_seen < level) 
		     star_seen += level; } break;
case 325:
# line 1118 "c-parse.y"
{ modify_typedef(last_id); } break;
case 326:
# line 1123 "c-parse.y"
{ if (typedef_seen >= level) 
		     if (void_seen >= level && star_seen < level)
		        add_typedef(last_id, 1);
		     else if (condition_seen >= level && star_seen < level)
		        add_typedef(last_id, -1);
		     else
		        add_typedef(last_id, 0); } break;
case 327:
# line 1134 "c-parse.y"
{ pop_level();
		  identifier %= level;
		  function %= level;
		  pointer %= level;
		  vector %= level;
		  typedef_seen %= level;
		  condition_seen %= level;
		  void_seen %= level;
		  star_seen %= level;
		  level /= 2; } break;
case 328:
# line 1148 "c-parse.y"
{ identifier %= level;
		  function %= level;
		  pointer %= level;
		  vector %= level;
		  typedef_seen %= level;
		  condition_seen %= level;
		  void_seen %= level;
		  star_seen %= level; } break;
case 329:
# line 1160 "c-parse.y"
{ if (entry_type == 2 && mark == 0) {
		     mark = 1;
		     back_mark = MonBuffer_length; } } break;
case 330:
# line 1167 "c-parse.y"
{ if (mark == 1) {
		     mark = 2;
		     if (identifier >= level) {
			if ( BackType ) free( BackType );
			BackType = ( char * )xmalloc( back_mark + 1 );
			strncpy( BackType, MonBuffer, back_mark );
			BackType[back_mark] = '\0';
		     } else {
			if ( BackType ) free( BackType );
			BackType = ( char * )xmalloc( MonBuffer_length + 1 );
			strcpy( BackType, MonBuffer ); } } } break;
case 331:
# line 1182 "c-parse.y"
{ entry_type = 3;
		  if (entry_seen == 1 && void_seen == 1)
		     if (level == 2 && pointer == 0)
		        void_entry = 1; } break;
case 332:
# line 1190 "c-parse.y"
{ if (function < level) {
		     if (vector >= level)
		        vector -= level;
		     else if (pointer >= level)
			pointer -= level;
		     else if (identifier >= level)
		        identifier -= level;
		     function += level; } } break;
case 333:
# line 1202 "c-parse.y"
{ if (identifier >= level) {
		     identifier -= level;
		     if (arg_list == 0)
		        vector += level;
		     else
		        pointer += level;
		  } else if (function >= level) {
		     function -= level;
		     pointer += level; } } break;
case 334:
# line 1215 "c-parse.y"
{ if (pointer < level) {
		     if (vector >= level)
		        vector -= level;
		     else if (function >= level)
			function -= level;
		     else if (identifier >= level)
		        identifier -= level;
		     pointer += level; } } break;
case 335:
# line 1227 "c-parse.y"
{ identifier += level; } break;
case 336:
# line 1232 "c-parse.y"
{ arg_list += level; } break;
case 337:
# line 1237 "c-parse.y"
{ arg_list -= level; } break;
case 339:
# line 1266 "c-parse.y"
{ if (monitor_seen != 0) {
		     void_entry = 0;
		     entry_seen = 0;  
		     local_seen = 0;
		     monitor_seen = 1; } } break;
		}
		goto yystack;  /* stack new state and value */

	}
