/* Copyright (c) 1989 Michel Fortier and Peter A. Buhr */


/*
 * monitor_type.h contains the different type of monitor
 */


/* 
 * INCLUDE FILES
 */

#include <uUnix.h>
#include "uType.h"

/* 
 * GLOBAL VARIABLES
 */

Monitor_type MonType;     /* type of monitor */
char *monitor_type;

#define No_Monitor_Names 14

struct {
    char *name;
    Monitor_type type;
} Monitor_type_keywords[No_Monitor_Names] = {
    { "PriorityBlocking", PriorityBlocking },
    { "SignalUrgentWait", PriorityBlocking },
    { "PriorityImmediateReturn", PriorityImmediateReturn },
    { "SignalImmediateReturn", PriorityImmediateReturn },
    { "NoPriorityImmediateReturn", NoPriorityImmediateReturn },
    { "NoPriorityBlocking", NoPriorityBlocking },
    { "SignalWait", NoPriorityBlocking },
    { "PriorityNonBlocking", PriorityNonBlocking },
    { "NoPriorityNonBlocking", NoPriorityNonBlocking },
    { "SignalContinue", NoPriorityNonBlocking },
    { "PriorityResume", PriorityResume },
    { "NoPriorityResume", NoPriorityResume },
    { "PriorityAutomaticSignal", PriorityAutomaticSignal },
    { "NoPriorityAutomaticSignal", NoPriorityAutomaticSignal },
};

/*
 * set variable MonType to the specified monitor type
 * and variable MonPriority
 */

void mon_type( type )
    char *type;
{
    int i;
    
    monitor_type = ( char * )xmalloc( strlen( type ) + 1 );
    strcpy( monitor_type, type );

    for ( i = 0; ; i += 1 ) {	/* linear search for monitor type */
	if ( i >= No_Monitor_Names ) {
	    error( "INVALID MONITOR TYPE, ASSUMING PriorityBlocking MONITOR" );
	    MonType = PriorityBlocking;
	    break;
	}
	if ( strcmp(type, Monitor_type_keywords[i].name) == 0 ) {
	    MonType = Monitor_type_keywords[i].type;
	    break;
	}
    }
}
