/* Copyright (c) 1989 Michel Fortier and Peter A. Buhr */

#include <stdio.h>
#include <uUnix.h>
#include "uMpp.h"

/* 
 * GLOBAL VARIABLES
 */


/*
 * Number of error messages and warning messages so far.
 */

static int warning_count = 0;
static int error_count = 0;

/*
 * Report a warning at the current line number.
 * S and V1 and V2 are a string and args for `printf'.
 */

void warning( s, v1, v2 )
    char *s;
    int v1;
    int v2;
{
    warning_count += 1;
    fprintf( stderr, "%s:%d: ", input_filename, lineno );
    fprintf( stderr, "warning: " );
    fprintf( stderr, s, v1, v2 );
    fprintf( stderr, "\n" );
}

/*
 * Report an error at the current line number.
 * S and V1 and V2 are a string and args for `printf'.
 */

void error( fmt, v1, v2 )
    char *fmt;
    int v1;
    int v2;
{
    error_count += 1;
    fprintf( stderr, "%s: %d: uMONITOR ERROR, ", input_filename, lineno );
    fprintf( stderr, fmt, v1, v2 );
    fprintf( stderr, "\n" );
}

/* 
 * print error and terminate program
 */

void fatal( s, v1, v2 )
    char *s;
    int v1;
    int v2;
{
    error( s, v1, v2 );
    exit( -1 );
}

/*
 * Same as `malloc' but report error if no memory available.
 */

char *xmalloc( size )
    int size;
{
    char *p = ( char * )malloc( size );
    if ( p == NULL ) {
	fatal( "Virtual memory exhausted.", 0, 0 );
    }
    return p;
}

/*
 * Same as `realloc' but report error if no memory available.
 */

char *xrealloc( ptr, size )
    char *ptr;
    int size;
{
    char *p = ( char * )realloc( ptr, size );
    if ( p == NULL ) {
	fatal( "Virtual memory exhausted.", 0, 0 );
    }
    return p;
}

int main( argc, argv )
    int argc;
    char *argv[];
{
    if ( argc > 3 ) {
	fprintf( stderr, "Usage: %s [input-file [output-file]]\n", argv[ 0 ] );
	exit( -1 );
    } else if ( argc == 1 ) {
	finput = stdin;
	foutput = stdout;
    } else {
	input_filename = argv[ 1 ]; /* copy pointer to input file name for use in error messages */
	main_input_filename = input_filename;
	finput = fopen( argv[ 1 ], "r" ); /* 1st file is input file */
	if ( finput == NULL ) {
	    fprintf( stderr, "Open error: %s\n", argv[ 1 ] );
	    exit( -1 );
	} /* if */

	if ( argc != 2 ) { /* 2nd file is output file */
	    foutput = fopen( argv[ 2 ], "w" ); 
	    if ( foutput == NULL ) {
		fprintf( stderr, "Open error: %s\n", argv[ 2 ] );
		exit( -1 );
	    } /* if */
	} else {
	    foutput = stdout;
	} /* if */
    } /* if */

    init_MonBuffer();			/* initialise buffers */
    init_lex();				/* initialise lexical analyser */
    ungetc( check_newline(), finput );	/* prepare parser */
    yyparse(); 				/* parse the input */

    exit( error_count );			/* exit with number of errors */
} /* main */
