/* Copyright (c) 1989 Michel Fortier and Peter A. Buhr */

/*
 * This file contains the functions which expand the monitor statements
 */

#include <stdio.h>
#include <uUnix.h>
#include "uMpp.h"
#include "uFunctions.h"

/* 
 * INCLUDE FILES
 */

/*
 * The monitor_type.h file contains the seven name of different monitors
 */

#include "uType.h"

#define TYPED_FUNCTION 0
#define VOID_FUNCTION 1

#define RETURN_WITH_VALUE    1
#define RETURN_WITH_NO_VALUE 2

/* 
 * GLOBAL VARIABLES
 */

extern FILE *foutput;           /* where to write the output */
extern int  lineno;             /* current line number */
extern char *input_filename;    /* current filename being read */
extern char *monitor_name;      /* name of the current monitor */
extern char *entry_name;
extern char *cond_name;
extern Monitor_type MonType;
extern int cond_init_count;
extern char *monitor_type;

static int return_with_value;
static int return_with_no_value;
static int notify_return;

static char monccdir[] = MONCCDIR;

static char begin_entry_file[] = "uEntryBegin.c";
static char end_entry_file[] = "uEntryEnd.c";
static char wait_on_file[] = "uWait.c";
static char return_notify_file[] = "uIRSignal.c";
static char non_blocking_notify_file[] = "uNBSignal.c";
static char blocking_notify_file[] = "uBSignal.c";
static char resume_notify_file[] = "uRSignal.c";
static char automatic_notify_file1[] = "uASignal1.c";
static char automatic_notify_file2[] = "uASignal2.c";
static char notify_wait_on_file[] = "uSignalWait.c";
static char return_file[] = "uReturn.c";

static char priority_end_entry_file[] = "uPEntryEnd.c";
static char priority_wait_on_file[] = "uPWait.c";
static char priority_return_notify_file[] = "uPIRSignal.c";
static char priority_non_blocking_notify_file[] = "uPNBSignal.c";
static char priority_blocking_notify_file[] = "uPBSignal.c";
static char priority_resume_notify_file[] = "uPRSignal.c";
static char priority_automatic_notify_file1[] = "uPASignal1.c";
static char priority_automatic_notify_file2[] = "uPASignal2.c";
static char priority_notify_wait_on_file[] = "uPSignalWait.c";

/*
 * Functions
 */

/*
 * Add code at the beginning of a monitor
 */

void generate_begin_monitor()
{
    static char monitor_init[] = "{ 0, { 0, -1, 0, 0 }, 0, { 0, 0 }, { 0, 0 }, 0 }";
                         /* uSemaphore ^^^^^^^^^^^^^^^ constant */
    fprintf( foutput,
	    "_Mon_monitor %s = %s;\n",
	    monitor_name, monitor_init );
}

void generate_cond_init()
{
    fprintf( foutput,
	    "( ( uCondition ){ 0, 0, 0, &%s } )",
	    monitor_name );
}

/*
 * Add code at the beginning of an entry routine 
 */

void generate_begin_entry( int function_type, char *front_type, char *back_type, char *back )
{
    FILE *input;
    char *input_file;
    int c;
    
    fprintf( foutput,
	    "%s%s%s",
	    front_type, entry_name, back );
    fprintf( foutput,
	    "{ _Mon_entry _mon_entry = ( _Mon_entry ){ { { 0, 0, 0, 0 }, 0 }, 0, 0, &%s }; ",
                                           /* uSemaphore ^^^^^^^^^^^^^^ constant */
	    monitor_name );
    /*
     * define a local type which is the same as the function
     */
    if ( function_type == TYPED_FUNCTION ) {
	fprintf( foutput,
		"%s _mon_return_value %s;",
		front_type, back_type );
    }
    fprintf( foutput,
	    "\n"
	    );
    notify_return = 0;
    return_with_value = 0;
    return_with_no_value = 0;
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( begin_entry_file ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], begin_entry_file );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
} 

/*
 * Add code for a wait_on statement
 */

void generate_wait_on( char *cond, char *expr )
{
    FILE *input;
    char *input_file, *filename;
    int c;

    fprintf( foutput,
	    "{ _Mon_condition *_mon_condition = &( %s ); int _mon_value = ( %s );\n",
	    cond, expr );
    switch ( MonType ) {
      case PriorityBlocking:
      case PriorityNonBlocking:
      case PriorityResume:
	filename = priority_wait_on_file;
	break;
      case PriorityImmediateReturn:
      case NoPriorityBlocking:
      case NoPriorityNonBlocking:
      case NoPriorityResume:
      case NoPriorityImmediateReturn:
	filename = wait_on_file;
	break;
      case PriorityAutomaticSignal:
      case NoPriorityAutomaticSignal:
	exit( -1 );
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * Add code for notify statement
 */

void generate_notify( char *cond )
{
    FILE *input;
    char *input_file, *filename;
    int c;
    
    fprintf( foutput,
	    "{ _Mon_condition *_mon_condition = &( %s );\n",
	    cond );
    /* 
     * add code depending on the type of the monitor
     */
    switch ( MonType ) {
      case PriorityImmediateReturn:
	filename = priority_return_notify_file;
	notify_return += 1;
	break;
      case NoPriorityImmediateReturn:
	filename = return_notify_file;
	notify_return += 1;
	break;
      case PriorityNonBlocking:
	filename = priority_non_blocking_notify_file;
	break;
      case NoPriorityNonBlocking:
	filename = non_blocking_notify_file;
	break;
      case PriorityBlocking:
	filename = priority_blocking_notify_file;
	break;
      case NoPriorityBlocking:
	filename = blocking_notify_file;
	break;
      case PriorityResume:
	filename = priority_resume_notify_file;
	break;
      case NoPriorityResume:
	filename = resume_notify_file;
	break;
      case PriorityAutomaticSignal:
      case NoPriorityAutomaticSignal:
	exit( -1 );
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * add code for a notify and return statement
 */

void generate_notify_return( char *cond, int function_type, int return_code, char *expr )
{
    FILE *input;
    char *input_file, *filename;
    int c;

    fprintf( foutput,
	    "{ _Mon_condition *_mon_condition = &( %s ); ",
	    cond );
    if ( return_code == RETURN_WITH_VALUE ) {
	if ( function_type == TYPED_FUNCTION ) {
	    /* 
	     * declare a local variable with the same type of the function
	     */
	    fprintf( foutput,
		    "_mon_return_value = ( %s ); ",
		    expr );
	} else {
	    fprintf( foutput,
		    "%s; ",
		    expr );
	}
	fprintf( foutput,
		"_mon_entry . return_value = 2;\n"
		);
	return_with_value += 1;
    } else {
	fprintf( foutput,
 		"_mon_entry . return_value = 1;\n"
		);
	return_with_no_value += 1;
    }
    switch ( MonType ) {
      case PriorityImmediateReturn:
	filename = priority_return_notify_file;
	break;
      case NoPriorityImmediateReturn:
	filename = return_notify_file;
	break;
      case PriorityBlocking:
      case NoPriorityBlocking:
      case PriorityNonBlocking:
      case NoPriorityNonBlocking:
      case PriorityResume:
      case NoPriorityResume:
      case PriorityAutomaticSignal:
      case NoPriorityAutomaticSignal:
	exit( -1 );
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    notify_return += 1;
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * Add code for a notify and wait_on statement
 */

void generate_notify_wait_on( char *cond1, char *cond2, char *expr )
{
    FILE *input;
    char *input_file, *filename;
    int c;

    fprintf( foutput,
	    "{ _Mon_condition *_mon_condition1 = &( %s ), *_mon_condition2 = &( %s ); int _mon_value = ( %s );\n",
	    cond1, cond2, expr );
    switch ( MonType ) {
      case PriorityImmediateReturn:
	filename = priority_notify_wait_on_file;
	break;
      case NoPriorityImmediateReturn:
	filename = notify_wait_on_file;
	break;
      case PriorityBlocking:
      case NoPriorityBlocking:
      case PriorityNonBlocking:
      case NoPriorityNonBlocking:
      case PriorityResume:
      case NoPriorityResume:
      case PriorityAutomaticSignal:
      case NoPriorityAutomaticSignal:
	exit( -1 );
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * add code for the return statement in a monitor routine
 */

void generate_return( int function_type, int return_code, char *expr )
{
    FILE *input;
    char *input_file;
    int c;
    
    if ( return_code == RETURN_WITH_VALUE ) {
	if ( function_type == TYPED_FUNCTION ) {
	    /* 
	     * declare a local variable with the same type of the function
	     */
	    fprintf( foutput,
		    "{ _mon_return_value = ( %s ); ",
		    expr );
	} else {
	    fprintf( foutput,
		    "{ %s; ",
		    expr );
	}
	fprintf( foutput,
		"_mon_entry . return_value = 2;\n"
		);
	return_with_value += 1;
    } else {
	fprintf( foutput,
 		"{ _mon_entry . return_value = 1;\n"
		);
	return_with_no_value += 1;
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( return_file ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], return_file );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * add code for a wait_until statement
 */

void generate_wait_until( char *expr )
{
    FILE *input;
    char *input_file, *filename;
    int c;

    fprintf( foutput,
	    "{ _Mon_monitor *_mon_monitor = &%s;\n",
	    monitor_name );
    switch ( MonType ) {
      case PriorityAutomaticSignal:
	filename = priority_automatic_notify_file1;
	break;
      case NoPriorityAutomaticSignal:
	filename = automatic_notify_file1;
	break;
      case PriorityBlocking:
      case NoPriorityBlocking:
      case PriorityNonBlocking:
      case NoPriorityNonBlocking:
      case PriorityResume:
      case NoPriorityResume:
      case PriorityImmediateReturn:
      case NoPriorityImmediateReturn:
	exit( -1 );
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit( -1 );
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    fprintf( foutput,
	    "        while ( ! ( %s ) )\n",
	    expr );
    free( input_file );
    if ( MonType == PriorityAutomaticSignal ) {
	filename = priority_automatic_notify_file2;
    } else {
	filename = automatic_notify_file2;
    }
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit(-1);
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
    free( input_file );
}

/*
 * add code at the end of an entry routine
 */

void generate_end_entry( int function_type )
{
    FILE *input;
    char *input_file, *filename;
    int c;
    
    if ( return_with_value > 0 || return_with_no_value > 0 || notify_return > 0 ) {
	fprintf( foutput,
		"} _mon_end: "
		);
	if ( notify_return > 0 ) {
	    fprintf( foutput,
		    "if ( _mon_entry . notify_return == 0 ) "
		    );
	}
    } else {
	fprintf( foutput,
		"} "
		);
    }
    fprintf( foutput,
	    "{ _Mon_monitor *_mon_monitor = &%s; ",
	    monitor_name );
    switch ( MonType ) {
      case PriorityAutomaticSignal:
	fprintf( foutput,
		"_mon_monitor -> first_pcs = _mon_first_pcs_of_pcs_list( &_mon_monitor -> urgent_pcs_list );"
		);
      case PriorityBlocking:
      case PriorityNonBlocking:
      case PriorityResume:
	filename = priority_end_entry_file;
	break;
      case NoPriorityAutomaticSignal:
	fprintf( foutput,
		"_mon_monitor -> first_pcs = _mon_first_pcs_of_pcs_list( &_mon_monitor -> pcs_list );"
		);
      case PriorityImmediateReturn:
      case NoPriorityBlocking:
      case NoPriorityNonBlocking:
      case NoPriorityResume:
      case NoPriorityImmediateReturn:
	filename = end_entry_file;
	break;
    }
    fprintf( foutput,
	    "\n"
	    );
    input_file = ( char * )xmalloc( strlen( monccdir ) + strlen( filename ) + 1 );
    strcpy( input_file, monccdir );
    strcpy( &input_file[ strlen( monccdir ) ], filename );
    fprintf( foutput,
	    "# line 1 \"%s\"\n",
	    input_file );
    input = fopen( input_file, "r" );
    if ( input == NULL ) {
	fprintf( stderr, "*ERROR* mon-cpp: for file \"%s\"", input_file );
	perror( " " );
	exit(-1);
    }
    while ( ( c = fgetc( input ) ) != EOF ) {
	fputc( c, foutput );
    }
    fclose( input );
    if ( return_with_value > 0 ) {
	if ( function_type == TYPED_FUNCTION ) {
	    fprintf( foutput,
		    "    if ( _mon_entry . return_value == 2 ) return _mon_return_value;\n"
		    );
	} else {
	    fprintf( foutput,
		    "    if ( _mon_entry . return_value == 2 ) return 0;\n"
		    );
	}
    }
    if ( return_with_no_value > 0 ) {
	fprintf( foutput,
		"    if ( _mon_entry . return_value == 1 ) return;\n"
		);
    } else {
	fprintf( foutput,
		"\n"
		);
    }
    fprintf( foutput,
	    "# line %d \"%s\"\n",
	    lineno, input_filename );
}

/*
 * Add code at the end of the monitor
 */

void generate_end_monitor()
{
}
