/* Modified by Michel Fortier, 1989. Modified code is commented with "mpp" */

/* YACC parser for C syntax.
   Copyright (C) 1987, 1988 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* These are the 19 conflicts you should get in parse.output;
   the state numbers may vary if minor changes in the grammar are made.

State 67 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 77 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 145 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 279 contains 1 shift/reduce conflict.  (See comment at component_decl.)
State 302 contains 2 shift/reduce conflicts.  (make after_type_declarator longer if poss.).
State 303 contains 2 shift/reduce conflicts.  (make notype_declarator longer.)
State 317 contains 2 shift/reduce conflicts.  (make absdcl1 longer if poss.)
State 369 contains 2 shift/reduce conflicts.  (make absdcl1 longer if poss.)
State 384 contains 1 shift/reduce conflict.  (dangling else.)
State 588 contains 2 shift/reduce conflicts.  (make absdcl1 longer if poss.)
State 591 contains 2 shift/reduce conflicts.  (make absdcl1 longer if poss.)
State 628 contains 2 shift/reduce conflicts.  (make parm_declarator longer)?
*/

%{
#include <stdio.h>

#include "c-parse.h" /* mpp */
#include "uType.h" /* mpp */
#include "uTable.h" /* mpp */
#include "uBuffer.h" /* mpp */
#include "uMpp.h" /* mpp */

/* Cause the `yydebug' variable to be defined.  */
#define YYDEBUG 0
%}

%start program

/* All identifiers that are not reserved words
   and are not declared typedefs in the current block */
%token IDENTIFIER

/* All identifiers that are declared typedefs in the current block.
   In some contexts, they are treated just like IDENTIFIER,
   but they can also serve as typespecs in declarations.  */
%token TYPENAME

/* Reserved words that specify storage class.
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token SCSPEC

/* Reserved words that specify type.
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token TYPESPEC

/* Reserved words that qualify type: "const" or "volatile".
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token TYPE_QUAL

/* Character or numeric constants.
   yylval is the node for the constant.  */
%token CONSTANT

/* String constants in raw form.
   yylval is a STRING_CST node.  */
%token STRING

/* "...", used for functions with variable arglists.  */
%token ELLIPSIS

/* the reserved words */
%token SIZEOF ENUM STRUCT UNION IF ELSE WHILE DO FOR SWITCH CASE DEFAULT
%token BREAK CONTINUE RETURN GOTO ASM TYPEOF ALIGNOF
%token MONITOR ENTRY LOCAL WAIT_ON WITH NOTIFY WAIT_UNTIL /* mpp */

/* Define the operator tokens and their precedences.
   The value is an integer because, if used, it is the tree code
   to use in the expression made from the operator.  */

%right ASSIGN '=' /* mpp */
%right '?' ':' /* mpp */
%left OROR /* mpp */
%left ANDAND /* mpp */
%left '|' /* mpp */
%left '^' /* mpp */
%left '&' /* mpp */
%left EQCOMPARE /* mpp */
%left ARITHCOMPARE /* mpp */
%left LSHIFT RSHIFT /* mpp */
%left '+' '-' /* mpp */
%left '*' '/' '%' /* mpp */
%right UNARY PLUSPLUS MINUSMINUS /* mpp */
%left HYPERUNARY
%left POINTSAT '.' /* mpp */

%{
char *monitor_name = 0, *entry_name = 0, *cond_name = 0; /* mpp */
int cond_init_count = -1; /* mpp */
extern Monitor_type MonType; /* mpp */
extern void mon_type(); /* mpp */

static char *FrontType = 0, *BackType = 0; /* mpp */
static char *CondName = 0, *CondName2 = 0; /* mpp */
static int  entry_type = 0; /* mpp */
static int  monitor_seen = 0; /* mpp */
static int  anon_cnt = 0; /* mpp */
static int  entry_seen = 0; /* mpp */
static int  local_seen = 0; /* mpp */
static int  typedef_seen = 0; /* mpp */
static int  void_seen = 0; /* mpp */
static int  condition_seen = 0; /* mpp */
static int  void_entry = 0; /* mpp */
static int  star_seen = 0; /* mpp */
static int  identifier = 0; /* mpp */
static int  vector = 0; /* mpp */
static int  function = 0; /* mpp */
static int  pointer = 0; /* mpp */
static int  arg_list = 0; /* mpp */
static int  mark = 0; /* mpp */
static int  back_mark = 0; /* mpp */
static int  level = 1; /* mpp */

/* the declaration found for the last IDENTIFIER token read in.
   yylex must look this up to detect typedefs, which get token type TYPENAME,
   so it is left around in case the identifier is not a typedef but is
   used in a context which makes it a reference to a variable.  */

static char *last_id; /* mpp */

/* List of types and structure classes of the current declaration */

char *input_filename;		/* source file current line is coming from */
char *main_input_filename;	/* top-level source file */

static int yylex ();
%}

%%
program: /* empty */
	| extdefs /* mpp */
	;

/* the reason for the strange actions in this rule
 is so that notype_initdecls when reached via datadef
 can find a valid list of type and sc specs in $0. */

extdefs:
	extdef /* mpp */
	| monitor /* mpp */
	| extdefs extdef /* mpp */
	| extdefs monitor /* mpp */
	;

extdef:
	check_entry_or_local fndef pop reset0 reset /* mpp */
	| check_entry_or_local datadef after_ddecl reset0 reset /* mpp */
	| ASM '(' string ')' ';'
	;

datadef:
	  add_int_type setspecs notype_initdecls ';' /* mpp */
        | declmods add_int_type setspecs notype_initdecls ';' /* mpp */
	| typed_declspecs setspecs initdecls ';'
        | declmods ';'
	| typed_declspecs ';'
	| error ';'
	| error '}'
	| ';'
	;

fndef:
	  typed_declspecs setspecs declarator end_back /* mpp */
	  add_condition after_fdecl xdecls /* mpp */
	  begin_entry compstmt_or_error end_entry /* mpp */
	| typed_declspecs setspecs declarator error /* mpp */
	| declmods add_int_type setspecs notype_declarator end_back /* mpp */
	  add_condition after_fdecl xdecls /* mpp */
	  begin_entry compstmt_or_error end_entry /* mpp */
	| declmods add_int_type setspecs notype_declarator error /* mpp */
	| add_int_type setspecs notype_declarator end_back /* mpp */
	  add_condition after_fdecl xdecls /* mpp */
	  begin_entry compstmt_or_error end_entry /* mpp */
	| add_int_type setspecs notype_declarator error /* mpp */
	;

identifier:
	IDENTIFIER
	| TYPENAME
	;

unop:     '&'
	| '-'
	| '+'
	| PLUSPLUS
	| MINUSMINUS
	| '~'
	| '!'
	;

expr:	nonnull_exprlist
	;

exprlist:
	  /* empty */
	| nonnull_exprlist
	;

nonnull_exprlist:
	expr_no_commas
	| nonnull_exprlist ',' expr_no_commas
	;

expr_no_commas:
	primary
	| '*' expr_no_commas   %prec UNARY
	| unop expr_no_commas  %prec UNARY
	| '(' typename ')' expr_no_commas  %prec UNARY
	| '(' typename ')' '{' initlist maybecomma '}'  %prec UNARY
	| SIZEOF expr_no_commas  %prec UNARY
	| SIZEOF '(' typename ')'  %prec HYPERUNARY
	| ALIGNOF expr_no_commas  %prec UNARY
	| ALIGNOF '(' typename ')'  %prec HYPERUNARY
	| expr_no_commas '+' expr_no_commas
	| expr_no_commas '-' expr_no_commas
	| expr_no_commas '*' expr_no_commas
	| expr_no_commas '/' expr_no_commas
	| expr_no_commas '%' expr_no_commas
	| expr_no_commas LSHIFT expr_no_commas
	| expr_no_commas RSHIFT expr_no_commas
	| expr_no_commas ARITHCOMPARE expr_no_commas
	| expr_no_commas EQCOMPARE expr_no_commas
	| expr_no_commas '&' expr_no_commas
	| expr_no_commas '|' expr_no_commas
	| expr_no_commas '^' expr_no_commas
	| expr_no_commas ANDAND expr_no_commas
	| expr_no_commas OROR expr_no_commas
	| expr_no_commas '?' xexpr ':' expr_no_commas
	| expr_no_commas '=' expr_no_commas
	| expr_no_commas ASSIGN expr_no_commas
	;

primary:
	IDENTIFIER
		{ if ( ! strcmp( "U_CONDITION", last_id ) ) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     generate_cond_init(); } }
	| CONSTANT
	| string
	| '(' expr ')'
	| '(' error ')'
	| '(' 
	  compstmt ')'
	| primary '(' exprlist ')'   %prec '.'
	| primary '[' expr ']'   %prec '.'
	| primary '.' identifier
	| primary POINTSAT identifier
	| primary PLUSPLUS
	| primary MINUSMINUS
	;

/* Produces a STRING_CST with perhaps more STRING_CSTs chained onto it.  */
string:
	  STRING
	| string STRING
	;

xdecls:
	/* empty */
	| decls
	;

decls:
	decl reset0 /* mpp */
/*	| errstmt reset0 */
	| decls decl reset0 /* mpp */
/*	| decl errstmt reset0 */
	;

/* records the type and storage class specs to use for processing
   the declarators that follow */
setspecs: /* empty */
	;

decl:
	typed_declspecs setspecs initdecls ';'
	| declmods setspecs notype_initdecls ';'
	| typed_declspecs ';'
	| declmods ';'
	;

/* Declspecs which contain at least one type specifier or typedef name.
   (Just `const' or `volatile' is not enough.)
   A typedef'd name following these is taken as a name to be declared.  */

typed_declspecs:
	  typespec reserved_declspecs
	| declmods typespec reserved_declspecs
	;

reserved_declspecs:  /* empty */
	| reserved_declspecs typespecqual_reserved
	| reserved_declspecs SCSPEC
		{ if (( enum rid )$2 == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } /* mpp */
	;

/* List of just storage classes and type modifiers.
   A declaration can start with just this, but then it cannot be used
   to redeclare a typedef-name.  */

declmods:
	  TYPE_QUAL
	| SCSPEC
		{ if (( enum rid )$1 == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } /* mpp */
	| declmods TYPE_QUAL
	| declmods SCSPEC
		{ if (( enum rid )$2 == RID_TYPEDEF && typedef_seen < level) /* mpp */
		     typedef_seen += level; } /* mpp */
	;


/* Used instead of declspecs where storage classes are not allowed
   (that is, for typenames and structure components).
   Don't accept a typedef-name if anything but a modifier precedes it.  */

typed_typespecs:
	  typespec reserved_typespecquals
	| nonempty_type_quals typespec reserved_typespecquals
	;

reserved_typespecquals:  /* empty */
	| reserved_typespecquals typespecqual_reserved
	;

/* A typespec (but not a type qualifier).
   Once we have seen one of these in a declaration,
   if a typedef name appears then it is being redeclared.  */

typespec: TYPESPEC
		{ if (( enum rid )$1 == RID_VOID && void_seen < level ) /* mpp */
		     void_seen += level; }
	| structsp
	| TYPENAME
		{ int type = typedef_type (last_id); /* mpp */
		  if (type == 1 && void_seen < level ) /* mpp */
		     void_seen += level; /* mpp */
		  else if (type == -1 && condition_seen < level) { /* mpp */
		     if (monitor_seen == 0)
		        error("uCondition MAY ONLY BE USED INSIDE A MONITOR", 0, 0); /* mpp */
		     else /* mpp */
		        condition_seen += level;
		  } else if ( ! strcmp( last_id, "uCondition" ) && condition_seen < level ) /* mpp */
		     if (monitor_seen == 0)
		        error("uCondition MAY ONLY BE USED INSIDE A MONITOR", 0, 0); /* mpp */
		     else /* mpp */
		        condition_seen += level; }
	| TYPEOF '(' expr ')'
	| TYPEOF '(' typename ')'
	;

/* A typespec that is a reserved word, or a type qualifier.  */

typespecqual_reserved: TYPESPEC
	| TYPE_QUAL
	| structsp
	;

initdecls:
	initdcl reset1 /* mpp */
	| initdecls ',' initdcl reset1 /* mpp */
	;

notype_initdecls:
	notype_initdcl reset1 /* mpp */
	| notype_initdecls ',' initdcl reset1 /* mpp */
	;

maybeasm:
	  /* empty */
	| ASM '(' string ')'
	;

initdcl:
	  declarator end_back add_condition maybeasm '=' /* mpp */
	  init
/* Note how the declaration of the variable is in effect while its init is parsed! */
	| declarator end_back add_condition maybeasm /* mpp */
	;

notype_initdcl:
	  notype_declarator end_back add_condition maybeasm '=' /* mpp */
	  init
/* Note how the declaration of the variable is in effect while its init is parsed! */
	| notype_declarator end_back add_condition maybeasm /* mpp */
	;

init:
	expr_no_commas
	| '{' '}'
	| '{' initlist '}'
	| '{' initlist ',' '}'
	| error
	;

/* This chain is built in reverse order,
   and put in forward order where initlist is used.  */
initlist:
	  init
	| initlist ',' init
	;

/* Any kind of declarator (thus, all declarators allowed
   after an explicit typespec).  */

declarator:
	  after_type_declarator
	| notype_declarator
	;

/* A declarator that is allowed only after an explicit typespec.  */

after_type_declarator:
	  '(' after_type_declarator ')'
	| after_type_declarator '(' mark_back arg_list_start parmlist_or_identifiers /* mpp */
	  arg_list_end correct_back function_decl  %prec '.' /* mpp */
	| after_type_declarator '[' expr ']' vector_decl  %prec '.' /* mpp */
		{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; }
	| after_type_declarator '[' ']' vector_decl  %prec '.' /* mpp */
		{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; }
	| '*' star type_quals after_type_declarator pointer_decl  %prec UNARY /* mpp */
	| end_front TYPENAME modify_typedef add_typedef push identifier_decl /* mpp */
		{ if ( entry_type == 1 ) {
		     if ( entry_name ) free( entry_name );
		     entry_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( entry_name, last_id );
		     entry_type = 2;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     back_mark = 0;
		     mark = 0;
		  } else if (condition_seen == 1 && typedef_seen == 0 && level == 2) {
		     if ( cond_name ) free( cond_name );
		     cond_init_count = -1;
		     cond_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( cond_name, last_id ); } }
	;

/* Kinds of declarator that can appear in a parameter list
   in addition to notype_declarator.  This is like after_type_declarator
   but does not allow a typedef name in parentheses as an identifier
   (because it would conflict with a function with that typedef as arg).  */

parm_declarator:
	  parm_declarator '(' parmlist_or_identifiers function_decl  %prec '.' /* mpp */
/*	| parm_declarator '(' error ')'  %prec '.'
		{ $$ = build_nt (CALL_EXPR, $1, NULL_TREE, NULL_TREE);
		  poplevel (0, 0, 0); }  */
	| parm_declarator '[' expr ']' vector_decl  %prec '.' /* mpp */
	| parm_declarator '[' ']' vector_decl  %prec '.' /* mpp */
	| '*' star type_quals parm_declarator pointer_decl  %prec UNARY /* mpp */
	| TYPENAME modify_typedef add_typedef push identifier_decl /* mpp */
	;

/* A declarator allowed whether or not there has been
   an explicit typespec.  These cannot redeclare a typedef-name.  */

notype_declarator:
	  notype_declarator '(' mark_back arg_list_start parmlist_or_identifiers /* mpp */
	  arg_list_end correct_back function_decl  %prec '.' /* mpp */
	| '(' notype_declarator ')'
	| '*' star type_quals notype_declarator pointer_decl  %prec UNARY /* mpp */
	| notype_declarator '[' expr ']' vector_decl  %prec '.' /* mpp */
		{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; }
	| notype_declarator '[' ']' vector_decl  %prec '.' /* mpp */
		{ if (condition_seen == 1 && typedef_seen == 0 && level == 2)
		     cond_init_count = 0; }
	| end_front IDENTIFIER add_typedef push identifier_decl /* mpp */
		{ if ( entry_type == 1 ) {
		     if( entry_name ) free( entry_name );
		     entry_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( entry_name, last_id );
		     entry_type = 2;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0;
		     back_mark = 0;
		     mark = 0;
		  } else if (condition_seen == 1 && typedef_seen == 0 && level == 2) {
		     if ( cond_name ) free( cond_name );
		     cond_init_count = -1;
		     cond_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		     strcpy( cond_name, last_id ); } }
	;

structsp:
	  STRUCT identifier '{' push /* mpp */
	  component_decl_list '}' pop /* mpp */
	| STRUCT '{' push component_decl_list '}' pop /* mpp */
	| STRUCT identifier
	| UNION identifier '{' push /* mpp */
	  component_decl_list '}' pop /* mpp */
	| UNION '{' push component_decl_list '}' pop /* mpp */
	| UNION identifier
	| ENUM identifier '{'
	  enumlist maybecomma '}'
	| ENUM '{'
	  enumlist maybecomma '}'
	| ENUM identifier
	;

maybecomma:
	  /* empty */
	| ','
	;

component_decl_list:   /* empty */
	| component_decl_list component_decl ';' reset0 /* mpp */
	| component_decl_list ';' reset0 /* mpp */
	;

/* There is a shift-reduce conflict here, because `components' may
   start with a `typename'.  It happens that shifting (the default resolution)
   does the right thing, because it treats the `typename' as part of
   a `typed_typespecs'.

   It is possible that this same technique would allow the distinction
   between `notype_initdecls' and `initdecls' to be eliminated.
   But I am being cautious and not trying it.  */

component_decl:
	typed_typespecs setspecs components
	| nonempty_type_quals setspecs components
	| error
	;

components:
	  /* empty */
	| component_declarator reset1 /* mpp */
	| components ',' component_declarator reset1 /* mpp */
	;

component_declarator:
	declarator add_condition /* mpp */
	| declarator add_condition ':' expr_no_commas /* mpp */
	| end_front add_typedef push identifier_decl ':' expr_no_commas /* mpp (PAB) */
	;

/* We chain the enumerators in reverse order.
   They are put in forward order where enumlist is used.
   (The order used to be significant, but no longer is so.
   However, we still maintain the order, just to be clean.)  */

enumlist:
	  enumerator
	| enumlist ',' enumerator
	;


enumerator:
	  identifier
	| identifier '=' expr_no_commas
	;

typename:
	typed_typespecs absdcl
	| nonempty_type_quals absdcl
	;
	
absdcl:   /* an absolute declarator */
	/* empty */
	| absdcl1
	;

nonempty_type_quals:
	  TYPE_QUAL
	| nonempty_type_quals TYPE_QUAL
	;

type_quals:
	  /* empty */
	| type_quals TYPE_QUAL
	;

absdcl1:  /* a nonempty absolute declarator */
	  '(' absdcl1 ')'
	  /* `(typedef)1' is `int'.  */
	| '*' star type_quals absdcl1 pointer_decl  %prec UNARY /* mpp */
	| '*' star type_quals pointer_decl  %prec UNARY /* mpp */
	| absdcl1 '(' parmlist function_decl  %prec '.' /* mpp */
	| absdcl1 '[' expr ']' vector_decl  %prec '.' /* mpp */
	| absdcl1 '[' ']' vector_decl  %prec '.' /* mpp */
	| '(' push parmlist function_decl  %prec '.' /* mpp */
	| '[' push expr ']' vector_decl pop %prec '.' /* mpp */
	| '[' ']' vector_decl %prec '.' /* mpp */
	;

/* at least one statement, the first of which parses without error.  */
/* stmts is used only after decls, so an invalid first statement
   is actually regarded as an invalid decl and part of the decls.  */

stmts:
	stmt
	| stmts stmt
	| stmts error
	| error
	;

xstmts:
	/* empty */
	| stmts
	;
/*
errstmt:  error ';'
	;
*/
pushlevel:  /* empty */
	;

/* This is the body of a function definition.
   It causes syntax errors to ignore to the next openbrace.  */
compstmt_or_error:
	  compstmt
	| error compstmt 
	| error /* mpp */ 
	;

compstmt: '{' '}'
	| '{' push pushlevel decls xstmts '}' pop
	| '{' push pushlevel stmts '}' pop
/*	| '{' push pushlevel error '}' pop */
	;

simple_if:
	  IF '(' expr ')'
	  stmt
	;

stmt:
	  compstmt
	| expr ';'
	| simple_if ELSE
	  stmt
	| simple_if
	| WHILE
	  '(' expr ')'
	  stmt
	| DO
	  stmt WHILE
	  '(' expr ')' ';'
	| FOR 
	  '(' xexpr ';'
	  xexpr ';'
	  xexpr ')'
	  stmt
	| SWITCH '(' expr ')'
	  stmt
	| CASE expr ':'
	  stmt
	| DEFAULT ':'
	  stmt
	| BREAK ';'
	| CONTINUE ';'	
	/* | RETURN ';' */ /* mpp */
	/* | RETURN expr ';' */ /* mpp */
	| ASM maybe_type_qual '(' string ')' ';' /* mpp */
	/* This is the case with just output operands.  */
	| ASM maybe_type_qual '(' string ':' asm_operands ')' ';'
	/* This is the case with input operands as well.  */
	| ASM maybe_type_qual '(' string ':' asm_operands ':' asm_operands ')' ';'
	/* This is the case with clobbered registers as well.  */
	| ASM maybe_type_qual '(' string ':' asm_operands ':'
  	  asm_operands ':' asm_clobbers ')' ';'
	| GOTO identifier ';'
	| identifier ':'
	  stmt
	| ';'
	| return_stmt /* mpp */
	| wait_on_stmt /* mpp */
	| notify_stmt /* mpp */
	| wait_until_stmt /* mpp */
	| notify_return_stmt /* mpp */
	| notify_wait_on_stmt /* mpp */
	;

maybe_type_qual:
	/* empty */
	| TYPE_QUAL
	;

xexpr:
	/* empty */
	| expr
	;

/* These are the operands other than the first string and colon
   in  asm ("addextend %2,%1": "=dm" (x), "0" (y), "g" (*x))  */
asm_operands: /* empty */
	| nonnull_asm_operands
	;

nonnull_asm_operands:
	  asm_operand
	| nonnull_asm_operands ',' asm_operand
	;

asm_operand:
	  STRING '(' expr ')'
	;

asm_clobbers:
	  STRING
	| asm_clobbers ',' STRING
	;

/* This is what appears inside the parens in a function declarator.
   Its value is a list of ..._TYPE nodes.  */
parmlist:
	  push parmlist_1 pop /* mpp */
	;

/* This is referred to where either a parmlist or an identifier list is ok.
   Its value is a list of ..._TYPE nodes or a list of identifiers.  */
parmlist_or_identifiers:
	  push parmlist_or_identifiers_1 pop /* mpp */
	;

parmlist_or_identifiers_1:
	  parmlist_2 ')'
	| identifiers ')'
	| error ')'
	;

parmlist_1:
	  parmlist_2 ')'
	| error ')'
	;

/* This is what appears inside the parens in a function declarator.
   Is value is represented in the format that grokdeclarator expects.  */
parmlist_2:  /* empty */
	| parms
	| parms ',' ELLIPSIS
	;

parms:	
	parm
	| parms ',' parm
	;

/* A single parameter declaration or parameter type name,
   as found in a parmlist.  */
parm:
	  typed_declspecs parm_declarator add_condition pop reset0 /* mpp */
	| typed_declspecs notype_declarator add_condition pop reset0 /* mpp */
	| typed_declspecs absdcl reset0 /* mpp */
	| declmods notype_declarator add_condition pop reset0 /* mpp */
	| declmods absdcl reset0 /* mpp */
	;

/* A nonempty list of identifiers.  */
identifiers:	
	IDENTIFIER
	| identifiers ',' IDENTIFIER
	;

add_int_type:
	/* empty */
		{ if (entry_seen == 1)
		     add_type_int(); }
	;

monitor:
        monitor_word monitor_name typed_monitor begin_monitor mondefs end_monitor
		{ monitor_seen = 0; }
	| monitor_word monitor_name typed_monitor error
		{ error( "Invalid uMonitor statement", 0, 0 );
		  monitor_seen = 0; }
        ;

monitor_word:
	MONITOR skip 
		{ monitor_seen = 1; }
	;

monitor_name:
	/* empty */
		{ if ( monitor_name ) free( monitor_name );
		  monitor_name = ( char * )xmalloc( 7 + 1 );
		  sprintf( monitor_name, "ANON%d", ++anon_cnt ); }
	| IDENTIFIER skip
		{ if ( monitor_name ) free( monitor_name );
		  monitor_name = ( char * )xmalloc( strlen( last_id ) + 1 );
		  strcpy( monitor_name, last_id ); }
	;

typed_monitor:
        /* empty */
		{ MonType = PriorityBlocking; }
	| opened_bracket monitor_type closed_bracket
	| opened_bracket error
		{ MonType = PriorityBlocking;
		  error( "Invalid uMonitor statement", 0, 0 ); }
	| opened_bracket monitor_type error
		{ error( "Invalid uMonitor statement", 0, 0 ); }
        ;

opened_bracket:
	'(' skip 
	;

monitor_type:
	IDENTIFIER skip
		{ mon_type( last_id ); }
	;

closed_bracket:
	')' skip 
	;

begin_monitor:
	'{' skip 
		{ generate_begin_monitor(); }
	;

mondefs:
        /* empty */
	| mondefs extdef
        ;

end_monitor:
	'}' skip 
		{ generate_end_monitor(); }
	;

check_entry_or_local:
	/* empty */
	| ENTRY skip
		{ if (monitor_seen == 1) {
		     entry_seen = 1;
		     void_entry = 0;
		     no_echo = 1;
		     MonBuffer[0] = '\0';
		     MonBuffer_length = 0;
		     entry_type = 1;
		  } else
		     error("ENTRY CAN ONLY BE USED IN A MONITOR", 0, 0); }
	| LOCAL skip
		{ if (monitor_seen == 1)
		     local_seen = 1;
		  else
		     error("LOCAL CAN ONLY BE USED IN A MONITOR", 0, 0); }
	;

skip:
	/* empty */
		{ PrBuffer[0] = '\0';
		  PrBuffer_length = 0; }
	;

no_echo: 
	/* empty */
		{ no_echo = 1; 
		  MonBuffer[0] = '\0';
		  MonBuffer_length = 0;
		  if (PrBuffer_length > 0)
		     no_echo = 2; }
	;

echo: 
	/* empty */
		{ no_echo = 0; }
	;

end_front: 
	/* empty */
		{ if (entry_type == 1) {
		     if ( FrontType ) free( FrontType );
		     FrontType = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( FrontType, MonBuffer ); } }
	;

after_ddecl:
	/* empty */
		{ if (monitor_seen == 1 && (entry_seen == 1 || local_seen == 1))
		     error("ENTRY OR LOCAL MUST PRECEDE A MONITOR ROUTINE", 0, 0); }
	;

after_fdecl:
	/* empty */
		{ if (monitor_seen == 1) {
		     monitor_seen = 2;
		     if (entry_seen == 0 && local_seen == 0) {
		        error("MONITOR ROUTINE WITHOUT ENTRY OR LOCAL - ASSUME LOCAL", 0, 0);
		        local_seen = 1; } } }
	;

push:  
	/* empty */
		{ level *= 2; 
		  push_level(); }
	;

pop:  
	/* empty */
		{ level /= 2;
		  pop_level(); }
	;

return_stmt:
	return_word return_semicolon
		{ if (entry_seen == 1)
		     generate_return(void_entry, 0); }
	| return_word return_expr return_semicolon
		{ if (entry_seen == 1)
		     generate_return(void_entry, 1, MonBuffer ); }
	| return_word error ';'
		{ if (entry_seen == 1)
		     error("INVALID RETURN STATEMENT", 0, 0); }
	| return_word return_expr error ';'
		{ if (entry_seen == 1)
		     error("INVALID RETURN STATEMENT", 0, 0); }
	;

return_word:
	RETURN 
		{ if (entry_seen == 1) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0; } }
	;

return_expr:
	no_echo expr echo
		{ if (entry_seen != 1)
		     fprintf(foutput, "%s", MonBuffer); }
	;

return_semicolon:
	';' 
		{ if (entry_seen == 1) {
		     PrBuffer[0] = '\0';
		     PrBuffer_length = 0; } }
	;

wait_on_stmt:
        wait_on_word condition semicolon
		{ if (monitor_seen == 2 )
		     generate_wait_on( CondName, "0" ); }
        | wait_on_word condition with_word wait_expr semicolon
		{ if (monitor_seen == 2 )
		     generate_wait_on( CondName, MonBuffer); }
        | wait_on_word error ';'
		{ if (monitor_seen == 2 ) 
                     error("INVALID uWait STATEMENT", 0, 0); }
        | wait_on_word condition error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); }
        | wait_on_word condition with_word error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); }
        | wait_on_word condition with_word wait_expr error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uWait STATEMENT", 0, 0); }
	;

wait_on_word:
	WAIT_ON skip
		{ if (monitor_seen != 2)
		      error("uWait MUST BE IN A MONITOR ROUTINE", 0, 0); }
	;

condition:
	no_echo expr echo
		{ if (monitor_seen == 2) {
		     if ( CondName ) free( CondName );
		     CondName = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( CondName, MonBuffer ); } }
	;

with_word:
	WITH skip 
	;

wait_expr:
	no_echo expr echo
	;

semicolon:
	';' skip 
	;

notify_stmt:
        notify_word condition semicolon
		{ if (monitor_seen == 2)
		      generate_notify( CondName ); }
        | notify_word error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uSignal STATEMENT", 0, 0); }
        | notify_word condition error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uSignal STATEMENT", 0, 0); }
	;

notify_word:
	NOTIFY skip
		{ if (monitor_seen != 2)
		      error("uSignal MUST BE IN A MONITOR ROUTINE", 0, 0);
		  else if ( MonType == PriorityAutomaticSignal || MonType == NoPriorityAutomaticSignal ) 
		      error("uSignal IS NOT MEANINGFUL IN A AutomaticSignal MONITOR", 0, 0);
		  else if ( entry_seen == 0 && ( MonType == PriorityImmediateReturn || MonType == NoPriorityImmediateReturn ) )
		      error("uSignal MUST BE IN AN ENTRY ROUTINE FOR Immediate Return MONITOR", 0, 0); }
	;

wait_until_stmt:
	wait_until_word wait_expr semicolon
		{ if ( monitor_seen == 2 && ( MonType == PriorityAutomaticSignal || MonType == NoPriorityAutomaticSignal ) )
		      generate_wait_until( MonBuffer ); }
        | wait_until_word error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uWaitUntil STATEMENT", 0, 0); }
        | wait_until_word wait_expr error ';'
		{ if (monitor_seen == 2) 
                     error("INVALID uWaitUntil STATEMENT", 0, 0); }
	;

wait_until_word:
	WAIT_UNTIL skip
	;

notify_return_stmt:
        notify_word condition return_word semicolon
		{ if (monitor_seen == 2)
		      generate_notify_return( CondName, void_entry, 0 ); }
        | notify_word condition return_word return_expr semicolon
		{ if (monitor_seen == 2)
		      generate_notify_return( CondName, void_entry, 1, MonBuffer ); }
        | notify_word condition return_word error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and return STATEMENT", 0, 0); }
        | notify_word condition return_word return_expr error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and return STATEMENT", 0, 0); }
	;

notify_wait_on_stmt:
        notify_word condition wait_on_word condition2 semicolon
		{ if (monitor_seen == 2)
		      generate_notify_wait_on( CondName, CondName2, "0" ); }
        | notify_word condition wait_on_word condition2 with_word wait_expr semicolon
		{ if (monitor_seen == 2)
		      generate_notify_wait_on( CondName, CondName2, MonBuffer ); }
        | notify_word condition wait_on_word error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); }
        | notify_word condition wait_on_word condition2 error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); }
        | notify_word condition wait_on_word condition2 with_word error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); }
        | notify_word condition wait_on_word condition2 with_word wait_expr error ';'
		{ if (entry_seen == 1)
		     error("INVALID signal and wait STATEMENT", 0, 0); }
	;

condition2:
	no_echo expr echo
		{ if (monitor_seen == 2) {
		     if ( CondName2 ) free( CondName2 );
		     CondName2 = ( char * )xmalloc( MonBuffer_length + 1 );
		     strcpy( CondName2, MonBuffer ); } }
	;

begin_entry:
	echo
		{ if (entry_seen == 1) {
		      generate_begin_entry( void_entry, FrontType, BackType, MonBuffer );
		      entry_type = 0; } }
	;

end_entry:
	/* empty */
		{ if (entry_seen == 1)
		      generate_end_entry( void_entry ); }
	;

star:
	/* empty */
		{ if (star_seen < level) 
		     star_seen += level; }
	;

modify_typedef:
	/* empty */
		{ modify_typedef(last_id); }
	;

add_typedef:
	/* empty */
		{ if (typedef_seen >= level) 
		     if (void_seen >= level && star_seen < level)
		        add_typedef(last_id, 1);
		     else if (condition_seen >= level && star_seen < level)
		        add_typedef(last_id, -1);
		     else
		        add_typedef(last_id, 0); }
	;

reset1:
	/* empty */
		{ pop_level();
		  identifier %= level;
		  function %= level;
		  pointer %= level;
		  vector %= level;
		  typedef_seen %= level;
		  condition_seen %= level;
		  void_seen %= level;
		  star_seen %= level;
		  level /= 2; }
	;

reset0:
	/* empty */
		{ identifier %= level;
		  function %= level;
		  pointer %= level;
		  vector %= level;
		  typedef_seen %= level;
		  condition_seen %= level;
		  void_seen %= level;
		  star_seen %= level; }
	;

mark_back: 
	/* empty */
		{ if (entry_type == 2 && mark == 0) {
		     mark = 1;
		     back_mark = MonBuffer_length; } }
	;

correct_back:
	/* empty */
		{ if (mark == 1) {
		     mark = 2;
		     if (identifier >= level) {
			if ( BackType ) free( BackType );
			BackType = ( char * )xmalloc( back_mark + 1 );
			strncpy( BackType, MonBuffer, back_mark );
			BackType[back_mark] = '\0';
		     } else {
			if ( BackType ) free( BackType );
			BackType = ( char * )xmalloc( MonBuffer_length + 1 );
			strcpy( BackType, MonBuffer ); } } }
	;

end_back:
	/* empty */
		{ entry_type = 3;
		  if (entry_seen == 1 && void_seen == 1)
		     if (level == 2 && pointer == 0)
		        void_entry = 1; }
	;

function_decl:
	/* empty */
		{ if (function < level) {
		     if (vector >= level)
		        vector -= level;
		     else if (pointer >= level)
			pointer -= level;
		     else if (identifier >= level)
		        identifier -= level;
		     function += level; } }
	;

vector_decl:
	/* empty */
		{ if (identifier >= level) {
		     identifier -= level;
		     if (arg_list == 0)
		        vector += level;
		     else
		        pointer += level;
		  } else if (function >= level) {
		     function -= level;
		     pointer += level; } }
	;

pointer_decl:
	/* empty */
		{ if (pointer < level) {
		     if (vector >= level)
		        vector -= level;
		     else if (function >= level)
			function -= level;
		     else if (identifier >= level)
		        identifier -= level;
		     pointer += level; } }
	;

identifier_decl:
	/* empty */
		{ identifier += level; }
	;

arg_list_start:
	/* empty */
		{ arg_list += level; }
	;

arg_list_end:
	/* empty */
		{ arg_list -= level; }
	;

add_condition:
	/* empty */
/*
		{ if (condition_seen == 1 && typedef_seen == 0 && level == 2) {
		     if (pointer == 0)
		        if (vector == 2)
			   add_condition(0, cond_name);
		        else if (identifier == 2)
			   add_condition(1, cond_name);
		  }
		  if (condition_seen >= level / 2 && typedef_seen < level / 2)
		     if (pointer < level)
		        if (function >= level)
			   error("FUNCTION RETURNING CONDITION");
			else if (vector >= level && level > 2)
		           error("CONDITION MAY ONLY BE DEFINED AT FIRST LEVEL");
			else if (identifier >= level && level > 2)
			   if (arg_list == level)
			      error("FUNCTION WITH A CONDITION ARGUMENT");
			   else
		              error("CONDITION MAY ONLY BE DEFINED AT FIRST LEVEL"); }
*/
	;

reset:
	/* empty */
		{ if (monitor_seen != 0) {
		     void_entry = 0;
		     entry_seen = 0;  
		     local_seen = 0;
		     monitor_seen = 1; } }
	;
%%

int lineno;			/* current line number in file being read */

FILE *finput;			/* input file.
				   Normally a pipe from the preprocessor.  */

/* lexical analyzer */

static int maxtoken;		/* Current nominal length of token buffer */
static char *token_buffer;	/* Pointer to token buffer.
				   Actual allocated length is maxtoken + 2.  */

static new_line_number; /* mpp */

#ifndef DOLLARS_IN_IDENTIFIERS
#define DOLLARS_IN_IDENTIFIERS 0
#endif
int dollars_in_ident = DOLLARS_IN_IDENTIFIERS;

#define MAXRESERVED 10 /* mpp */

/* frw[I] is index in `reswords' of the first word whose length is I;
   frw[I+1] is one plus the index of the last word whose length is I.
   The length of frw must be MAXRESERVED + 2 so there is an element
   at MAXRESERVED+1 for the case I == MAXRESERVED.  */

static char frw[MAXRESERVED+2] =
/*  0  1  2  3  4   5   6   7   8   9  10  11       mpp */
  { 0, 0, 0, 2, 5, 14, 21, 33, 36, 41, 42, 43 }; /* mpp */

/* Table of reserved words.  */

struct resword { char *name; short token; enum rid rid;};

#define NORID RID_UNUSED

static struct resword reswords[]
  = {{"if", IF, NORID},
     {"do", DO, NORID},
     {"int", TYPESPEC, RID_INT},
     {"for", FOR, NORID},
     {"asm", ASM, NORID},
     {"case", CASE, NORID},
     {"char", TYPESPEC, RID_CHAR},
     {"auto", SCSPEC, RID_AUTO},
     {"goto", GOTO, NORID},
     {"else", ELSE, NORID},
     {"long", TYPESPEC, RID_LONG},
     {"void", TYPESPEC, RID_VOID},
     {"enum", ENUM, NORID},
     {"with", WITH, NORID}, /* mpp */
     {"float", TYPESPEC, RID_FLOAT},
     {"short", TYPESPEC, RID_SHORT},
     {"union", UNION, NORID},
     {"break", BREAK, NORID},
     {"while", WHILE, NORID},
     {"const", TYPE_QUAL, RID_CONST},
     {"uWait", WAIT_ON, NORID}, /* mpp */
     {"double", TYPESPEC, RID_DOUBLE},
     {"static", SCSPEC, RID_STATIC},
     {"extern", SCSPEC, RID_EXTERN},
     {"struct", STRUCT, NORID},
     {"return", RETURN, NORID},
     {"sizeof", SIZEOF, NORID},
     {"typeof", TYPEOF, NORID},
     {"switch", SWITCH, NORID},
     {"signed", TYPESPEC, RID_SIGNED},
     {"inline", SCSPEC, RID_INLINE},
     {"uEntry", ENTRY, NORID}, /* mpp */
     {"uLocal", LOCAL, NORID}, /* mpp */
     {"uSignal", NOTIFY, NORID}, /* mpp */
     {"typedef", SCSPEC, RID_TYPEDEF},
     {"default", DEFAULT, NORID},
     {"uMonitor", MONITOR, NORID}, /* mpp */
     {"unsigned", TYPESPEC, RID_UNSIGNED},
     {"continue", CONTINUE, NORID},
     {"register", SCSPEC, RID_REGISTER},
     {"volatile", TYPE_QUAL, RID_VOLATILE},
     {"__alignof", ALIGNOF, NORID},
     {"uWaitUntil", WAIT_UNTIL, NORID}, /* mpp */
}; /* mpp */

int check_newline ();

void
init_lex ()
{
  extern char *malloc ();

  /* Start it at 0, because check_newline is called at the very beginning
     and will increment it to 1.  */
  lineno = 0;

  maxtoken = 40;
  token_buffer = malloc (maxtoken + 2);
  last_id = malloc (maxtoken + 2); /* mpp */
}

/* If C is not whitespace, return C.
   Otherwise skip whitespace and return first nonwhite char read.  */

static int
skip_white_space (c)
     register int c;
{
  register int inside;

  for (;;)
    {
      switch (c)
	{
	case '/':
	  c = getc (finput);
	  if (c != '*')
	    {
	      ungetc (c, finput);
	      return '/';
	    }

          echo ('/'); /* mpp */
          echo ('*'); /* mpp */
	  c = getc (finput);

	  inside = 1;
	  while (inside)
	    {
	      if (c == '*')
		{
		  while (c == '*')
		    { echo ('*'); c = getc (finput); } /* mpp */

		  if (c == '/')
		    {
                      echo ('/'); /* mpp */
		      inside = 0;
		      c = getc (finput);
		    }
		}
	      else if (c == '\n')
		{
                  echo ('\n'); /* mpp */
		  lineno++;
		  c = getc (finput);
		}
	      else if (c == EOF)
		{
		  break;
		}
	      else
		{ echo (c); c = getc (finput); } /* mpp */
	    }

	  break;

	case '\n':
          echo ('\n'); /* mpp */
	  c = check_newline ();
	  break;

	case ' ':
	case '\t':
	case '\f':
	case '\r':
	case '\b':
          echo (c); /* mpp */
	  c = getc (finput);
	  break;

	case '\\':
          echo ('\\'); /* mpp */
	  c = getc (finput);
          echo (c); /* mpp */
	  if (c == '\n')
	    lineno++;
	  c = getc (finput);
	  break;

	default:
	  return (c);
	}
    }
}



/* Make the token buffer longer, preserving the data in it.
   P should point to just beyond the last valid character in the old buffer.
   The value we return is a pointer to the new buffer
   at a place corresponding to P.  */

static char *
extend_token_buffer (p)
     char *p;
{
  int offset = p - token_buffer;

  maxtoken = maxtoken * 2 + 10;
  token_buffer = (char *) realloc (token_buffer, maxtoken + 2);
  if (token_buffer == 0)
    fatal ("virtual memory exceeded", 0, 0);
  last_id = (char *) realloc (last_id, maxtoken + 2); /* mpp */
  if (last_id == 0) /* mpp */
    fatal ("virtual memory exceeded", 0, 0); /* mpp */

  return token_buffer + offset;
}

/* At the beginning of a line, increment the line number
   and handle a #line directive immediately following.
   Return first nonwhite char of first non-# line following.  */

int
check_newline ()
{
  register int c;
  register int token;

  while (1)
    {
      lineno++;

      /* Read first nonwhite char on the line.  */

      c = getc (finput);
      while (c == ' ' || c == '\t')
	{ echo (c), c = getc (finput); } /* mpp */

      if (c != '#')
	{
	  /* If not #, return it so caller will use it.  */
	  return c;
	}

      /* Read first nonwhite char after the `#'.  */

      echo ('#'); /* mpp */
      c = getc (finput);
      while (c == ' ' || c == '\t')
	{ echo (c), c = getc (finput); } /* mpp */

      /* If a letter follows, then if the word here is `line', skip
	 it and ignore it; otherwise, ignore the line, with an error
	 if the word isn't `pragma'.  */

      if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
	{
	  if (c == 'l') /* mpp */
            { /* mpp */
              echo ('l'); /* mpp */
              if ((c = getc (finput)) == 'i') /* mpp */
                { /* mpp */
                  echo ('i'); /* mpp */
                  if ((c = getc (finput)) == 'n') /* mpp */
                    { /* mpp */
                      echo ('n'); /* mpp */
                      if ((c = getc (finput)) == 'e') /* mpp */
                        { /* mpp */
                          echo ('e'); /* mpp */
	                  if ((c = getc (finput)) == ' ' || c == '\t') /* mpp */
	                      goto linenum; /* mpp */
	                } /* mpp */
	            } /* mpp */
	        } /* mpp */
	    } /* mpp */

	noerror:

	  if (c == 0) /* mpp */
	    return 0; /* mpp */
          echo (c); /* mpp */

	  while ((c = getc (finput)) && c != '\n') echo (c); /* mpp */

	  if (c == 0)
	    return 0;
          echo ('\n'); /* mpp */
	  continue;
	}

    linenum:
      /* Here we have either `#line' or `# <nonletter>'.
	 In either case, it should be a line number; a digit should follow.  */

      while (c == ' ' || c == '\t')
	{ echo (c); c = getc (finput); } /* mpp */

      /* If the # is the only nonwhite char on the line,
	 just ignore it.  Check the new newline.  */
      if (c == '\n')
	{ echo ('\n'); continue; } /* mpp */

      /* Something follows the #; read a token.  */

      ungetc (c, finput);
      /* echo( 'l' ); echo( 'i' ); echo( 'n' ); echo( 'e' ); echo( ' ' ); */ /* mpp */
      token = yylex ();

      if (token == CONSTANT && yylval == 1) /* mpp */
	{
	  /* subtract one, because it is the following line that
	     gets the specified number */

          int string_length; /* mpp */
	  int l = new_line_number - 1; /* mpp */

	  /* Is this the last nonwhite stuff on the line?  */
	  c = getc (finput);
	  while (c == ' ' || c == '\t')
	    { echo(c); c = getc (finput); } /* mpp */
	  if (c == '\n')
	    {
              echo ('\n'); /* mpp */
	      /* No more: store the line number and check following line.  */
	      lineno = l;
	      continue;
	    }
	  ungetc (c, finput);

	  /* More follows: it must be a string constant (filename).  */

	  token = yylex ();
	  if (token != STRING) /* mpp */
	    {
	      return getc (finput);
	    }

          string_length = strlen(token_buffer); /* mpp */
          token_buffer[string_length - 1] = '\0'; /* mpp */
	  input_filename
            = (char *) malloc (string_length); /* mpp */
	  strcpy (input_filename, token_buffer + 1); /* mpp */
	  lineno = l;

	  if (main_input_filename == 0)
	    main_input_filename = input_filename;
	}

      /* skip the rest of this line.  */
      while ((c = getc (finput)) && c != '\n') echo (c); /* mpp */
      if (c == 0)
	return 0;
      echo ('\n'); /* mpp */
    }
}

#define isalnum(char) ((char >= 'a' && char <= 'z') || (char >= 'A' && char <= 'Z') || (char >= '0' && char <= '9'))
#define isdigit(char) (char >= '0' && char <= '9')
#define ENDFILE -1  /* token that represents end-of-file */


static int
readescape ()
{
  register int c = getc (finput);
  register int count, code;

  echo ('\\'); /* mpp */
  switch (c)
    {
    case 'x':
      code = 0;
      count = 0;
      while (1)
	{
	  c = getc (finput);
	  if (!(c >= 'a' && c <= 'f')
	      && !(c >= 'A' && c <= 'F')
	      && !(c >= '0' && c <= '9'))
	    {
	      ungetc (c, finput);
	      break;
	    }
	  code *= 16;
	  if (c >= 'a' && c <= 'f')
	    code += c - 'a' + 10;
	  if (c >= 'A' && c <= 'F')
	    code += c - 'A' + 10;
	  if (c >= '0' && c <= '9')
	    code += c - '0';
	  count++;
	}
      return code;

    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':
      code = 0;
      count = 0;
      while ((c <= '7') && (c >= '0') && (count++ < 3))
	{
          echo (c); /* mpp */
	  code = (code * 8) + (c - '0');
	  c = getc (finput);
	}
      ungetc (c, finput);
      return code;

    case '\\': case '\'': case '"':
      echo (c); /* mpp */
      return c;

    case '\n':
      echo ('\n'); /* mpp */
      lineno++;
      return -1;

    case 'n':
      echo ('n'); /* mpp */
      return 012; /* mpp */

    case 't':
      echo ('t'); /* mpp */
      return 011; /* mpp */

    case 'r':
      echo ('r'); /* mpp */
      return 015; /* mpp */

    case 'f':
      echo ('f'); /* mpp */
      return 014; /* mpp */

    case 'b':
      echo ('b'); /* mpp */
      return 010; /* mpp */

    case 'a':
      echo ('a'); /* mpp */
      return 007; /* mpp */

    case 'v':
      echo ('v'); /* mpp */
      return 013; /* mpp */

    case 'E':
      echo ('E'); /* mpp */
      return 033;

    case '?':
      /* `\(', etc, are used at beginning of line to avoid confusing Emacs.  */
    case '(':
    case '{':
    case '[':
      echo (c); /* mpp */
      return c;
    }
  echo (c); /* mpp */
  return c;
}

void
yyerror (string)
     char *string;
{
}

static int nextchar = -1;

static int
yylex ()
{
  register int c;
  register char *p;
  register int value;
  int wide_flag = 0;

  printbuffer (0); /* mpp */

  if (nextchar >= 0)
    c = nextchar, nextchar = -1;
  else
    c = getc (finput);

  /* Effectively do c = skip_white_space (c)
     but do it faster in the usual cases.  */
  while (1)
    switch (c)
      {
      case ' ':
      case '\t':
      case '\f':
      case '\r':
      case '\b':
        echo (c); /* mpp */
	c = getc (finput);
	break;

      case '\n':
      case '/':
      case '\\':
	c = skip_white_space (c);
      default:
	goto found_nonwhite;
      }
 found_nonwhite:

  token_buffer[0] = c;
  token_buffer[1] = 0;

  printbuffer (1); /* mpp */

/*  yylloc.first_line = lineno; */

  switch (c)
    {
    case EOF:
      token_buffer[0] = 0;
      value = ENDFILE;
      break;

    case '$':
      if (dollars_in_ident)
	goto letter;
      return '$';

    case 'L':
      /* Capital L may start a wide-string or wide-character constant.  */
      {
	register int c = getc (finput);
	if (c == '\'')
	  {
            echo ('L'); /* mpp */
	    wide_flag = 1;
	    goto char_constant;
	  }
	if (c == '"')
	  {
            echo ('L'); /* mpp */
	    wide_flag = 1;
	    goto string_constant;
	  }
	ungetc (c, finput);
      }

    case 'A':  case 'B':  case 'C':  case 'D':  case 'E':
    case 'F':  case 'G':  case 'H':  case 'I':  case 'J':
    case 'K':		  case 'M':  case 'N':  case 'O':
    case 'P':  case 'Q':  case 'R':  case 'S':  case 'T':
    case 'U':  case 'V':  case 'W':  case 'X':  case 'Y':
    case 'Z':
    case 'a':  case 'b':  case 'c':  case 'd':  case 'e':
    case 'f':  case 'g':  case 'h':  case 'i':  case 'j':
    case 'k':  case 'l':  case 'm':  case 'n':  case 'o':
    case 'p':  case 'q':  case 'r':  case 's':  case 't':
    case 'u':  case 'v':  case 'w':  case 'x':  case 'y':
    case 'z':
    case '_':
    letter:
      p = token_buffer;
      while (isalnum (c) || c == '_' || c == '$')
	{
	  if (p >= token_buffer + maxtoken)
	    p = extend_token_buffer (p);
	  if (c == '$' && ! dollars_in_ident)
	    break;

          echo (c); /* mpp */
	  *p++ = c;
	  c = getc (finput);
	}

      *p = 0;
      nextchar = c;

      value = IDENTIFIER;
      yylval = 0; /* mpp */

      /* Try to recognize a keyword.  */

      if (p - token_buffer <= MAXRESERVED)
	{
	  register int lim = frw [p - token_buffer + 1];
	  register int i = frw[p - token_buffer];
	  register struct resword *p = &reswords[i];

	  for (; i < lim; i++, p++)
	    if (p->name[0] == token_buffer[0]
		&& !strcmp (p->name, token_buffer))
	      {
		  yylval = (int) p->rid; /* mpp */
		  value = (int) p->token;
		break;
	      }
	}

      /* If we did not find a keyword, look for an identifier
	 (or a typename).  */

      if (value == IDENTIFIER)
	{
          if (lookup_id (token_buffer) == 0) /* mpp */
	    value = TYPENAME;
          strcpy (last_id, token_buffer); /* mpp */
	}

      break;

    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':  case '8':  case '9':
    case '.':
      {
	int base = 10;
	int count = 0;
	int largest_digit = 0;
	int numdigits = 0;
	/* for multi-precision arithmetic,
	   we store only 8 live bits in each short,
	   giving us 64 bits of reliable precision */
	short shorts[8];

	enum { NOT_FLOAT, AFTER_POINT, TOO_MANY_POINTS} floatflag
	  = NOT_FLOAT;

	for (count = 0; count < 8; count++)
	  shorts[count] = 0;

	p = token_buffer;
	*p++ = c;

	if (c == '0')
	  {
            echo ('0'); /* mpp */
	    *p++ = (c = getc (finput));
	    if ((c == 'x') || (c == 'X'))
	      {
                echo (c); /* mpp */
		base = 16;
		*p++ = (c = getc (finput));
	      }
	    else
	      {
		base = 8;
		numdigits++;
	      }
	  }

	/* Read all the digits-and-decimal-points.  */

	while (c == '.'
	       || (isalnum (c) && (c != 'l') && (c != 'L')
		   && (c != 'u') && (c != 'U')
		   && (floatflag == NOT_FLOAT || ((c != 'f') && (c != 'F')))))
	  {
	    if (c == '.')
	      {
                echo ('.'); /* mpp */
		if (floatflag == AFTER_POINT)
		    floatflag = TOO_MANY_POINTS;
		else
		  floatflag = AFTER_POINT;

		base = 10;
		*p++ = c = getc (finput);
		/* Accept '.' as the start of a floating-point number
		   only when it is followed by a digit.
		   Otherwise, unread the following non-digit
		   and use the '.' as a structural token.  */
		if (p == token_buffer + 2 && !isdigit (c))
		  {
		    if (c == '.')
		      {
                        echo ('.'); /* mpp */
			c = getc (finput);
			if (c == '.')
			  {
			    echo( '.' );
			    *p++ = c;
			    *p = 0;
			    return ELLIPSIS;
			  }
		      }
		    ungetc (c, finput);
		    token_buffer[1] = 0;
		    value = '.';
		    goto done;
		  }
	      }
	    else
	      {
		/* It is not a decimal point.
		   It should be a digit (perhaps a hex digit).  */

		if (isdigit (c))
		  {
                    echo (c); /* mpp */
		    c = c - '0';
		  }
		else if (base <= 10)
		  {
                    echo (c); /* mpp */
		    if ((c&~040) == 'E')
		      {
			base = 10;
			floatflag = AFTER_POINT;
			break;   /* start of exponent */
		      }
		    c = 0;
		  }
		else if (c >= 'a')
		  {
                    echo (c); /* mpp */
		    c = c - 'a' + 10;
		  }
		else
		  {
                    echo (c); /* mpp */
		    c = c - 'A' + 10;
		  }
		if (c >= largest_digit)
		  largest_digit = c;
		numdigits++;
	    
		for (count = 0; count < 8; count++)
		  {
		    (shorts[count] *= base);
		    if (count)
		      {
			shorts[count] += (shorts[count-1] >> 8);
			shorts[count-1] &= (1<<8)-1;
		      }
		    else shorts[0] += c;
		  }
    
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = (c = getc (finput));
	      }
	  }

	/* Remove terminating char from the token buffer and delimit the string */
	*--p = 0;

	if (floatflag != NOT_FLOAT)
	  {
	    char f_seen = 0;
	    char l_seen = 0;

	    /* Read explicit exponent if any, and put it in tokenbuf.  */

	    if ((c == 'e') || (c == 'E'))
	      {
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
		if ((c == '+') || (c == '-'))
		  {
                    echo (c); /* mpp */
		    *p++ = c;
		    c = getc (finput);
		  }
	        while (isdigit (c))
		  {
                    echo (c); /* mpp */
		    if (p >= token_buffer + maxtoken - 3)
		      p = extend_token_buffer (p);
		    *p++ = c;
		    c = getc (finput);
		  }
	      }

	    *p = 0;

	    /* Read the suffixes to choose a data type.  */
	    while (1)
	      {
		if (c == 'f' || c == 'F')
		  {
		    f_seen = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    l_seen = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			while (isalnum (c))
			  {
                            echo (c); /* mpp */
			    if (p >= token_buffer + maxtoken - 3)
			      p = extend_token_buffer (p);
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
                echo (c); /* mpp */
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
	      }

            yylval = 0; /* mpp */
	    ungetc (c, finput);
	    *p = 0;
	  }
	else
	  {
	    int spec_unsigned = 0;
	    int spec_long = 0;

	    while (1)
	      {
		if (c == 'u' || c == 'U')
		  {
		    spec_unsigned = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    spec_long = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			while (isalnum (c))
			  {
                            echo (c); /* mpp */
			    if (p >= token_buffer + maxtoken - 3)
			      p = extend_token_buffer (p);
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
                echo (c); /* mpp */
		if (p >= token_buffer + maxtoken - 3)
		  p = extend_token_buffer (p);
		*p++ = c;
		c = getc (finput);
	      }

	    ungetc (c, finput);

	    /* This is simplified by the fact that our constant
	       is always positive.  */
            yylval = 1; /* mpp */
	    new_line_number = (shorts[3]<<24) + (shorts[2]<<16) + (shorts[1]<<8) + shorts[0]; /* mpp */

	  }

	value = CONSTANT; break;
      }

    case '\'':
    char_constant:
      echo ('\''); /* mpp */
      c = getc (finput);
      {
	register int code = 0;

      tryagain:

	if (c == '\\')
	  {
	    c = readescape ();
	    if (c < 0)
	      goto tryagain;
	  }
	else if (c == '\n')
	  {
            echo ('\n'); /* mpp */
	    lineno++;
	  }
        else /* mpp */
          echo (c); /* mpp */

	code = c;
	token_buffer[1] = c;
	token_buffer[2] = '\'';
	token_buffer[3] = 0;

	c = getc (finput);
        echo (c); /* mpp */

        yylval = 0; /* mpp */
	value = CONSTANT; break;
      }

    case '"':
    string_constant:
      {
        echo ('\"'); /* mpp */
	c = getc (finput);
	p = token_buffer + 1;

	while (c != 0 && c != '"') /* mpp */
	  {
	    if (c == '\\')
	      {
		c = readescape ();
		if (c < 0)
		  goto skipnewline;
	      }
	    else if (c == '\n')
	      {
                echo ('\n'); /* mpp */
		lineno++;
	      }
            else /* mpp */
              echo (c); /* mpp */

	    if (p == token_buffer + maxtoken)
	      p = extend_token_buffer (p);
	    *p++ = c;

	  skipnewline:
	    c = getc (finput);
	  }

        if (c == '\"') /* mpp */
           echo ('\"'); /* mpp */
	*p = 0;

        yylval = 0; /* mpp */

	*p++ = '"';
	*p = 0;

	value = STRING; break;
      }
      
    case '+':
    case '-':
    case '&':
    case '|':
    case '<':
    case '>':
    case '*':
    case '/':
    case '%':
    case '^':
    case '!':
    case '=':
      {
	register int c1;

      combine:

	switch (c)
	  {
	  case '+':
	  case '-':
	  case '&':
	  case '|':
	  case '*':
	  case '/':
	  case '%':
	  case '^':
	  case LSHIFT:
	  case RSHIFT:
	  case '<':
	  case '>':
            yylval = 0; break; /* mpp */
	  }	

	token_buffer[1] = c1 = getc (finput);
	token_buffer[2] = 0;

	if (c1 == '=')
	  {
            if (c != LSHIFT && c != RSHIFT) /* mpp */
              echo (c); /* mpp */
            echo (c1); /* mpp */
	    switch (c)
	      {
	      case '<':
		value = ARITHCOMPARE; yylval = 0; goto done; /* mpp */
	      case '>':
		value = ARITHCOMPARE; yylval = 0; goto done; /* mpp */
	      case '!':
		value = EQCOMPARE; yylval = 0; goto done; /* mpp */
	      case '=':
		value = EQCOMPARE; yylval = 0; goto done; /* mpp */
	      }	
	    value = ASSIGN; goto done;
	  }
	else if (c == c1)
	  switch (c)
	    {
	    case '+':
              echo ('+'); echo ('+'); /* mpp */
	      value = PLUSPLUS; goto done;
	    case '-':
              echo ('-'); echo ('-'); /* mpp */
	      value = MINUSMINUS; goto done;
	    case '&':
              echo ('&'); echo ('&'); /* mpp */
	      value = ANDAND; goto done;
	    case '|':
              echo ('|'); echo ('|'); /* mpp */
	      value = OROR; goto done;
	    case '<':
              echo ('<'); echo ('<'); /* mpp */
	      c = LSHIFT;
	      goto combine;
	    case '>':
              echo ('>'); echo ('>'); /* mpp */
	      c = RSHIFT;
	      goto combine;
	    }
	else if ((c == '-') && (c1 == '>'))
	  { echo ('-'); echo ('>'); value = POINTSAT; goto done; } /* mpp */
	ungetc (c1, finput);
	token_buffer[1] = 0;

        if (c != RSHIFT && c != LSHIFT) /* mpp */
          echo (c); /* mpp */
	if ((c == '<') || (c == '>'))
	  value = ARITHCOMPARE;
	else value = c;
	goto done;
      }

    default:
      echo (c); /* mpp */
      value = c;
    }

done:
/*  yylloc.last_line = lineno; */

  return value;
}
