/*
 *     execshell  shell_pathname  shell_name  [ args... ]
 *
 * Execute any program as a shell, setting the SHELL= environment
 * variable.  Lets a user choose argv[0] to pass to the shell, so
 * "-" may be used to invoke a login shell.
 * 
 * Note that the new environment SHELL= variable is taken from
 * the first argument, so it should normally be a full pathname.
 *
 * If the given program can't be found, the user's SHELL= is used.
 * If that can't be found, /bin/sh is used.
 *
 * Author: Ian! D. Allen,  University of Waterloo
 */
#include <stdio.h>

#define SHELL	"SHELL="/* Environment variable containing SHELL pathname */
#define SHLEN	6	/* Number of chars in 'SHELL=' 			  */

#define BSHELL	"/bin/sh"

static char	*cmdname;			  /* Pointer to argv[0]	*/

static char	shellstr[BUFSIZ+SHLEN+1] = SHELL; /* for new environ line*/

main(argc,argv,envp)
register int	argc;
register char	**argv;
register char	**envp;
{
    register char	*oldshell;
    extern char		*strcat();

    cmdname = argv[0];

    if( argc < 3 ){
	eprintf( "Usage: %s shell_pathname shell_name [ args... ]\n", cmdname );
	/*NOTREACHED*/
    }
    if( strlen(argv[1]) > BUFSIZ ){
	eprintf( "Shell path '%s' longer than %d chars", argv[1], BUFSIZ );
	/*NOTREACHED*/
    }

    for( ; *envp != 0; envp++ ){
	if( strncmp(*envp,SHELL,SHLEN) ){
	    continue;
	}
	oldshell = *envp;
	*envp = strcat(shellstr,argv[1]);
	break;
    }
    if( *envp == 0 ){
	wprintf( "Could not find '%s' in environment\n", SHELL );
	oldshell = "SHELL=/bin/sh";
    }

    execvp( argv[1], argv+2 );
    errmsg( "Could not EXECVE '%s' as '%s'\n", argv[1], argv[2] );
    wprintf( "Calling shell '%s'\n", oldshell+SHLEN );
    if( *envp != 0 ){
	*envp = oldshell;
    }
    execlp( oldshell+SHLEN, oldshell+SHLEN, 0 );
    errmsg( "Could not EXECLE '%s' as '%s'\n", oldshell+SHLEN, oldshell+SHLEN );
    if( strcmp( oldshell+SHLEN, BSHELL ) ){
	wprintf( "Calling shell '%s'\n", BSHELL );
	if( *envp != 0 ){
	    *envp = "SHELL=/bin/sh";
	}
	execlp( BSHELL, BSHELL, 0 );
	errmsg( "Could not EXECLE '%s' as '%s'\n", BSHELL, BSHELL );
    }
    exit( 2 );
}

/* VARARGS1 */
errmsg( args )
char *args;
{
    extern int errno, sys_nerr;
    extern char *sys_errlist[];

    fprintf( stderr, "%s: %s: %r",
		     cmdname,
		     errno < sys_nerr ? sys_errlist[errno] : "Unknown error",
		     &args );
}

/* VARARGS1 */
eprintf( args )
char *args;
{
    fprintf( stderr, "%s: %r", cmdname, &args );
    exit( 1 );
}

/* VARARGS1 */
wprintf( args )
char *args;
{
    fprintf( stderr, "%s: %r", cmdname, &args );
}
