/*                               -*- Mode: C -*- 
 * 
 * uC++ Version 3.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1992
 * 
 * uMalloc.i -- 
 * 
 * Author           : Johan Larson
 * Created On       : Mon Jun  1 17:34:32 1992
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Thu Jul 16 15:48:47 1992
 * Update Count     : 7
 */


#if defined( __sgi__ )

#define shmalloc malloc
#define shfree free
#define shrealloc realloc

#elif defined( __encore__ )

#define shmalloc share_malloc
#define shfree share_free
#define shrealloc share_realloc

void *share_realloc( void *old, int size ) {
    uNoExtendExMsg msg;

    msg.base.msg = "uRealloc: Shared memory reallocation not available.\n";
    msg.base.size = size;
    msg.addr = old;

    uRaise( NULL, &uNoExtendEx, &msg, sizeof( msg ) );

    return 0;
} /* share_realloc */

#endif

static inline void *uLowMalloc( int size ) {
    void *addr;
#ifdef __U_MULTI__
    addr = shmalloc( size );
#else
    addr = malloc( size );
#endif
    return addr;
} /* uLowMalloc */

static inline void uLowFree( void *addr ) {
#ifdef __U_MULTI__
    shfree( addr );
#else
    free( addr );
#endif
} /* uLowFree */

static inline void *uLowRealloc( void *addr, int size ) {
#ifdef __U_MULTI__
    addr = shrealloc( addr, size );
#else
    addr = realloc( addr, size );
#endif
    return addr;
} /* uLowRealloc */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
