/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uCalibrate.c -- calibrate the idle loop
 * 
 * Author           : Peter A. Buhr
 * Created On       : Thu Mar 22 22:29:36 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sat Jan 30 12:00:06 1993
 * Update Count     : 98
 */

#define __U_KERNEL__
#define __U_CALIBRATE__

#include "uUnix.h"
#include "uSystem.h"
#include "uMachine.i"
#include "uPeek.i"
#include "uQueue.i"
#include "uStack.i"
#include "Time.i"

#include "uPrivate.c"

struct uClusterD cluster = U_CLUSTER();
struct uProcessorD process = U_PROCESSOR();

/*
 * This program determines how many tenths of microseconds it takes to execute
 * one iteration of a spin loop. The time it takes to execute U_TIMES interations
 * of the loop is measured with a low resolution (0.01 second) clock.  U_TIMES is
 * sufficiently large to get an accurate time with the low resolution clock.
 * The measured time is then divided by U_TIMES to get the time for a single
 * loop iteration.
 */

#define U_CALIBRATE 1

/*
 * Currently, the user defined spin duration is specified in microseconds.
 * Normally the spin loop takes several microseonds to execute so its accuracy
 * is the single loop execution time.  However, on some machines, the loop may
 * executed in less than 1 microsecond, so the spin loop time is calculated in
 * tenths of microseconds. The spin loop accuracy is controlled by U_RESOLUTION,
 * which specifies the reciprocal of the fraction of microseconds.
 */

#define U_RESOLUTION 1

/* Execute the idle loop U_TIMES number of iterations. */

#define U_TIMES 1000000

/*
 * The following uIdle function is a copy of the spin section of the uIdle function
 * in the uKernel.  It is the spin section of code that is calibrated.
 */

#include "uIdle.i"

int main( int argc, char *argv[] ) {

    int StartTime, EndTime;

    uTaskQueue *ready = &(cluster.ready);		/* ready queue is empty */

    InitTime();
    
    process.cluster = &cluster;				/* process points at cluster */
    uWorkProcessor = &process;				/* current processor points at process */
    uWorkProcessor->cluster->spin = U_TIMES;		/* set spin time on cluster */

    StartTime = Time();

    uIdle( ready );

    EndTime = Time();

    /*
     * The spin loop time is written out as C preprocessor statements that are
     * subsequentially included when compiling the uKernel.
     */

    fprintf( stdout, "/*\n * uCalibrate.h\n */\n\n" );
    fprintf( stdout, "#define U_RESOLUTION %d\n", 10 * U_RESOLUTION );
    fprintf( stdout, "#define U_CALIBRATE %d\n", ( ( EndTime - StartTime ) * 10 * U_RESOLUTION ) / U_TIMES );
    
    return( 0 );					/* so that "make" does not terminate */
} /* main */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
