/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * os-ux.i -- BSD4.3 System Calls
 * 
 * Author           : Peter Buhr
 * Created On       : Sat Mar  6 17:08:57 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Mar 28 11:16:43 1993
 * Update Count     : 37
 */

#define uSigMask( signal ) sigmask( signal )

static inline void uSignal( int sig, void (*func)() ) {
    signal( sig, func );
} /* uSignal */

static inline int uSigBlock( int mask ) {
    return sigblock( mask );
} /* uSigBlock */

static inline int uSigSetMask( int mask ) {
    return sigsetmask( mask );
} /* uSigSetMask */

static inline int uSigPause( int mask ) {
    return sigpause( mask );
} /* uSigPause */

static inline int uKillGroup( int group, int signal ) {
    return killpg( group, signal );
} /* uKillGroup */

static inline void uSetAlarm( long msecs ) {

    /*
     * Don't use divide as gcc can generate a library call. Dividing by 1024
     * via shifting is close enough as SIGALRM in not that accurate anyway.
     * This calculation is 100% accurate for all small values (i.e. < 10 seconds)
     */
    
    long secs;
    long usecs;
    struct itimerval it;

    secs = ( msecs + 512 ) >> 10;			/* convert the milliseconds value into seconds */
    /* secs = msecs / 1000; */				/* convert the milliseconds value into seconds */
    usecs = ( msecs % 1000 ) * 1000;			/* and micro seconds */

    it.it_value.tv_sec = secs;				/* fill in the value to the next expiry */
    it.it_value.tv_usec = usecs;
    it.it_interval.tv_sec = 0;				/* fill in the interval to reset the timer with */
    it.it_interval.tv_usec = 0;

    setitimer( ITIMER_REAL, &it, NULL );		/* set the alarm */
} /* uSetAlarm */

static inline int uInUserCode( struct sigcontext *sc ) {

    void uBeginUserCode();
    void uEndUserCode();
#ifdef __hp9000s300
    return( ( sc->sc_pc > (int) uBeginUserCode ) && ( sc->sc_pc < (int) uEndUserCode ) );
#else
    return( ( sc->sc_pcoq_head > (int) uBeginUserCode ) && ( sc->sc_pcoq_head < (int) uEndUserCode ) );
#endif
}

static void uSigAlrm( int signal, int code, void *vsc ) {

    /*
     * This handler is called when SIGALRM occurs.
     * This alarm will occur as a result of time slicing
     * being enabled, a processor being woken up, or
     * a processor being terminated.
     *
     * This handler will attempt to yield the virtual
     * processor from the current task and select a new
     * task, or terminate the processor.
     */

    struct sigcontext *sc = vsc;

    uSignal( SIGALRM, uSigAlrm );			/* reset the handler */
    uSetAlarm( uGetTimeSlice() );			/* reset the alarm for the next time slice. */

    if ( uInUserCode( sc ) ) {				/* only if executing user code */
	uSigSetMask( sc->sc_mask );			/* clear the blocked signal so that more slices may occur */
	uYield();					/* yield the processor to another task */
	sc->sc_mask = uSigBlock( 0 );			/* reset the blocked signal for handler cleanup purposes */
    } /* if */
}

static inline int uFork( void (*f)( uProcessor ), uProcessor processor ) {
    return fork();
} /* uFork */
