/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-vax.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:48:44 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Mar 30 19:58:05 1993
 * Update Count     : 24
 */

#define __U_STACK_GROWS__DOWN__ 1			/* stack grows down */

static inline void uCopy( void *src, void *dst, unsigned int len ) {

    /*
     * This assembly language instruction will copy a maximum
     * of 64K bytes.  If this is not sufficient, replace this
     * line with a call to the function bcopy().
     */

    asm volatile ( "movc3 %0, (%1), (%2)" : : "g" (len), "r" (src), "r" (dst) : "r0", "r1", "r2", "r3", "r4", "r5" );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "movl sp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "movl %0, sp" : : "g" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "movl fp, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "movl %0, fp" : : "g" (addr) : "fp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movl -4(ap), %0" : "=g" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "pushr $0x2fc0" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
    asm volatile ( "popr $0x2fc0" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {
} /* uPopFloatRegs */
