/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * md-pa.i -- Machine dependent code for the uKernel.
 * 
 * Author           : Peter Buhr
 * Created On       : Sat Mar  6 17:15:32 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sat May  8 18:35:27 1993
 * Update Count     : 60
 */

#define __U_STACK_GROWS__DOWN__ 0			/* stack grows up */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    memcpy( dst, src, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {
    void *addr;

    asm volatile ( "copy %%r30,%0": "=r" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "copy %0,%%r30" : : "r" (addr) : "%r30" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {
    /* can be null if uExecuteTask and uExecuteCoroutine start by saving register 2 on the stack */
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
    /* can be null if uExecuteTask and uExecuteCoroutine start by saving register 2 on the stack */
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    asm volatile ( "copy %0,%%r22" :: "r" (begin) : "%r22" ); /* load register 22 with address of C routine */
    asm volatile ( "ldw -36(0,%%r30),%%r26" ::: "%r26" ); /* load parameter registers with first 4 arguments */
    asm volatile ( "ldw -40(0,%%r30),%%r25" ::: "%r25" );
    asm volatile ( "ldw -44(0,%%r30),%%r24" ::: "%r24" );
    asm volatile ( "ldw -48(0,%%r30),%%r23" ::: "%r23" );
    asm volatile ( "bl $$dyncall,%r31" );		/* branch to C routine */
    asm volatile ( "copy %r31,%r2" );
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    struct BasicStack {
	int  Args[0];
	int  R19SharedLib;
	int  Reserved1;
	void *ReturnLinkSharedLib;
	void *ReturnLink;
	void *StaticLink;
	int  CleanUp;
	void *ExtPtr;
	void *PrevSp;
    } *startFrame;

    stack->sp = stack->base + U_CEILING( sizeof(struct BasicStack) + len, 64 );
    startFrame = stack->sp - sizeof(struct BasicStack);
    uCopy( buf-len, (char *)(&startFrame->Args)-len, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {
    asm volatile ( "ldo 192(%r30),%r30"  );		/* increment stack 192 bytes */
    asm volatile ( "stw %r3, -32(0,%r30)" );		/* save r3-r18, while leaving room for a stack frame at top of stack */
    asm volatile ( "stw %r4, -36(0,%r30)" );
    asm volatile ( "stw %r5, -40(0,%r30)" );
    asm volatile ( "stw %r6, -44(0,%r30)" );
    asm volatile ( "stw %r7, -48(0,%r30)" );
    asm volatile ( "stw %r8, -52(0,%r30)" );
    asm volatile ( "stw %r9, -56(0,%r30)" );
    asm volatile ( "stw %r10,-60(0,%r30)" );
    asm volatile ( "stw %r11,-64(0,%r30)" );
    asm volatile ( "stw %r12,-68(0,%r30)" );
    asm volatile ( "stw %r13,-72(0,%r30)" );
    asm volatile ( "stw %r14,-76(0,%r30)" );
    asm volatile ( "stw %r15,-80(0,%r30)" );
    asm volatile ( "stw %r16,-84(0,%r30)" );
    asm volatile ( "stw %r17,-88(0,%r30)" );
    asm volatile ( "stw %r18,-92(0,%r30)" );
    asm volatile ( "ldo -96(%%r30),%%r1" ::: "%r1" );	/* r1 walks down the stack as fp registers are saved */
    asm volatile ( "fstds,ma %fr12,-8(0,%r1)" );	/* save fr12-fr16 for 1.0 and fr12-fr16 for 1.1 */
    asm volatile ( "fstds,ma %fr13,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr14,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr15,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr16,-8(0,%r1)" );
#ifdef _PA_RISC1_1
    asm volatile ( "fstds,ma %fr17,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr18,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr19,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr20,-8(0,%r1)" );
    asm volatile ( "fstds,ma %fr21,-8(0,%r1)" );
#endif
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {
    asm volatile ( "ldo -96(%%r30),%%r1" ::: "%r1" );	/* r1 walks down the stack as fp registers are restored */
    asm volatile ( "fldds,ma -8(0,%r1),%fr12" );	/* restore fr12-fr16 for 1.0 and fr12-fr16 for 1.1 */
    asm volatile ( "fldds,ma -8(0,%r1),%fr13" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr14" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr15" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr16" );
#ifdef _PA_RISC1_1
    asm volatile ( "fldds,ma -8(0,%r1),%fr17" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr18" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr19" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr20" );
    asm volatile ( "fldds,ma -8(0,%r1),%fr21" );
#endif
    asm volatile ( "ldw -32(0,%r30),%r3 " );		/* restore r3-r18 */
    asm volatile ( "ldw -36(0,%r30),%r4 " );
    asm volatile ( "ldw -40(0,%r30),%r5 " );
    asm volatile ( "ldw -44(0,%r30),%r6 " );
    asm volatile ( "ldw -48(0,%r30),%r7 " );
    asm volatile ( "ldw -52(0,%r30),%r8 " );
    asm volatile ( "ldw -56(0,%r30),%r9 " );
    asm volatile ( "ldw -60(0,%r30),%r10" );
    asm volatile ( "ldw -64(0,%r30),%r11" );
    asm volatile ( "ldw -68(0,%r30),%r12" );
    asm volatile ( "ldw -72(0,%r30),%r13" );
    asm volatile ( "ldw -76(0,%r30),%r14" );
    asm volatile ( "ldw -80(0,%r30),%r15" );
    asm volatile ( "ldw -84(0,%r30),%r16" );
    asm volatile ( "ldw -88(0,%r30),%r17" );
    asm volatile ( "ldw -92(0,%r30),%r18" );
    asm volatile ( "ldo -192(%r30),%r30" );		/* decrement stack 192 bytes */
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {
} /* uPopFloatRegs */
