/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-m68k.i -- Machine dependent code for the uKernel.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:46:04 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Thu Apr  8 15:44:29 1993
 * Update Count     : 24
 */

#define __U_STACK_GROWS__DOWN__ 1			/* stack grows down */

/*
 * Some of the definitions are conditional on __HPUX_ASM__.
 * This is defined on the Hewlet-Packard HP9000/s[34]00 if
 * gcc has not been configured to use gas.
 *
 * The HPUX mc680x0 assembler uses a proprietary syntax.
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    bcopy( src, dst, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

#ifdef __HPUX_ASM__
    asm volatile ( "mov.l %%sp, %0" : "=g" (addr) );
#else
    asm volatile ( "movel sp, %0" : "=g" (addr) );
#endif /* __HPUX_ASM__ */
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
#ifdef __HPUX_ASM__
    asm volatile ( "mov.l %0, %%sp" : : "g" (addr) : "%sp" );
#else
    asm volatile ( "movel %0, sp" : : "g" (addr) : "sp" );
#endif /* __HPUX_ASM__ */
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

#ifdef __HPUX_ASM__
    asm volatile ( "mov.l %%a6, %0" : "=g" (addr) );
#else
    asm volatile ( "movel a6, %0" : "=g" (addr) );
#endif /* __HPUX_ASM__ */
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
#ifdef __HPUX_ASM__
    asm volatile ( "mov.l %0, %%a6" : : "g" (addr) : "%a6" );
#else
    asm volatile ( "movel %0, a6" : : "g" (addr) : "a6" );
#endif /* __HPUX_ASM__ */
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

#ifdef __HPUX_ASM__
    asm volatile ( "mov.l 4(%%a6), %0" : "=g" (addr) );
#else
    asm volatile ( "movel a6@(4), %0" : "=g" (addr) );
#endif /* __HPUX_ASM__ */
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
#ifdef __HPUX_ASM__
    asm volatile ( "movem.l &0x3f3e, -(%sp)" );
#else
    asm volatile ( "moveml #0x3f3e, sp@-" );
#endif /* __HPUX_ASM__ */
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     * Notice that the register mask is the reverse of
     * what was used to save the registers.
     */
    
#ifdef __HPUX_ASM__
    asm volatile ( "movem.l (%sp)+, &0x7cfc" );
#else
    asm volatile ( "moveml sp@+, #0x7cfc" );
#endif /* __HPUX_ASM__ */
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
#ifdef __HPUX_ASM__
    asm volatile ( "fmovem &0xff, -(%sp)" );
#else
    asm volatile ( "fmovem #0xff, sp@-" );
#endif /* __HPUX_ASM__ */
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
#ifdef __HPUX_ASM__
    asm volatile ( "fmovem (%sp)+, &0xff" );
#else
    asm volatile ( "fmovem sp@+, #0xff" );
#endif /* __HPUX_ASM__ */
} /* uPopFloatRegs */
