/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cd-encore-umax-ns32k.i -- vendor dependent locking mechanisms
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:32:43 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:14:24 1992
 * Update Count     : 44
 */

#include <stdarg.h>

#include "configure/vd-encore.i"
#include "configure/os-umax.i"
#include "configure/md-ns32k.i"

static inline void uCreateLocks( void ) {

#ifdef __U_MULTI__

#   define U_SHARED_HEAP_SIZE (4096 * 1024)
    
    int code = share_malloc_init( U_SHARED_HEAP_SIZE );
    if ( code != 0 ) {
	uAbort( "uCreateLocks(): could not initialize shared heap.\n" );
    } /* if */

#endif
    
} /* uCreateLocks */

static inline void uDestroyLocks( void ) {
} /* uDestroyLocks */

static inline void uAcquireLock( uLock *mutex ) {

#ifdef __U_MULTI__
    
    /*
     * This asm code performs a test and set operation on the lock variable,
     * spinning until the lock can be acquired.  In order to cut down on the
     * bus traffic, the code will spin reading the lock until the lock becomes
     * free, then try another test and set to acquire the lock.
     */

    asm volatile ( "tbitb $0, 0(%0)" : : "r" (mutex) );
    asm volatile ( "bfs .-4" );				/* go back 4 bytes, to the "tbit" instruction */
    asm volatile ( "sbitib $0, 0(%0)" : : "r" (mutex) );
    asm volatile ( "bfs .-11" );			/* go back 11 bytes, to the "tbit" instruction */

#endif
	
} /* uAcquireLock */

static inline int uTryAcquireLock( uLock *mutex ) {

    /*
     * This makes one try to obtain a lock and
     * returns:
     *   1 => lock was obtained
     *   0 => lock was not obtained
     */

#ifdef __U_MULTI__
    
    int value;

    asm volatile ( "sbitib $0, 0(%1); bfs .+6; movqd 1, %0; br .+4; movqd 0, %0" : "=r" (value) : "r" (mutex) );

    return value;

#endif

} /* uTryAcquireLock */

static inline void uReleaseLock( uLock *mutex ) {
    
    /*
     * This function causes a task to release a lock.
     */
    
#ifdef __U_MULTI__
    *mutex = U_UNLOCKED;				/* release the lock */
#endif
    
} /* uReleaseLock */
