/*                               -*- Mode: C -*- 
 *
 * uSystem Version 4.4.3, Copyright (C) Hamish Macdonald 1990
 *
 * uSysExcepts.h -- uSystem exception definitions.
 *
 * Author          : Hamish Macdonald
 * Created On      : Thu Oct 11 15:18:36 1990
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Sun Feb 21 09:49:28 1993
 * Update Count    : 71
 * Status          : Might work!
 */

#ifndef __U_SYSEXCEPTSH__
#define __U_SYSEXCEPTSH__

/*
 * Top level uSystem exception
 */

extern uException uSystemEx;

/*
 * All uSystem predefined exception messages start with the following structure:
 *   char *uSystemExMsg;
 *       This is a pointer to a character strings that is a brief summary of why the exception
 *       was raised.  This message can always be printed out by the exception handler.
 *
 * This may be followed by other data depending on the exception.  The exception
 * hierarchy forms an inheritance hierarchy.  The message for an exception must contain
 * the message of its parent as a prefix.
 *
 */

typedef char *uSystemExMsg;

/*
 * uSystem uKernel exceptions.
 */

extern uException   uKernelEx;
extern uException     uDataCommEx;
extern uException       uDataCopyEx;
extern uException         uSendMsgTooLongEx;
extern uException         uReplyAreaTooShortEx;
extern uException         uForwardMsgTooLongEx;
extern uException         uAbsorbAreaTooShortEx;
extern uException         uSuspendMsgTooLongEx;
extern uException         uResumeMsgTooLongEx;
extern uException       uBadCoroutineEx;
extern uException       uSyncFailEx;
extern uException         uNotReplyBlockedEx;
extern uException         uInvalidForwardEx;
extern uException     uCreationEx;
extern uException       uCreateClusterEx;
extern uException       uEmitEx;
extern uException       uCocallEx;
extern uException       uCreateProcessorEx;
extern uException     uActiveTasksEx;

extern uException     uBadInterEx;

/*
 * Message definitions for uSystem uKernel exceptions.
 */
typedef uSystemExMsg uKernelExMsg, uActiveTasksExMsg, uCreationExMsg;

typedef struct {
    uSystemExMsg msg;
    void         *sbuf;
    int          slen;
    void         *rbuf;
    int          rlen;
} uDataCommExMsg, uDataCopyExMsg;
    
typedef struct {
    uDataCopyExMsg base;
    uTask          sender;
    uTask          receiver;
} uSendMsgTooLongExMsg;

typedef struct {
    uDataCopyExMsg base;
    uTask          replier;
    uTask          sender;
} uReplyAreaTooShortExMsg;

typedef struct {
    uDataCopyExMsg base;
    uTask          sender;
    uTask          forwarder;
    uTask          receiver;
} uForwardMsgTooLongExMsg;

typedef struct {
    uDataCopyExMsg base;
    uTask          dier;
    uTask          absorber;
} uAbsorbAreaTooShortExMsg;

typedef struct {
    uDataCopyExMsg base;
    uCoroutine     restarter;                          /* coroutine id of restarting coroutine */
    uCoroutine     resumed;			       /* coroutine id of resumed coroutine */
} uSuspendMsgTooLongExMsg, uResumeMsgTooLongExMsg;
    
typedef struct {
    uDataCommExMsg base;
    uCoroutine     restarter;	/* coroutine id of restarting coroutine */
    uTask          thistask;	/* non-owner task that attempted restart */
} uBadCoroutineExMsg;

typedef struct {
    uDataCommExMsg base;
    uTask          sender;
    uTask          receiver;
} uSyncFailExMsg, uNotReplyBlockedExMsg;

typedef struct {
    uSyncFailExMsg base;
    uTask          forwarder;
} uInvalidForwardExMsg;

typedef struct {
    uCreationExMsg msg;
    uClusterVars cv;
} uCreateClusterExMsg;

typedef struct {
    uCreationExMsg  msg;
    int             num_proc;
} uCreateProcessorExMsg;

typedef struct {
    uCreationExMsg msg;
    uCluster       cluster;
    long           space;
    void           *begin;
    long           arglen;
} uEmitExMsg;

typedef struct {
    uCreationExMsg msg;
    void           *rbuf;
    int            rlen;
    long           space;
    void           *begin;
    long           arglen;
} uCocallExMsg;

typedef struct {
    uSystemExMsg     msg;
    const char       *iname;
    const uInterName *iptr;
} uBadInterExMsg;
    
/*
 * uSystem Memory allocation exceptions
 */

extern uException   uOutOfMemoryEx;
extern uException     uNoExtendEx;

/*
 * uSystem memory exception message definitions.
 */

typedef struct {
    uSystemExMsg msg;
    int          size;
} uOutOfMemoryExMsg;

typedef struct {
    uOutOfMemoryExMsg base;
    void              *addr;
} uNoExtendExMsg;

/*
 * uSystem I/O system exceptions
 */

extern uException   uIOEx;
extern uException     uEofEx;
extern uException     uIOErrorEx;
extern uException       uSocketErrorEx;
extern uException         uCreateSockEx;
extern uException         uNotSockEx;
extern uException         uNoBufsEx;
extern uException         uBadSockAddressEx;
extern uException           uConnFailedEx;
extern uException       uFileStreamEx;
extern uException         uOpenEx;
extern uException           uOpenIOFailedEx;
extern uException           uOpenNoSpaceEx;
extern uException           uBadPathEx;
extern uException           uNoPermsEx;
extern uException           uNoFilesEx;
extern uException           uBadParmEx;
extern uException         uReadWriteEx;
extern uException           uBadFileEx;
extern uException           uIOFailedEx;
extern uException           uNoSpaceEx;

/*
 * There are no extra field definitions for uIOEx, and uEofEx,
 * since the message data for them is the same as
 * that for their parent in the exception hierarchy.
 */
typedef struct {
    uSystemExMsg msg;
} uIOExMsg;

typedef struct {
    uSystemExMsg msg;
} uEofExMsg;

/*
 * This structure can be used for any exception in the uIOErrorEx subtree.
 * uFileStreamEx message has no extra fields that uIOErrorExMsg doesn't have.
 */

typedef struct {
    uSystemExMsg msg;
    int errno;					  /* Unix errno */
} uIOErrorExMsg, uFileStreamExMsg;

/*
 * Socket exception message definitions
 */
typedef uIOErrorExMsg uSocketErrorExMsg;
typedef struct {
    uSocketErrorExMsg base;
    int               af;
    int               type;
    int               protocol;
} uCreateSockExMsg;
    
typedef uSocketErrorExMsg uNotSockExMsg, uNoBufsExMsg;

typedef struct {
    uSocketErrorExMsg base;
    void              *name;
    int               namelen;
} uBadSockAddressExMsg, uConnFailedExMsg;

/*
 * uOpenEx and its sub-exceptions have 5 extra fields.
 */
typedef struct {
    uFileStreamExMsg base;			  /* uFileStreamEx fields */
    char             *path;	                  /* path of file to be opened */
    char             *perms;	                  /* permissions for opening of formatted file (uStream) */
    int              flags;			  /* flags for opening of unformatted file (uFile) */
    int              mode;			  /* mode for opening of unformatted file (uFile) */
} uOpenExMsg, uOpenIOFailedExMsg, uOpenNoSpaceExMsg, uBadPathExMsg, uNoPermsExMsg,
    uNoFilesExMsg, uBadParmExMsg;

/*
 * uReadWriteEx and its sub-exceptions have no extra fields.
 */
typedef uFileStreamExMsg uReadWriteExMsg, uIOFailedExMsg, uNoSpaceExMsg, uBadFileExMsg;

#endif
