/*                               -*- Mode: C -*- 
 *
 * uSystem Version 4.4.3, Copyright (C) Hamish Macdonald 1990
 * 
 * uExcept.h -- uSystem exception handling declarations.
 * 
 * Author          : Hamish Macdonald
 * Created On      : Mon Jun 11 15:02:17 1990
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Sun Sep  4 21:34:38 1994
 * Update Count    : 179
 */

#ifndef __U_EXCEPTH__
#define __U_EXCEPTH__

extern uException uAny;					/* The "catch-all" exception pointer */

/*
 * Initialization macro for the uException type.
 *
 * uExceptions _must_ be initialized when declared.
 *
 * uExceptions are constant, and cannot be changed after their declaration.
 *
 */

/*
 * Constructor for exceptions.
 */

#define U_EXCEPTION( except ) { (const struct _uException*)except }

/*
 * The exception block descriptor is a part of
 * the uStackBlock, which is defined in uKernel.h
 */ 
/*
 * Definition of macros for setting up exception handlers on
 * a tasks stack.
 */

#define uExcept                               \
    {                                         \
	uStackBlockD _uExcpBlock;             \
	uExceptSave( &_uExcpBlock );          \
	if ( !_setjmp( _uExcpBlock.u.uEPart.context ) ) {

#define uHandlers                        \
            uExceptEnd( &_uExcpBlock );  \
	} else {                         \
            if( U_FALSE ) {

#define uWhen(_obj,_excp,_dataptr)               \
		uExceptEnd( &_uExcpBlock );      \
	    } } else if( uExceptCheck( &_uExcpBlock, (_obj), (_excp), (_dataptr) ) ) { {

#define uEndExcept                                                                   \
		uExceptEnd( &_uExcpBlock );                                          \
            } else {                                                                 \
		_uExcpBlock.u.uEPart.reraise = U_TRUE;                               \
                uRaise( _uExcpBlock.u.uEPart.object, _uExcpBlock.u.uEPart.exception, \
                        _uExcpBlock.u.uEPart.data, _uExcpBlock.u.uEPart.len );       \
	    }                                                                        \
        }                                                                            \
    }

/*
 * This macro allows the user to access the raised exception within an exception handler.
 * This is most useful in an exception handler catching any exception (uAny).
 */
#define uRaisedException() (_uExcpBlock.u.uEPart.exception)
/*
 * This macro allows the user to access the object on which the exception was raised within an exception handler.
 */
#define uRaisedData() (_uExcpBlock.u.uEPart.object)
/*
 * This macro allows the user to access the length of the exception instance.
 */
#define uRaisedLength() (_uExcpBlock.u.uEPart.len)

extern volatile void uRaise( void*, uException*, void*, int );

/*
 * These are support routines, not intended to be directly called by user tasks
 */
extern void uExceptSave( uStackBlock );
extern void uExceptEnd( uStackBlock );
extern int uExceptCheck( uStackBlock, void*, uException*, void* );
extern int uBadException( uException*, void* );

#endif __U_EXCEPTH__
