/*                              -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uUnix.i -- declarations of UNIX system calls.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Mon Aug 27 14:42:21 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Jan  4 23:24:58 1994
 * Update Count     : 204
 */ 

#ifndef __U_UNIXH__
#define __U_UNIXH__

/*
 * The GNU C compiler seems to define __STDC__ in cpp so it is always on
 * whether a vendor supports ANSI prototype definitions or not.
 * Therefore, it is necessary to determine which vendors/OS *really* have
 * prototype definitions.
 */

#if defined( __apollo__ ) || defined( ___AIX__ ) || defined( __hpux__ ) || defined( __ultrix__ ) || defined( __sgi__ ) || defined( __svr4__ )
#define __U_STDC__
#endif

#ifdef __U_STDC__					/* ANSI HEADER FILES AVAILABLE */
#include <stdlib.h>					/* Many useful definitions */
#else
/* fake stdlib.h */
extern void *malloc( unsigned ); 
extern void *realloc( void *, unsigned );
extern void free( void * ); 
extern void abort( void ); 
extern void exit( int ); 
extern char *getenv( const char * );
extern int system( const char * );
#endif /* __U_STDC__ */

#ifdef __U_STDC__					/* ANSI HEADER FILES AVAILABLE */
#include <stdio.h>
#else
/* fake stdio.h */
#include <stdio.h>					/* types and defines */
extern FILE *fopen( const char *, const char * ); 
extern char *fgets( char *, int, FILE * ); 
extern char *gets( char * ); 
extern int fclose( FILE * ); 
extern int fflush( FILE * ); 
extern int fgetc( FILE * ); 
extern int printf( const char *, ... );
extern int fprintf( FILE *, const char *, ... );
extern char *sprintf();					/* problems with () and ... */
extern int vprintf( const char *, ...);
extern int vfprintf( FILE *, const char *, ... );
extern char *vsprintf( char *, const char *, ... );
extern int fputc( int, FILE * ); 
extern int puts( const char * ); 
extern int fputs( const char *, FILE * ); 
extern int scanf( const char *, ... );
extern int fscanf( FILE *, const char *, ... );
extern int sscanf( const char *, const char *, ... );
extern int ungetc( int, FILE * ); 
extern int fread( char *, int, int, FILE * );
extern int fwrite( const char *, int, int, FILE * );
extern void rewind( FILE * );
extern int fseek( FILE *, long, int );
extern FILE * freopen( const char *, const char *, FILE * ); 
extern int _filbuf( FILE * ); 
extern int _flsbuf( unsigned, FILE * ); 
#ifndef clearerr					/* this is a macro on some machines, a function on others */
extern int clearerr( FILE * );
#endif /* clearerr */
#endif /* __U_STDC__ */

/* These look like they should be in ANSI C, but are not standard */

extern int _doprnt( char *, void *, FILE * );
extern int _doscan( FILE *, char *, void * );
 
/* Error number stuff */

#include <errno.h>					/* error number definitions */
extern int errno;					/* missing from <errno.h> for some vendors  */

#ifndef max
#define max( a, b ) ( ( a ) > ( b ) ? ( a ) : ( b ) )
#endif /* max */

/* Unix stuff */

#include <sys/types.h>
#include <sys/stat.h>

#if !defined( __hpux__ ) && !defined( __svr4__ )
extern int kill( int, int ); 
#endif
extern int killpg( int, int ); 
extern int fsync( int ); 
#ifdef __U_STDC__					/* ANSI HEADER FILES AVAILABLE */
#include <unistd.h>
#include <fcntl.h>
#ifdef sgi
#include <sys/prctl.h>
#endif
#if defined( ___AIX__ )
#include <sys/select.h>
#elif defined( __hpux__ )
#include <time.h>    
#elif !defined( __svr4__ )
extern int select( int, fd_set *, fd_set *, fd_set *, void * );
#endif /* ___AIX__  */
#else
#ifndef getpid						/* this is a macro on some machines, a function on others */
extern int getpid( void ); 
#endif /* getpid */
extern int getpgrp( int ); 
extern void setpgrp( int, int ); 
extern int fork( void ); 
extern int wait( void * );
extern int open( const char *, int, int ); 
extern int close( int );
extern int flush( int );
extern int read( int, char *, int ); 
extern int write( int, const char *, int ); 
extern off_t lseek( int, off_t, int ); 
extern int fcntl();					/* problems with () and ... */
extern int unlink( const char * );
extern int fstat( int, struct stat * );
extern int select( int, fd_set *, fd_set *, fd_set *, void * );
#endif /* __U_STDC__ */

/* socket management */

#include <sys/socket.h>					/* types and defines */
#if !defined( __U_STDC__ ) || defined( ___AIX__ ) || defined( __ultrix__ )
extern int accept( int, void *, int * );
extern int bind( int, void *, int );
extern int connect( int, void *, int );
extern int getsockname( int, void *, int * );
extern int listen( int, int );
extern int socket( int, int, int );
extern int recv( int, void *, int, int );
extern int recvfrom( int, void *, int, int, void *, int * );
extern int recvmsg( int, void *, int );
extern int send( int, void *, int, int );
extern int sendto( int, void *, int, int, void *, int );
extern int sendmsg( int, void *, int );
#endif /* __U_STDC__ */


/* miscellaneous non-ANSI library routines */

#include <string.h>
#if !defined( __svr4__ )
#include <strings.h>
#endif
#if !defined( __U_STDC__ ) || defined( ___AIX__ ) || defined( __ultrix__ ) || defined( __sgi__ ) || defined( __svr4__ )
extern void bcopy( const void *, void *, unsigned );
extern void bzero( void *, unsigned );
extern char *index( const char *, int );
#endif

/* BSD signal management */

#if !defined( __U_STDC__ ) || defined( ___AIX__ ) || defined( __ultrix__ ) || defined( __svr4__ )
extern int setitimer();
extern int sigblock( int );
extern int sigsetmask( int );
extern int sigpause( int );
#endif

/* shared memory management */

#ifdef __sequent__
extern void *shmalloc( unsigned ); 
extern void shfree( void * ); 
extern void *shrealloc( void *, unsigned ); 
#endif

#ifdef __encore__
extern int share_malloc_init( int );
extern void *share_malloc( unsigned );
extern void *share_free( void * );
#endif

extern void _exit(int);

#endif /* __U_UNIXH__ */
