/*                               -*- Mode: C -*- 
 *				 
 * uSystem Version 4.4.3, Copyright (C) Hamish Macdonald 1991
 *
 * mcrt0.c -- Monitor startup routines for the uSystem on a Sequent Symmetry,
 *		Sequent Balance, and Encore MultiMax
 *
 * Author          : Hamish Macdonald
 * Created On      : Mon Aug 19 21:15:09 1991
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Tue Jan 26 16:14:25 1993
 * Update Count    : 61
 */

/*
 * This definition controls whether sbrk or malloc
 * is used to allocate the profiling buffer.
 */
#define USE_SBRK

char **environ = (char **)0;
static char *argv0 asm ("argv0") = (char *)0;
    
#ifdef sequent
extern void start(void) asm ("start");
static void start1();
    
void start( void ) {
    start1();
} /* start */
    
static void start1( int bogus_fp, int argc, char *xargv ) {
    void _ppinit( int, char** );
    void monstartup( void*, void* );
    int main( int, char**, char ** );
    void exit( int );
    extern unsigned char etext;
    char **argv;
    
    argv = &xargv;
    environ = argv + argc + 1;
    argv0 = argv[0];
    
    _ppinit( argc, argv );
    
    monstartup( &start1, &etext );
    
    exit( main( argc, argv, environ ) );
#ifdef i386
    asm volatile ( "hlt" );
#else
    asm volatile ( "bpt" );
#endif
} /* start1 */
#endif

#if defined(ns32000) && !defined(sequent) /* Encore MultiMAX */
extern void sigentry() asm ("sigentry" );
static int sv[] asm ("sv") = { (int)&sigentry, 0, 0 };

#if 0
extern void start(void) asm ("start");
#endif
static void start1();

asm( ".globl    start" );
asm( ".text" );
asm( "start:" );
asm( "adjspb    $4" );
asm( "br        _start1" );
asm( ".org      0x20" );
asm( ".double   p_glbl,0,0xf00000,0");
asm( ".org      0x30" );

static void start1( int argc, char *argv0p ) {
    void monstartup( void*, void* );
    int main( int, char**, char ** );
    void exit( int );
    extern void sigvec( int, int*, int* );
    extern unsigned char etext;
    char **argv;

    argv = &argv0p;
    environ = argv + argc + 1;
    argv0 = argv[0];

    sigvec(0x400, &sv[0], (int *)0 );

    monstartup( &start1, &etext );

    exit( main( argc, argv, environ ) );
    asm volatile ( "addr @0x1,r0" );
    asm volatile ( "svc" );
    asm volatile ( ".comm       p_glbl,1" );
} /* start1 */

#endif

void exit( int code ) {
    extern void monitor( char*, char*, char*, int, int );
    void _cleanup( void );
    void _exit( int );
    
    monitor( 0, 0, 0, 0, 0 );
    _cleanup();
    _exit( code );
} /* exit */

#define MINCOUNTERS	50
#define COUNTERDENSITY	5
#define PROFFRACTION	2


struct bufhead {
    int *lowpc;
    int *highpc;
    int numcounters;
};

struct counter {
    int *pc;
    long calls;
} *counterptr;

static int counters = 0;
static int profiling = 3;
static char *prof_buf;
static int prof_bufsiz;
static int prof_scale;
static char *prof_lowpc;

int totalcounters;

static char nospace[] = "No space for profiling buffer\n";

void monstartup( char *lowpc, char *highpc ) {
    int buffersize;
    char *buffer;
    int countsize;
#ifdef USE_SBRK
    extern int sbrk( int );
#else
    extern void *malloc( unsigned int );
#endif
    extern void monitor( char*, char*, char*, int, int );
    extern int write( int, char*, int );
    
    countsize = ( highpc - lowpc ) * COUNTERDENSITY / 100;
    if ( countsize < MINCOUNTERS ) {
	countsize = MINCOUNTERS;
    } /* if */
    buffersize = sizeof(struct bufhead) + countsize * sizeof(*counterptr)
	+ ( highpc - lowpc + PROFFRACTION - 1 ) / PROFFRACTION;
    buffersize = ( buffersize + 1 ) & ~1;		/* even number */
#ifdef USE_SBRK
    buffer = (char *)sbrk( buffersize );
    if ( buffer == (char*)-1 ) {
#else
    buffer = malloc( buffersize );
    if ( buffer == (char*)0 ) {
#endif
	write( 2, nospace, sizeof(nospace) - 1 );
	return;
    } /* if */
    monitor( lowpc, highpc, buffer, buffersize, countsize );
} /* monstartup */

extern void mcount( void ) asm ( "mcount" );

static char overflow[] = "mcount: counter overflow\n";

void mcount( void ) {
    long **pcounter;
    int *returnpc;
    int write( int, char *, int );
    
    /*
     * find the return address for mcount, and address of counter pointer
     */
#ifdef i386
    asm volatile ( "movl 4(%%ebp), %0" : "=g" (returnpc) );
    asm volatile ( "movl %%eax, %0" : "=g" (pcounter) );
#endif
#ifdef ns32000
    asm volatile ( "movd 4(fp), %0" : "=g" (returnpc) );
    asm volatile ( "movd r0, %0" : "=g" (pcounter) );
#endif
    
    /*
     * simple barrier to ensure no recursive calls not foolproof...
     * profiling has to be a per-process variable
     */
    if ( profiling ) {
	return;
    } /* if */
    
    profiling += 1;
    
    if ( *pcounter == 0 ) {				/* If counter not allocated, allocate one */
	if ( counters == totalcounters ) {		/* check that a counter is available */
	    write( 2, overflow, sizeof(overflow)-1 );
	    return;
	} /* if */
	counterptr->pc = returnpc;
	*pcounter = &counterptr->calls;
	counterptr += 1;
	counters += 1;
    } /* if */
    
    (**pcounter) += 1;					/* increment the counter once per call */

    profiling -= 1;					/* out of profiling */
} /* mcount */

void monitor( char *lowpc, char *highpc, char *buf, int bufsiz, int numcounters ) {
    int f;
    int counterspace, scale;
    struct bufhead *header;
    static int profsiz;
    static char *profbuf;
    extern void moncontrol( int );
    
    if ( lowpc == 0 ) {
	extern int creat( char*, int );
	extern int write( int, char*, int );
	extern void close( int );
	extern char *getenv( char* );
	char *profdir;
	
	moncontrol( 0 );
	
	profdir = getenv( "PROFDIR" );
	
	if ( !profdir ) {				/* No PROFDIR variable implies use file mon.out */
	    f = creat( "mon.out", 0666 );
	} else if ( *profdir == '\0' ) {		/* empty PROFDIR variable implies no profiling */
	    f = -1;
	} else {
	    char *monfile;
	    void *malloc( unsigned int );
	    /* int strlen( char * ); */
	    void sprintf( char*, char*, ... );
	    int getpid( void );
	    
	    if ( !argv0 || strlen( argv0 ) == 0 ) {
		argv0 = "a.out";
	    } else {
		char *p;
		
		p = argv0 + strlen( argv0 );
		
		while( *p != '/' && p != argv0 ) {
		    p -= 1;
		} /* while */
		
		if( *p == '/' ) {
		    argv0 = p + 1;
		} /* if */
	    } /* if */
	    
	    monfile = malloc( strlen( profdir ) + strlen( argv0 ) + 20 );
	    if ( monfile ) {
		sprintf( monfile, "%s/%d.%s", profdir, getpid(), argv0 );
		f = creat( monfile, 0666 );
	    } else {					/* no storage, turn off profiling */
		f = -1;
	    } /* if */
	} /* if */
	
	write( f, profbuf, profsiz );
	close( f );
	return;
    } /* if */
    
    profbuf = buf;
    profsiz = bufsiz;
    header = (struct bufhead *)buf;
    header->lowpc = (int *)lowpc;
    header->highpc = (int *)highpc;
    header->numcounters = numcounters;
    totalcounters = numcounters;
    counterptr = (struct counter *)( buf + sizeof(struct bufhead) );
    counterspace = sizeof(struct bufhead) + totalcounters * sizeof(struct counter);
    buf += counterspace;
    bufsiz -= counterspace;
    if ( bufsiz <= 0) {
	return;
    } /* if */
    
    scale = ( highpc - lowpc );
    if( bufsiz < scale ) {
	scale = ( (float) bufsiz / scale ) * 65536;
    } else {
	scale = 65536;
    } /* if */
    prof_scale = scale;
    prof_buf = buf;
    prof_bufsiz = bufsiz;
    prof_lowpc = lowpc;
    moncontrol( 1 );
} /* monitor */

void monclear( void ) {
    /*
     * This function clears out the counters in the profiling buffer.  It only clears
     * the counters, not the pc's associated with the counters.
     */
    
    struct counter *cp = counterptr - 1;
    int nc = counters;
    
    while( nc > 0 ) {
	cp->calls = 0;
	cp -= 1;
	nc -= 1;
    } /* while */
} /* monclear */

void moncontrol( int mode ) {
    /*
     * Control profiling profiling is what mcount checks to see if
     * all the data structures are ready.
     */
    
    extern profil( char *, int, char *, int );
    
    if ( mode ) {
	profil( prof_buf, prof_bufsiz, prof_lowpc, prof_scale ); /* start */
	profiling = 0;
    } else {
	profil( (char *)0, 0, 0, 0 );			/* stop */
	profiling = 3;
    } /* if */
} /* moncontrol */

/* Local Variables: */
/* compile-command: "gcc -O -c -Wall mcrt0.c" */
/* End: */
