#include <uSystem.h>

/*
  Correct output:
  100000.000000
  100000.000000
  100002.000000
  100000.000000
  100000.000000
  100002.000000
  100002.000000
  100000.000000
  100008.000000
  100000.000000
  */

void tester( int inc ) {
    register double i;					/* make sure to use a register to check */
    double r;						/* for changes across context switches */

    uSaveFloat();					/* save the floating point registers during a context switch */
    for ( i = 0.0; i < 100000.0; i += inc ) {
	uYield();
    } /* for */
    r = i;						/* can't take the address of a register varible */
    uDie( &r, sizeof(r) );
} /* tester */

#define NoOfTesters 10

void uMain( int argc, char *argv[] ) {
    uTask testers[NoOfTesters];
    int i;
    double r;

    for ( i = 0; i < NoOfTesters; i += 1 ) {
	testers[i] = uEmit( tester, i + 1 );
	uYield();
    } /* for */

    for ( i = 0; i < NoOfTesters; i += 1 ) {
	uAbsorb( testers[i], &r, sizeof(r) );
	uPrintf( "%f\n", r );
    } /* for */

    uPrintf( "successful completion\n" );
}
    
/* Local Variables: */
/* compile-command: "concc -work -O Float.c" */
/* End: */
