/* Copyright (c) 1989  P. A. Buhr */

/*
  First Reader/Writer Problem
  
  Method: Allow multiple readers but only one writer for a particular
     resource. Readers have priority over writers.
  Problem: As long as readers keep coming along, no writer can get in,
     hence writers could starve.
  */

#include <uSystem.h>
#include <uDelay.h>

long random( void );

/* shared variables for process communication */

uSemaphore lock = U_SEMAPHORE( 1 );
int rdcnt = 0;
uSemaphore wrt = U_SEMAPHORE( 1 );

void Reader( void ) {
    uP( &lock );
    rdcnt += 1;
    if ( rdcnt == 1 ) {					/* 1st reader ? */
	uP( &wrt );					/* wait for writer to finish */
    } /* if */
    uV( &lock );

    uPrintf( "Reader:%x, simultaneous readers:%d\n", uThisTask( ), rdcnt );
    uDelay( 2 );					/* pretend to read */

    uP( &lock );
    rdcnt -= 1;
    if ( rdcnt == 0 ) {					/* all readers finished ? */
	uV( &wrt );					/* signal writers */
    } /* if */
    uV( &lock );

    uDie( NULL, 0 );
} /* Reader */

void Writer( void ) {
    uP( &wrt );

    uPrintf( "Writer:%x\n", uThisTask( ) );
    uDelay( 5 );					/* pretend to write */

    uV( &wrt );

    uDie( NULL, 0 );
} /* Writer */

#define NoOfRW 20

void uMain( ) {
    uTask rw[NoOfRW];
    int i;
    
    for ( i = 0; i < NoOfRW; i += 1 ) {
	if ( random() % 10 < 7 ) {			/* 70 % chance of creating a reader */
	    rw[i] = uEmit( Reader );			/* start reader */
	} else {
	    rw[i] = uEmit( Writer );			/* start writer */
	} /* if */
	uDelay( 5 );
    } /* for */
    
    for ( i = 0; i < NoOfRW; i += 1 ) {
	uAbsorb( rw[i], NULL, 0 );			/* wait for completion of readers */
    } /* for */

    uPrintf( "successful execution\n" );
} /* uMain */
