/* Producer and Consumer Problem using P/V with a Bounded Buffer */

#include <uSystem.h>
#define QueueSize 10

extern long int random( void );

struct shrqueue {
    int front, back;					/* position of front and back of queue */
    uSemaphore full, empty;				/* synchronize for full and empty buffer */
    int queue[QueueSize];				/* queue of integers */
}; /* shrqueue */

void Producer( struct shrqueue *q, int NoOfItems ) {
    int i, product;

    uPrintf( "Producer will produce %d items for the consumer\n", NoOfItems );
    for ( i = 1; i <= NoOfItems; i += 1 ) {		/* produce a number of items */
        product = random() % 100 + 1;			/* generate random product */
        uPrintf( " Producer: %2d\n", product );
        uP( &(q->empty) );				/* wait if queue is full */
        q->queue[q->back] = product;			/* insert element in queue */
        q->back = ( q->back + 1 ) % QueueSize;		/* increment back index */
        uV( &(q->full) );				/* signal consumer */
    } /* for */
    product = -1;					/* terminal value */
    uP( &(q->empty) );					/* wait if queue is full */
    q->queue[q->back] = product;			/* insert element in queue */
    q->back = ( q->back + 1 ) % QueueSize;		/* increment back index */
    uV( &(q->full) );					/* signal consumer */
    uDie( NULL, 0 );
} /* Producer */

void Consumer( struct shrqueue *q ) {
    int product;

    for ( ;; ) {
        uP( &(q->full) );				/* wait for producer */
        product = q->queue[q->front];			/* remove element from queue */
        q->front = ( q->front + 1 ) % QueueSize;	/* increment the front index */
        uV( &(q->empty) );				/* signal empty queue space */
      if ( product < 0 ) break;
        uPrintf( "Consumer : %2d\n", product );
    } /* for */
    uDie( NULL, 0 );
} /* Consumer */

void uMain( ) {
    struct shrqueue queue = { 0, 0, U_SEMAPHORE( 0 ), U_SEMAPHORE( QueueSize ) };

    uTask Prod = uEmit( Producer, &queue, 10 );		/* create producer */
    uTask Cons = uEmit( Consumer, &queue );		/* create consumer */

    uAbsorb( Prod, NULL, 0 );				/* wait for completion */
    uAbsorb( Cons, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* uMain */
