/* Monitor Program Example 7a */
/* Copyright (c) 1986 P. A. Buhr */

/*
  Readers and Writers Problem
  
  A single resource is modified by a number of writer processes and
  accessed by a number of reader processes. Any number of reader process
  may simultaneously access the resource, but only one process, a writer,
  can be accessing the resource during a modification. Note that when a
  writer process has exclusive access to the resource, it is not precluded
  from first reading the resource before changing it; hence a writer may
  also be a reader, but the converse is not true.
  */

/*
  This monitor ensures that readers and writers are serviced in a FIFO
  manner. There is no starvation and no stale reads.
  */

#include <uMonitor.h>

uMonitor ( PriorityBlocking ) {
#   define READER 0
#   define WRITER 1
    
    int ReadCount = 0, WriteUsage = 0;
    uCondition ReaderAndWriter = U_CONDITION, FrontWriter = U_CONDITION;
    
    uEntry void StartRead( ) {
	if ( WriteUsage || uCondLength( &ReaderAndWriter ) != 0 ) {
	    uWait ReaderAndWriter;
	} /* if */
	ReadCount += 1;
	uSignal ReaderAndWriter;
    } /* StartRead */
    
    uEntry void EndRead( ) {
	ReadCount -= 1;
	if ( ReadCount == 0 ) {				/* last reader of this group ? */
	    if ( uCondLength( &FrontWriter ) != 0 ) {
		uSignal FrontWriter;
	    } else {
		uSignal ReaderAndWriter;
	    } /* if */
	} /* if */
    } /* EndRead */
    
    uEntry void StartWrite( ) {
	if ( WriteUsage || ReadCount != 0 ) {
	    uWait ReaderAndWriter;
	    if ( ReadCount != 0 ) {			/* check if must wait on other Condition */
		uWait FrontWriter;
	    } /* if */
	} /* if */
	WriteUsage = 1;
    } /* StartWrite */
    
    uEntry void EndWrite( ) {
	WriteUsage = 0;
	uSignal ReaderAndWriter;
    } /* EndWrite */
}

#include "RWDriver.c"
