/* Copyright (c) 1989 P. A. Buhr */

#include <uMonitor.h>

typedef int EventCounter;
typedef int Sequencer;

typedef struct {
    Sequencer Seq;
    EventCounter Event;
} SeqEvent;

uMonitor {
    uEntry int Ticket( SeqEvent *SE ) {
	SE->Seq += 1;
	return( SE->Seq );
    } /* Ticket */
    
    uEntry int readSequencer( SeqEvent *SE ) {
	return( SE->Seq );
    } /* readSequencer */
}

uMonitor ( PriorityAutomaticSignal ) {
    uEntry EventCounter readEvent( SeqEvent *SE ) {
	return( SE->Event );
    } /* readEvent */
    
    uEntry Advance( SeqEvent *SE ) {
	SE->Event += 1;
    } /* Advance */
    
    uEntry Await( SeqEvent *SE, int v ) {
	uWaitUntil SE->Event >= v ;
    } /* Await */
}

#define QueueSize 10

struct shrqueue {
    int front, back;					/* position of front and back of queue */
    SeqEvent in, out;					/* sequencers */
    int queue[QueueSize];				/* queue of integers */
}; /* shrqueue */

void Producer( int NoOfItems, struct shrqueue *q ) {
    int item, i;
    
    for ( i = 1; i <= NoOfItems; i += 1 ) {
	item = random() % 100;				/* produce an item */

	Await( &(q->out), Ticket( &(q->out) ) );
	uPrintf( " Producer:%x, value:%2d\n", uThisTask(), item );
	q->queue[q->back] = item;			/* insert element in queue */
	q->back = ( q->back + 1 ) % QueueSize;
	Advance( &(q->in) );
    } /* for */
    uDie( NULL, 0 );
} /* Producer */

void Consumer( int NoOfItems, struct shrqueue *q ) {
    int i, item;
    
    for ( i = 1; i <= NoOfItems; i += 1 ) {
	Await( &(q->in), Ticket( &(q->in) ) );
	item = q->queue[q->front];			/* remove element from queue */
	q->front = ( q->front + 1 ) % QueueSize;
	Advance( &(q->out) );
	uPrintf( "Consumer :%x, value:%2d\n", uThisTask(), item );
    } /* for */
    uDie( NULL, 0 );
} /* Consumer */

#define Items 100

void uMain() {
    uTask Cons, Prod1, Prod2;
    struct shrqueue buffer = { 0,0, {0,0}, {0,QueueSize} }; /* bounded buffer */
    
    Cons = uEmit( Consumer, Items * 2, &buffer );
    Prod1 = uEmit( Producer, Items, &buffer );
    Prod2 = uEmit( Producer, Items, &buffer );
    
    uAbsorb( Cons, NULL, 0 );
    uAbsorb( Prod1, NULL, 0 );
    uAbsorb( Prod2, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* uMain */
