/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * ServerUNIX.c -- Server for UNIX socket test
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Mar  2 13:44:11 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Mar 28 10:24:56 1993
 * Update Count     : 7
 */

#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>

void Acceptor( uFile sd ) {
    uFile fd;
    int c;						/* used to store byte read from socket */

    fd = uAccept( sd, NULL, NULL );			/* accept a connection */
    uEmit( Acceptor, sd );				/* create an acceptor for the next connection */

    for ( ;; ) {
        uRead( fd, &c, sizeof( c ) );			/* read byte from socket */
        uWrite( fd, &c, sizeof( c ) );			/* write byte to socket */
      if ( c == EOF ) break;
    } /* for */
    uClose( fd );					/* close the connection */
    uDieAlone();					/* terminate through reaper */
} /* Acceptor */

void uMain( int argc, char *argv[] ) {
    uFile sd;
    struct sockaddr_un sockinfo;
    uSemaphore stop = U_SEMAPHORE( 0 );

    switch ( argc ) {
      case 2:
        break;
      default:
        uAbort( "usage: %s socket-name\n", argv[0] );
        break;
    } /* switch */

    sd = uSocket( AF_UNIX, SOCK_STREAM, 0 );

    sockinfo.sun_family = AF_UNIX;
    strcpy( sockinfo.sun_path, argv[1] );
    uBind( sd, &sockinfo, sizeof(sockinfo) );

    uListen( sd, 5 );
    uEmit( Acceptor, sd );				/* start the first acceptor */
    uP( &stop );					/* currently, this does not stop  */
    uClose( sd );					/* close socket */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -work -nounixrc -O -o Server ServerUNIX.c" */
/* End: */
