/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * ServerINET.c -- Server for INET socket test
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Mar  2 08:58:56 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Jan  4 18:33:41 1994
 * Update Count     : 17
 */

#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>

void Acceptor( uFile sd ) {
    uFile fd;
    int c;						/* used to store byte read from socket */

    fd = uAccept( sd, NULL, NULL );			/* accept a connection */
    uEmit( Acceptor, sd );				/* create an acceptor for the next connection */

    for ( ;; ) {
        uRead( fd, &c, sizeof( c ) );			/* read byte from socket */
        uWrite( fd, &c, sizeof( c ) );			/* write byte to socket */
      if ( c == EOF ) break;
    } /* for */
    uClose( fd );					/* close the connection */
    uDieAlone();					/* terminate through reaper */
} /* Acceptor */

void uMain( int argc, char *argv[] ) {
    uFile sd;
    struct sockaddr_in sockinfo, saddr;
    struct hostent *hp;
    unsigned short port;
    int slen;
    uSemaphore stop = U_SEMAPHORE( 0 );

    switch ( argc ) {
      case 2:
        break;
      default:
        uAbort( "usage: %s host-name\n", argv[0] );
        break;
    } /* switch */

    sd = uSocket( AF_INET, SOCK_STREAM, 0 );

    hp = gethostbyname( argv[1] );			/* get internet address from internet name */
    if ( hp == NULL ) {
	uAbort( "internet name lookup failure, hostname:%s", argv[1] );
    } /* if */

    sockinfo.sin_family = AF_INET;
    bcopy( hp->h_addr, &(sockinfo.sin_addr), hp->h_length );
    sockinfo.sin_port = htons( 0 );			/* create and bind a server socket to free port */
    uBind( sd, &sockinfo, sizeof(sockinfo) );

    uListen( sd, 5 );

    slen = sizeof(saddr);				/* obtain free port number for client to use */
    uGetsockname( sd, &saddr, &slen );
    uPrintf( "service available on port %d\n", ntohs( saddr.sin_port ) );

    uEmit( Acceptor, sd );				/* start the first acceptor */
    uP( &stop );					/* currently, this does not stop  */
    uClose( sd );					/* close socket */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -work -nounixrc -O -o Server ServerINET.c" */
/* End: */
