/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * ClientUNIX.c -- Client for UNIX socket test
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Mar  2 13:50:28 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Mar 28 10:23:43 1993
 * Update Count     : 9
 */

#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>

void reader( uFile sd ) {
    int c;

    for ( ;; ) {
        uRead( sd, &c, sizeof( c ) );
      if ( c == EOF ) break;
        uPutc( c, uStdout );
    } /* for */
} /* reader */

void writer( uFile sd ) {
    uEofExMsg *eof;
    int c;

    uExcept {
        for ( ;; ) {
            c = uGetc( uStdin );
            uWrite( sd, &c, sizeof( c ) );
        } /* for */
    } uHandlers {
        uWhen( uStdin, &uEofEx, &eof ) {
            c = EOF;
            uWrite( sd, &c, sizeof( c ) );		/* write EOF to socket */
        }
    } uEndExcept;
} /* writer */

void uMain( int argc, char *argv[] ) {
    uFile sd;
    struct sockaddr_un sockinfo;
    uTask wr;
    uTask rd;

    switch ( argc ) {
      case 2:
        break;
      default:
        uAbort( "usage: %s socket-name\n", argv[0] );
    } /* switch */

    sd = uSocket( AF_UNIX, SOCK_STREAM, 0 );		/* create a socket */

    sockinfo.sun_family = AF_UNIX;			/* specify socket domain */
    strcpy( sockinfo.sun_path, argv[1] );		/* specify destination socket name */ 
    uConnect( sd, &sockinfo, sizeof(sockinfo) );	/* connection to destination socket */

    wr = uEmit( writer, sd );				/* emit a worker to read from file and write to socket */
    rd = uEmit( reader, sd );				/* emit a worker to read from socket and write to file */
    uAbsorb( wr, NULL, 0 );				/* absorb worker */
    uAbsorb( rd, NULL, 0 );				/* absorb worker */
    
    uClose( sd );					/* close socket */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -work -nounixrc -O -o Client ClientUNIX.c" */
/* End: */
