/* Copyright (c) 1989  P. A. Buhr */

/*
  Produce the fibonacci numbers in sequence on each call.
  
  No explicit states, communication with shared variables.
  */

#include <uSystem.h>

int fn, fn1, fn2;					/* shared variable */

void fibonacci() {
    fn = 1;						/* 1st case */
    fn1 = fn;
    uSuspend(NULL, 0, NULL, 0);
    fn = 1;						/* 2nd case */
    fn2 = fn1;
    fn1 = fn;
    uSuspend(NULL, 0, NULL, 0);
    for (;;) {						/* general case */
	fn = fn1 + fn2;
	fn2 = fn1;
	fn1 = fn;
	uSuspend(NULL, 0, NULL, 0);
    } /* for */
} /* fibonacci */

#define NoOfFibs 10

void uMain() {
    uCoroutine c;
    int i;
    
    printf("Fibonacci Numbers\n");
    c = uCocall(NULL, 0, fibonacci);
    for (i = 1; ; i += 1) {
	printf("%d\n", fn);
    if (i >= NoOfFibs) break;
	uResume(c, NULL, 0, NULL, 0);
    } /* for */
    printf("successful completion\n");
} /* uMain */
