/* Copyright (c) 1989  P. A. Buhr */

/*
  Consumer driven producer-consumer problem, semi-coroutines.
  */

#include <uSystem.h>

long random();

void Producer() {
    int NoOfItems, i, product;
    
    uSuspend(NULL, 0, NULL, 0);
    NoOfItems = random() % 10 + 1;			/* generate a random number of items to be produced */
    printf("Producer will produce %d items for the consumer\n", NoOfItems);
    for (i = 1; i <= NoOfItems; i += 1) {
	product = random() % 100 + 1;
	printf("Producer: %d\n", product);
	uSuspend(NULL, 0, &product, sizeof(product));
    } /* for */
    product = -1;
    uSuspend(NULL, 0, &product, sizeof(product));	/* signal completion */
} /* Producer */

void Consumer() {
    uCoroutine prod;
    int product;
    
    prod = uCocall(NULL, 0, Producer);
    for ( ; ; ) {
	uResume(prod, &product, sizeof(product), NULL, 0);
    if (product == -1) break;
	printf("Consumer: %d\n", product);
    } /* for */
} /* Consumer */

void uMain() {
    Consumer();						/* someone must be the cocaller */
    printf("successful completion\n");
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -quiet -work ConsProd.c" */
/* End: */
