/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uBench.c -- This program performs a benchmark test on the concurrency facilities
 *    of the uSystem. It will run on the BSD and System V OSs.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Feb 13 11:06:19 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Mar 28 10:27:16 1993
 * Update Count     : 38
 */

#include <uSystem.h>
#include <Time.i>

void CoroutineDummy( void ) {
    uSuspendDie( NULL, 0 );
} /* CoroutineDummy */

void CoroutineCreateDelete( int N ) {
    int StartTime, EndTime;
    
    int i;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uLongCocall( NULL, 0, uGetStackSize(), CoroutineDummy, 0 );
    } /* for */

    EndTime = Time();
    uPrintf( "& %d", ( EndTime - StartTime ) / N );
} /* CoroutineCreateDelete */

void TaskDummy( void ) {
    uDie( NULL, 0 );
} /* TaskDummy */

void TaskCreateDelete( int N ) {
    int StartTime, EndTime;
    int i;
    uCluster cluster = uThisCluster();
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uAbsorb( uLongEmit( cluster, uGetStackSize(), TaskDummy, 0 ), NULL, 0 );
    } /* for */

    EndTime = Time();
    uPrintf( "\t& %d", ( EndTime - StartTime ) / N );
} /* TaskCreateDelete */

void ContextSwitch( int N ) {
    int StartTime, EndTime;
    int i;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uYield();
    } /* for */

    EndTime = Time();
    uPrintf( "\t& %d", ( EndTime - StartTime ) / N );
} /* ContextSwitch */

void PVCxtSw2( int N, uSemaphore *Shared1, uSemaphore *Shared2 ) {
    int i;

    for ( i = 0; i < N; i += 1 ) {
	uP( Shared2 );
	uV( Shared1 );
    } /* for */

    uDie( NULL, 0 );
} /* PVCxtSw2 */

void PVCxtSw1( int N ) {
    int StartTime, EndTime;
    uSemaphore Shared1 = U_SEMAPHORE( 0 );
    uSemaphore Shared2 = U_SEMAPHORE( 0 );
    uTask who;
    int i;

    who = uEmit( PVCxtSw2, N, &Shared1, &Shared2 );
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uV( &Shared2 );
	uP( &Shared1 );
    } /* for */

    EndTime = Time();
    uPrintf( "\t& %d", ( EndTime - StartTime ) / N / 2 ); /* divide by 2 because 2 P's */

    uAbsorb( who, NULL, 0 );
    uDie( NULL, 0 );
} /* PVCxtSw1 */

void Resume2( int N, uCoroutine resume1 ) {
    int i;
    char message[16];

    uSuspend( message, sizeof(message), NULL, 0 );
    for ( i = 0; i < N; i += 1 ) {
	uResume( resume1, message, sizeof( message ), message, sizeof( message ) );
    } /* for */
} /* Resume2 */

void Resume1( int N, uCoroutine creator ) {
    int StartTime, EndTime;
    int i;
    uCoroutine resume2;
    char message[16];

    resume2 = uCocall( NULL, 0, Resume2, N, uThisCoroutine() );

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uResume( resume2, message, sizeof( message ), message, sizeof( message ) );
    } /* for */

    EndTime = Time();
    uPrintf( "\t& %d", ( EndTime - StartTime ) / N );

    uResume( resume2, NULL, 0, NULL, 0 );
    uResumeDie( creator, NULL, 0 );
} /* Resume1 */

void ReceiveReply( int N ) {
    int i;
    char message[16];

    for( i = 0; i < N; i += 1 ) {
	uReply( uReceive( message, sizeof( message ) ), message, sizeof( message ) );
    } /* for */
    uDie( NULL, 0 );
} /* ReceiveReply */

void Send( int N ) {
    int StartTime, EndTime;
    int i;
    uTask replier;
    char message[16];

    replier = uEmit( ReceiveReply, N );
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uSend( replier, message, sizeof( message ), message, sizeof( message ) );
    } /* for */
    
    EndTime = Time();
    uPrintf( "\t\t& %d", ( EndTime - StartTime ) / N );

    uAbsorb( replier, NULL, 0 );
    uDie( NULL, 0 );
} /* Send */

void uStart( void ) {
    /* uSetTimeSlice( 0 ); */					/* turn off time slice */
} /* uStart */

void uMain() {
    const int NoOfTimes = 10000;

    uPrintf( "coroutine task\tcontext\tP/V,\tresume/resume,\tsend/rec/reply,\n" );
    uPrintf( "create/\tcreate/\tswitch\tcxt\t16 bytes\t16 bytes\n" );
    uPrintf( "delete\tdelete\t\tswitch\tbidirectional\tbidirectional\n" );

    InitTime();

    CoroutineCreateDelete( NoOfTimes );

    TaskCreateDelete( NoOfTimes );

    ContextSwitch( NoOfTimes );

    uAbsorb( uEmit( PVCxtSw1, NoOfTimes ), NULL, 0 );

    uCocall( NULL, 0, Resume1, NoOfTimes, uThisCoroutine() );

    uAbsorb( uEmit( Send, NoOfTimes ), NULL, 0 );

    uPrintf( "\t\\\\\n" );

    uDie( NULL, 0 );
} /* uMain */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
