/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * SGIBench.c -- This program performs a benchmark test on the concurrency facilities
 *    of SGI. It will run on the IRIX OS.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Feb 13 11:06:19 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:09:22 1992
 * Update Count     : 89
 */

#include <Time.i>

#define  _LANGUAGE_C 1
#include <stdio.h>
#include <sys/wait.h>
#include <sys/prctl.h>
#include <ulocks.h>

/* extern int getpid( void ); */
extern int blockproc( int );
extern int unblockproc( int );
extern int setblockproccnt( int, int );
/* extern int sproc ( void (*)(), unsigned inh, void *arg ); */

#define NoOfTimes 10000

void TaskDummy( void ) {
    exit( 0 );
} /* TaskDummy */

void TaskCreateDelete( void ) {
    int StartTime, EndTime;
    int i;

    StartTime = Time();

    for ( i = 0; i < NoOfTimes; i += 1 ) {
	sproc( TaskDummy, PR_SALL, 0 );
	wait( (union wait*)0 );				/* wait for child to finish */
    } /* for */

    EndTime = Time();
    printf( "& %d", ( EndTime - StartTime ) / NoOfTimes );
} /* TaskCreateDelete */

void BlockCxtSw2( int other ) {
    int me = getpid();
    int i;

    for ( i = 0; i < NoOfTimes; i += 1 ) {
	blockproc( me );
	unblockproc( other );
    } /* for */
    exit( 0 );
} /* BlockCxtSw2 */

void BlockCxtSw1( void ) {
    int StartTime, EndTime;
    int me = getpid(), other;
    int i;

    other = sproc(  BlockCxtSw2, PR_SALL, me );
    
    StartTime = Time();

    for ( i = 0; i < NoOfTimes; i += 1 ) {
	unblockproc( other );
	blockproc( me );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / NoOfTimes / 2 ); /* divide by 2 because 2 P's */

    wait( (union wait*)0 );				/* wait for child to finish */
    exit( 0 );
} /* BlockCxtSw1 */

struct LockCxt {
    ulock_t l1;
    ulock_t l2;
}; /* LockCxt */

void LockCxtSw2( struct LockCxt *locks ) {
    int i;

    for ( i = 0; i < NoOfTimes; i += 1 ) {
	ussetlock( locks->l2 );
	usunsetlock( locks->l1 );
    } /* for */
    exit( 0 );
} /* LockCxtSw2 */

void LockCxtSw1( usptr_t *arena ) {
    int StartTime, EndTime;
    struct LockCxt locks;
    int i;
    int code;
    
    /* allocate both locks */
    locks.l1 = usnewlock( arena );
    if ( locks.l1 == 0 ) { printf( "lock error\n" ); exit( -1 ); }
    locks.l2 = usnewlock( arena );
    if ( locks.l2 == 0 ) { printf( "lock error\n" ); exit( -1 ); }

    /* start both locks off in a locked state */
    code = ussetlock( locks.l1 );
    if ( code == -1 ) { printf( "lock error\n" ); exit( -1 ); }
    code = ussetlock( locks.l2 );
    if ( code == -1 ) { printf( "lock error\n" ); exit( -1 ); }

    sproc( LockCxtSw2, PR_SALL, &locks );

    StartTime = Time();

    for ( i = 0; i < NoOfTimes; i += 1 ) {
	usunsetlock( locks.l2 );
	ussetlock( locks.l1 );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / NoOfTimes / 2 ); /* divide by 2 because 2 P's */

    wait( (union wait*)0 );				/* wait for child to finish */
    
    exit( 0 );
} /* LockCxtSw1 */

void main() {
    printf( "task\tblock,\tlock,\n" );
    printf( "create/\tcxt\tcxt\n" );
    printf( "delete\tswitch\tswitch\n" );

    TaskCreateDelete();

    sproc( BlockCxtSw1, PR_SALL );
    wait( (union wait*)0 );				/* wait for child to finish */

    {
	usptr_t *arena;
	
	arena = usinit( "uSystem" );
	if ( arena == 0 ) exit( -1 );

	sproc( LockCxtSw1, PR_SALL, arena );

	wait( (union wait*)0 );				/* wait for child to finish */
    }

    printf( "\t\\\\\n" );
} /* main */

/* Local Variables: */
/* compile-command: "gcc -O SGIBench.c -lmpc" */
/* End: */
