#include <uSystem.h>
#include <Time.i>

void CSwithoutFP( int N ) {
    int StartTime, EndTime;
    int i;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uYield();
    } /* for */

    EndTime = Time();
    uPrintf( "without FP:%d\n", ( EndTime - StartTime ) / N );
} /* CSwithoutFP */

void CSwithFP( int N ) {
    int StartTime, EndTime;
    int i;

    uSaveFloat();						/* save floating point registers */
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	uYield();
    } /* for */

    EndTime = Time();
    uPrintf( "with FP:%d\n", ( EndTime - StartTime ) / N );
} /* CSwithFP */

void uStart( void ) {
    uSetTimeSlice( 0 );					/* turn off time slice */
} /* uStart */

void uMain() {
    const int NoOfTimes = 100000;

    InitTime();

    CSwithoutFP( NoOfTimes );
    CSwithFP( NoOfTimes );

} /* uMain */

/* Local Variables: */
/* compile-command: "concc -O -I/u/usystem/software/concc/inc FloatComparison.c" */
/* End: */
