#include <thread.h>
#include <stdio.h>

extern int THREADtimed;
extern unsigned *THREADtimerptr;

main( int argc, char *argv[] ) {
   extern void startup();

   if (argc != 1) {
      fprintf(stderr, "usage: %s\n", argv[0]) ;
      exit(1);
   }

   THREADtimed++;
   THREADstackspaceinit(1024, 1000);
   
   THREADgo(1, 30*1024*1024, startup, 0, 0, 10*1024, 2);
}

void startup() {
   extern void child();
   int i;
   unsigned start, t = 0;

   for (i=0; i<1000; i++) {
      start = *THREADtimerptr;
      THREADcreate(child, 0, 0, 1, 1*1024, 1);
      t += *THREADtimerptr - start;
   }
   fprintf(stderr, "Average time to create a thread is %d microseconds\n", t/1000);
}

void child() {
}

/* Local Variables: */
/* compile-command: "gcc -O EncoreBench.c -lept" */
/* End: */
