//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1994
// 
// uHeap.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jul 20 00:07:05 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jun 22 17:35:26 2007
// Update Count     : 127
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_HEAPMANAGER_H__
#define __U_HEAPMANAGER_H__


bool uTraceHeapOn();					// forward declarations
bool uTraceHeapOff();

class MMInfoEntry;					// for profiler

extern "C" void *malloc( size_t size ) __THROW;
extern "C" void *calloc( size_t noOfElems, size_t elemSize ) __THROW;
extern "C" void *realloc( void *addr, size_t size ) __THROW;
extern "C" void *memalign( size_t alignment, size_t size ) __THROW;
extern "C" void free( void *addr ) __THROW;


class uHeapManager {
    friend bool uTraceHeapOn();				// access: traceAlloc
    friend bool uTraceHeapOff();			// access: traceAlloc
    friend class uKernelBoot;				// access: uHeap
    friend void *malloc( size_t size ) __THROW;		// access: boot
    friend void *calloc( size_t noOfElems, size_t elemSize ) __THROW; // access: boot
    friend void *realloc( void *addr, size_t size ) __THROW; // access: boot
    friend void *memalign( size_t alignment, size_t size ) __THROW; // access: boot
    friend void free( void *addr ) __THROW;             // access: uDoFree

    static uHeapManager *heapManagerInstance;		// pointer to heap manager object
    static ptrdiff_t preAlloc;				// allocations before start of uC++
    static bool traceAlloc;				// trace allocations and deallocations

    static void noMemory();				// called by "builtin_new" when malloc returns 0

    struct uStorage;					// forward declaration

    struct uFreeHeader {
	size_t blockSize __attribute__(( aligned (64) )); // size of cache line to prevent false sharing
	uSpinLock lock;
	uStorage *freeList;
    }; // uFreeHeader

    struct uStorage {
	struct uHeader {				// header
	    union {
		uFreeHeader *home;			// allocated block points back to home locations
		uStorage *next;				// freed block points next freed block of same size
	    } kind;
	    // Used by uProfiler to find matching allocation data-structure for
	    // a deallocation.
	    MMInfoEntry *profileMallocEntry;
	} header; // uHeader
	char uData[0];					// storage
    }; // uStorage

    // These variables are protected by individual spin locks in the elements.
    // The first 3 elements of the array are not used (2**0 to 2**3), i.e., the
    // smallest allocation is 16 bytes (2**4). Each element of the array is the
    // size of a cache line to prevent false sharing among CPU caches during
    // bursts of allocations/deallocations.
    uFreeHeader freeLists[32];

    // These variables are protected by the extension spin lock.
    uSpinLock extlock;
    void *heapBegin;					// start of heap
    void *heapEnd;					// logical end of heap
    size_t heapRemaining;				// amount of storage not allocated in the current chunk

    static void boot();

    void headers( const char *name, void *addr, uStorage *&block, uFreeHeader *&freeElem, size_t &alignment );
    void *extend( size_t size );
    void *doMalloc( size_t size );
    void doFree( void *addr );
    size_t checkFree();
    uHeapManager();
    ~uHeapManager();

    void *operator new( size_t, void *storage );
    void *operator new( size_t size );
  public:
}; // uHeapManager


#endif // __U_HEAPMANAGER_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
