//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Richard C. Bilson 2004
// 
// uAtomic.h -- atomic routines for various processors
// 
// Author           : Richard C. Bilson
// Created On       : Thu Sep 16 13:57:26 2004
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 25 16:51:37 2007
// Update Count     : 14
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#if defined( __ia64__ )
#include <ia64intrin.h>
#endif // __ia64__


inline int uAtomic( unsigned int *lock ) {
#if defined( __sparc__ )
    int result = 1;
    asm( "ldstub %1, %0" : "+r" (result), "+m" (*lock) );
    return result;
#elif defined( __i386__ ) || defined( __x86_64__ )
    int result = 1;
    asm( "xchgl %0,%1" : "+q" (result), "+m" (*lock) );
    return result;
#elif defined( __ia64__ )
    return __sync_lock_test_and_set( lock, 1 );
#elif defined( __mips__ )
    int result;
    bool success;
    do {
	asm( "ll   %0,%2\n\t"
	     "or   %1,%0,1\n\t"
	     "sc   %1,%2"
	     : "=&r" (result), "=&r" (success), "+m" (*lock) );
    } while ( ! success );
    return result;
#else
    #error uC++ : internal error, unsupported architecture
#endif
} // uAtomic


#if defined( __sparc__ ) && ! defined( GLIBCXX_ENABLE_ATOMIC_BUILTINS )
inline bool compareAndSwap( volatile int *loc, int exp, int replacement ) {
    asm( "membar #StoreStore|#LoadStore|#StoreLoad|#LoadLoad\n"
	 "cas [%2], %3, %0" : "+r" (replacement), "+m" (*loc) : "r" (loc), "r" (exp) );
    return replacement == exp;
} // compareAndSwap
#endif // __sparc__ && ! GLIBCXX_ENABLE_ATOMIC_BUILTINS


inline void uAtomicInc( volatile int &counter ) {
#if defined( GLIBCXX_ENABLE_ATOMIC_BUILTINS ) || defined( __ia64__ )
    __sync_fetch_and_add( &counter, 1 );
#elif defined( __sparc__ )
    int cur;
    do {
	cur = counter;
    } while( ! compareAndSwap( &counter, cur, cur+1 ) );
#elif defined( __i386__ ) || defined( __x86_64__ )
    __asm__(
#ifdef __U_MULTI__
	"lock "
#endif // ! __U_MULTI__
	"incl %0" : "=m" (counter) );
#elif defined( __mips__ )
    bool success;
    do {
	asm( "ll   %0,%1\n\t"
	     "add  %0,%0,1\n\t"
	     "sc   %0,%1"
	     : "=&r" (success), "+m" (counter) );
    } while ( ! success );
#else
    #error uC++ : internal error, unsupported architecture
#endif
} // uAtomicInc


inline void uAtomicDec( volatile int &counter ) {
#if defined( GLIBCXX_ENABLE_ATOMIC_BUILTINS ) || defined( __ia64__ )
    __sync_fetch_and_add( &counter, -1 );
#elif defined( __sparc__ )
    int cur;
    do {
	cur = counter;
    } while( ! compareAndSwap( &counter, cur, cur-1 ) );
#elif defined( __i386__ ) || defined( __x86_64__ )
    __asm__(
#ifdef __U_MULTI__
	"lock "
#endif // ! __U_MULTI__
	"decl %0" : "=m" (counter) );
#elif defined( __mips__ )
    bool success;
    do {
	asm( "ll   %0,%1\n\t"
	     "sub  %0,%0,1\n\t"
	     "sc   %0,%1"
	     : "=&r" (success), "+m" (counter) );
    } while ( ! success );
#else
    #error uC++ : internal error, unsupported architecture
#endif
} // uAtomicDec


// Local Variables: //
// compile-command: "gmake install" //
// End: //
