#include <unistd.h>					// sysconf
#include <sys/times.h>					// times

inline int Time() {
#if 1
    struct tms usage;
    long int usec_per_tck = 1000000 / sysconf(_SC_CLK_TCK);
    times( &usage );
    return ( usage.tms_utime + usage.tms_stime ) * usec_per_tck;
#else  // old BSD form
    struct rusage usage;
    getrusage( RUSAGE_SELF, &usage );
    return usage.ru_utime.tv_sec * 1000000 + usage.ru_utime.tv_usec +
	   usage.ru_stime.tv_sec * 1000000 + usage.ru_stime.tv_usec;
#endif
} /* Time */
