//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1994
// 
// Migrate.cc -- Test migrating of tasks among clusters.
// 
// Author           : Peter Buhr
// Created On       : Tue Jun 28 10:23:11 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun 26 10:47:23 2007
// Update Count     : 37
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::endl;

unsigned int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

_Task Worker {
    uCluster &cluster1, &cluster2, &cluster3;

    void main() {
	const int NoOfTimes = 10000;

        for ( int i = 0; i < NoOfTimes; i += 1 ) {
	    migrate( cluster3 );
	    migrate( cluster2 );
	    migrate( cluster1 );
        } // for
    } // Worker::main
  public:
    Worker( uCluster &cluster1, uCluster &cluster2, uCluster &cluster3 ) : uBaseTask( cluster1 ), cluster1( cluster1 ), cluster2( cluster2 ), cluster3( cluster3 ) {
    } // Worker::Worker
}; // Worker

uCluster cluster1;
uProcessor processor1( cluster1 );

uCluster cluster2;
uProcessor processor2( cluster2 );

void uMain::main() {
    {
	Worker task1( uThisCluster(), cluster1, cluster2 ), task2( cluster2, uThisCluster(), cluster1 ), task3( cluster1, cluster2, uThisCluster() );
    }
    cout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Migrate.cc" //
// End: //
