//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 2006
// 
// CRAII.cc -- Test that deletion of a non-terminated coroutine results in all
//             objects on its stack to be deallocated.
// 
// Author           : Peter A. Buhr
// Created On       : Thu Feb 23 21:42:16 2006
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun 26 09:12:44 2007
// Update Count     : 41
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::endl;

const unsigned int NoInTest = 4;
const unsigned int MaxStackDepth = 4;

int check = 0;

class RAII {
  public:
    RAII() {
	check += 1;
	cout << " RAII constructor (" << this << ") :" << check << endl;
    }
    ~RAII() {
	check -= 1;
	cout << " RAII destructor(" << this << "):" << check << endl;
    }
}; // RAII

_Coroutine CRAII {
    RAII ol[NoInTest];					// object level

    void main() {
	RAII sl[NoInTest] __attribute__(( unused ));	// stack level

	cout << " coroutine(" << this << ") starts:" << check << endl;

	suspend();					// return without termination
	assert( false );				// CONTROL NEVER REACHES HERE!
    }
  public:
    CRAII() {
	check += 1;
	cout << " CRAII constructor(" << this << ") :" << check << endl;
    }
    ~CRAII() {
	check -= 1;
	cout << " CRAII destructor(" << this << "):" << check << endl;
    }
    void mem() { resume(); }
}; // CRAII

_Coroutine C {
    CRAII ol[NoInTest];					// object level

    void main() {
	CRAII sl[NoInTest];				// stack level

	for ( unsigned int i = 0; i < NoInTest; i += 1 ) {
	    ol[i].mem();				// start coroutines
	} // for
	for ( unsigned int i = 0; i < NoInTest; i += 1 ) {
	    sl[i].mem();				// start coroutines
	} // for

	suspend();					// return without termination
	assert( false );				// CONTROL NEVER REACHES HERE!
    }
  public:
    void mem() { resume(); }
}; // C


int checkarray[NoInTest] = { 0 };
bool flags[NoInTest] = { false };
int idno = 0;

class SRAII {						// silent RAII
    unsigned int id;
  public:
    SRAII( unsigned int i ) : id( i ) {
	checkarray[i] += 1;
    } // SRAII::SRAII

    ~SRAII() {
	checkarray[id] -= 1;
	if ( uThisTask().cancelInProgress() ) {
	    cout << "Task " << id << " being cancelled" << endl;
	} // if
    } // SRAII::~SRAII
}; // SRAII


_Task Cancelee {
    SRAII ol;    
    unsigned int id;
  public:
    Cancelee() : ol( idno ), id( idno ) { idno += 1; }
    
    void main() {
	for ( unsigned int i = 0; i < 100000; i+= 1 ) {
	    rec();
	    assert( checkarray[id] > 0 );
	} // for
	flags[id]= ! flags[id];
    } // Cancelee::main
    
    void rec() {
	if ( rand() % MaxStackDepth ) {
	    SRAII sl( id );
	    rec();	    
	} // if
	{
	    uDisableCancel dummy;
	    if ( id ) {
		uEnableCancel dummy;			// implicit poll
	    } else {
		uEHM::poll();				// id == 0 resists cancellation
	    } // if
	} // Disable Cancellation
    } // Cancelee::rec    
}; // Cancelee


void uMain::main() {
    uProcessor processors[3] __attribute__(( unused ));
    { 
	C c;
	c.mem();
	cout << "uMain::main" << endl;
    }
    if ( check != 0 ) uAbort( "not all destructors called" );

    // Task cancellation test

    srand( time(NULL) );
    {
	Cancelee ca[NoInTest];
	yield();
	ca[0].cancel();					// special check for _Disable
        for ( unsigned int i = 1; i < NoInTest; i += 1 ) {
	    if ( rand() %  2 ) {
		flags[i] = true;
		ca[i].cancel();
	    } // if
	} // for
    }
   
    for ( unsigned int i = 0; i < NoInTest; i += 1 ) {
	if ( checkarray[i] != 0 || ! flags[i] ) uAbort( "unsuccessful task cancellation" );
    } // for

    cout << "\n### successful execution ###\n" << endl;
} // uMain::main
