//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// key.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:06:35 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Nov 30 12:14:01 2005
// Update Count     : 88
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
//

#include "key.h"
#include "input.h"

#include <cstddef>					// NULL

keyword_t key[] = {
    { "asm", ASM },
    { "__asm", ASM },					// gcc specific
    { "__asm__", ASM },					// gcc specific
    { "__attribute__", ATTRIBUTE },			// gcc specific
    { "auto", AUTO },
    { "bool", BOOL },
    { "break", BREAK },
    { "case", CASE },
    { "catch", CATCH },
    { "char", CHAR },
    { "class", CLASS },
    { "__complex__", COMPLEX },				// gcc specific
    { "const", CONST },
    { "__const", CONST },				// gcc specific
    { "__const__", CONST },				// gcc specific
    { "const_cast", CONST_CAST },
    { "continue", CONTINUE },
    { "default", DEFAULT },
    { "delete", DELETE },
    { "do", DO },
    { "double", DOUBLE },
    { "dynamic_cast", DYNAMIC_CAST },
    { "else", ELSE },
    { "enum", ENUM },
    { "explicit", EXPLICIT },
    { "export", EXPORT },
    { "__extension__", EXTENSION },			// gcc specific
    { "extern", EXTERN },
    { "false", FALSE },
    { "float", FLOAT },
    { "for", FOR },
    { "friend", FRIEND },
    { "goto", GOTO },
    { "if", IF },
    { "inline", INLINE },
    { "__inline", INLINE },				// gcc specific
    { "__inline__", INLINE },				// gcc specific
    { "int", INT },
    { "long", LONG },
    { "mutable", MUTABLE },
    { "namespace", NAMESPACE },
    { "new", NEW },
    { "operator", OPERATOR },
    { "private", PRIVATE },
    { "protected", PROTECTED },
    { "public", PUBLIC },
    { "register", REGISTER },
    { "reinterpret_cast", REINTERPRET_CAST },
    { "return", RETURN },
    { "short", SHORT },
    { "signed", SIGNED },
    { "__signed", SIGNED },				// gcc specific
    { "__signed__", SIGNED },				// gcc specific
    { "sizeof", SIZEOF },
    { "static", STATIC },
    { "static_cast", STATIC_CAST },
    { "struct", STRUCT },
    { "switch", SWITCH },
    { "template", TEMPLATE },
    { "this", THIS },
    { "throw", THROW },
    { "true", TRUE },
    { "try", TRY },
    { "typedef", TYPEDEF },
    { "typeof", TYPEOF },				// gcc specific
    { "__typeof", TYPEOF },				// gcc specific
    { "__typeof__", TYPEOF },				// gcc specific
    { "typeid", TYPEID },
    { "typename", TYPENAME },
    { "union", UNION },
    { "unsigned", UNSIGNED },
    { "using", USING },
    { "virtual", VIRTUAL },
    { "void", VOID },
    { "volatile", VOLATILE },
    { "__volatile", VOLATILE },				// gcc specific
    { "__volatile__", VOLATILE },			// gcc specific
    { "wchar_t", WCHAR_T },
    { "__wchar_t", WCHAR_T },				// gcc specific
    { "while", WHILE },

    { "and", AND_AND },					// alternate operator names
    { "and_eq", AND_ASSIGN },
    { "bitand", '&' },
    { "bitor", '|' },
    { "compl", '~' },
    { "not", '!' },
    { "not_eq", NE },
    { "or", OR_OR },
    { "or_eq", OR_ASSIGN },
    { "xor", '^' },
    { "xor_eq", XOR_ASSIGN },

// uC++ specific    

    { "__Accept", ACCEPT },
    { "_Accept", ACCEPT },
    { "uAccept", ACCEPT },				// deprecated

    { "__AcceptReturn", ACCEPTRETURN },
    { "_AcceptReturn", ACCEPTRETURN },
    { "uAcceptReturn", ACCEPTRETURN },			// deprecated

    { "__AcceptWait", ACCEPTWAIT },
    { "_AcceptWait", ACCEPTWAIT },
    { "uAcceptWait", ACCEPTWAIT },			// deprecated

    { "__At", AT },
    { "_At", AT },
    { "uAt", AT },					// deprecated

    { "__Coroutine", COROUTINE },
    { "_Coroutine", COROUTINE },
    { "uCoroutine", COROUTINE },			// deprecated

    { "__Disable", DISABLE },
    { "_Disable", DISABLE },
    { "uDisable", DISABLE },				// deprecated

    { "__DualEvent", DUALEVENT },
    { "_DualEvent", DUALEVENT },
    { "uDualEvent", DUALEVENT },			// deprecated

    { "uElse", UELSE },					// deprecated

    { "__Enable", ENABLE },
    { "_Enable", ENABLE },
    { "uEnable", ENABLE },				// deprecated

    { "__Mutex", MUTEX },
    { "_Mutex", MUTEX },
    { "uMutex", MUTEX },				// deprecated

    { "__Nomutex", NOMUTEX },
    { "_Nomutex", NOMUTEX },
    { "uNoMutex", NOMUTEX },				// deprecated

    { "uOr", OR },					// deprecated

    { "__PeriodicTask", PTASK },
    { "_PeriodicTask", PTASK },
    { "uPeriodicTask", PTASK },				// deprecated

    { "__Raise", RAISE },				// deprecated
    { "_Raise", RAISE },				// deprecated
    { "uRaise", RAISE },				// deprecated
    { "__Resume", RAISE },
    { "_Resume", RAISE },

    { "__RaiseEvent", RESUMEEVENT },			// deprecated
    { "_RaiseEvent", RESUMEEVENT },			// deprecated
    { "uRaiseEvent", RESUMEEVENT },			// deprecated

    { "__ResumeEvent", RESUMEEVENT },
    { "_ResumeEvent", RESUMEEVENT },

    { "__RealTimeTask", RTASK },
    { "_RealTimeTask", RTASK },
    { "uRealTimeTask", RTASK },				// deprecated

    { "uResume", RESUME },				// deprecated
    { "uSignal", SIGNAL },				// deprecated
    { "uSignalBlock", SIGNALBLOCK },			// deprecated

    { "__SporadicTask", STASK },
    { "_SporadicTask", STASK },
    { "uSporadicTask", STASK },				// deprecated

    { "uSuspend", SUSPEND },				// deprecated

    { "__Task", TASK },
    { "_Task", TASK },
    { "uTask", TASK },					// deprecated

    { "__Timeout", TIMEOUT },
    { "_Timeout", TIMEOUT },
    { "uTimeout", TIMEOUT },				// deprecated

    { "uWait", WAIT },					// deprecated

    { "__When", WHEN },
    { "_When", WHEN },
    { "uWhen", WHEN },					// deprecated

    { "uWith", WITH },

    { "__Throw", UTHROW },
    { "_Throw", UTHROW },
    { "uThrow", UTHROW },				// deprecated

    { "__ThrowEvent", THROWEVENT },
    { "_ThrowEvent", THROWEVENT },
    { "uThrowEvent", THROWEVENT },			// deprecated
    
    { NULL, 0 }
};

// Local Variables: //
// compile-command: "gmake install" //
// End: //
