//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// hash.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:37:36 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jun 28 16:43:32 2001
// Update Count     : 26
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 
 

#ifndef __HASH_H__
#define __HASH_H__

#define HASH_TABLE_SIZE 1009 // should be a prime number

class hash_t {
    friend class hash_table_t;
  public:
    char *text;
    hash_t *link;
    int InSymbolTable;
    int value;
  public:
    hash_t( const char *, hash_t *, int value );
    ~hash_t();
};

class hash_table_t {
  private:
    hash_t *table[HASH_TABLE_SIZE];
  public:
    hash_table_t();
    ~hash_table_t();
    hash_t *look( const char *, int value = 0 );
};

extern hash_table_t *hash_table;

#endif // __HASH_H__

// Local Variables: //
// compile-command: "gmake install" //
// End: //
