//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Ashif S. Harji 2000
// 
// uStaticPriorityQ.h -- 
// 
// Author           : Ashif S. Harji
// Created On       : Fri Jan 14 17:59:34 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 12 08:12:27 2006
// Update Count     : 89
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_STATICPRIORITYQ_H__
#define __U_STATICPRIORITYQ_H__

#pragma __U_NOT_USER_CODE__


//#include <uDebug.h>

#include <uC++.h>
#include <uStaticPIQ.h>

#include <cstring>					// access: ffs


#define __U_MAX_NUMBER_PRIORITIES__ 32


class uStaticPriorityQ : public uBasePrioritySeq {
  protected:
    uBaseTaskSeq objects[__U_MAX_NUMBER_PRIORITIES__];
    unsigned int mask;					// allow access to all queue flags

    int currPriority;
  public:
    uStaticPriorityQ();
    virtual bool empty() const;
    virtual uBaseTaskDL *head() const;
    virtual int add( uBaseTaskDL *node, uBaseTask *owner );
    virtual uBaseTaskDL *drop();
    virtual void remove( uBaseTaskDL *node );
    virtual void onAcquire( uBaseTask &oldOwner );
    virtual void onRelease( uBaseTask &owner );

    int afterEntry( uBaseTask *owner );
}; // StaticPriorityQ


template<class List, class Node> class uStaticPriorityScheduleQ : public uBaseSchedule<Node> {
  protected:
    List objects[__U_MAX_NUMBER_PRIORITIES__];
    unsigned int mask;					// allow access to all queue flags
    unsigned int verCount;
  public:
    uStaticPriorityScheduleQ() {
	verCount = mask = 0;
    } // uStaticPriorityScheduleQ::uStaticPriorityScheduleQ

    virtual bool empty() const {
	return mask == 0;
    } // uStaticPriorityScheduleQ::empty

    virtual Node *head() const {
	int highestPriority = ffs( mask ) - 1;

	if ( highestPriority >= 0 ) {
	    Node *node = objects[highestPriority].head();
	    return node;
	} else {
	    return NULL;
	} // if
    } // uStaticPriorityScheduleQ::head

    virtual void add( Node *node ) {
	int priority = getActivePriorityValue( node->task() );
#ifdef __U_DEBUG__
	assert( 0 <= priority && priority <= __U_MAX_NUMBER_PRIORITIES__ - 1 );
#endif // __U_DEBUG__
	objects[priority].add( node );
	mask |= 1ul << priority;
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uStaticPriorityScheduleQ &)0x%p.add( 0x%p ) task %.256s (0x%p) adding task %.256s (0x%p) with priority %d on cluster 0x%p\n",
		   this, node, uThisTask().getName(), &uThisTask(), node->task().getName(), &node->task(), priority, &uThisCluster() );
#endif // __U_DEBUG_H__
    } // uStaticPriorityScheduleQ::add

    virtual Node *drop() {
	int highestPriority = ffs( mask ) - 1;

	if ( highestPriority >= 0 ) {
	    Node *node = objects[highestPriority].drop();
	    if ( objects[highestPriority].empty() ) {
		mask &= ~ ( 1ul << highestPriority );
	    } // if
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uStaticPriorityScheduleQ &)0x%p.drop( 0x%p ) task %.256s (0x%p) removing task %.256s (0x%p) with priority %d on cluster 0x%p\n",
		       this, node, uThisTask().getName(), &uThisTask(), node->task().getName(), &node->task(), highestPriority, &uThisCluster() );
#endif // __U_DEBUG_H__
	    return node;
	} else {
	    return NULL;
	} // if
    } // uStaticPriorityScheduleQ::drop

    virtual bool checkPriority( Node &, Node & ) {
	return false;
    } // uStaticPriorityScheduleQ::checkPriority

    virtual void resetPriority( Node &, Node & ) {
    } // uStaticPriorityScheduleQ::resetPriority

    virtual void addInitialize( uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::addInitialize

    virtual void removeInitialize( uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::removeInitialize

    virtual void rescheduleTask( uBaseTaskDL *, uBaseTaskSeq & ) {
    } // uStaticPriorityScheduleQ::rescheduleTask
}; // uStaticPriorityScheduleQ


template<class List, class Node> class uStaticPriorityScheduleSeq : public uStaticPriorityScheduleQ<List, Node> {
  protected:
    using uStaticPriorityScheduleQ<List, Node>::objects;
    using uStaticPriorityScheduleQ<List, Node>::mask;
    using uStaticPriorityScheduleQ<List, Node>::setActivePriority;
  public:
    virtual bool checkPriority( Node &owner, Node &calling ) {
	return getActivePriorityValue( owner.task() ) > getActivePriorityValue( calling.task() );
    } // uPriorityScheduleSeq::checkPriority

    virtual void resetPriority( Node &owner, Node &calling ) {
	int priority;
	uBaseTask &ownerTask = owner.task();
	uBaseTask &callingTask = calling.task();
	// if same, update owner based on uPIQ
	if ( &ownerTask == &callingTask ) {
	    priority = (static_cast<uStaticPIQ *>(ownerTask.uPIQ))->getHighestPriority(); // TODO: dynamic needed???
	    // if no inheritance priority use base priority
	    if ( priority == -1 ) {
		priority = ownerTask.getBasePriority();
	    } // if
	} else {  // otherwise, update to atmost calling task's priority
	    if ( callingTask.getActivePriorityValue() > ownerTask.getActivePriorityValue() ) return;
	    priority = callingTask.getActivePriorityValue();
	} // if
		
	if ( owner.listed() ) {
	    remove( &owner );
	    setActivePriority( ownerTask, priority );
	    add( &owner );
	} else {
	    setActivePriority( ownerTask, priority );
	} // if
    } // uPriorityScheduleSeq::resetPriority

    virtual void remove( Node *node ) {
	int priority = getActivePriorityValue( node->task() );
	objects[priority].remove( node );
	if ( objects[priority].empty() ) {
	    mask &= ~ ( 1ul << priority );
	} // if
    } // uPriorityScheduleSeq::remove
}; // uPriorityScheduleSeq


#endif //  __U_STATICPRIORITYQ_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
