//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1999
// 
// uRealTime.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Feb  1 15:06:12 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 12 08:12:00 2006
// Update Count     : 72
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#define __U_KERNEL__
#include <uC++.h>
#include <uRealTime.h>
//#include <uDebug.h>


//######################### uPrioritySeq #########################


uPrioritySeq::uPrioritySeq() {				
    mask = 0;
    executeHooks = true;
} // uPrioritySeq::uPriorityScheduleQueue

bool uPrioritySeq::empty() const {			
    return mask == 0;
} // uPrioritySeq::empty

uBaseTaskDL *uPrioritySeq::head() const {			
    int highestPriority = ffs( mask ) - 1;

    if ( highestPriority >= 0 ) {
	uBaseTaskDL *node = objects[highestPriority].head();
	return node;
    } else {
	return NULL;
    } // if
} // uPrioritySeq::head

int uPrioritySeq::add( uBaseTaskDL *node, uBaseTask *owner ) {
    int priority = getActivePriority( node->task() );
    assert( 0 <= priority && priority <= __U_MAX_NUMBER_PRIORITIES__ - 1 );
    objects[priority].add( node );
    mask |= 1ul << priority;
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPriorityScheduleQueue &)0x%p.add( 0x%p ) task %.256s (0x%p) adding task %.256s (0x%p) with priority %d on cluster 0x%p\n",
	       this, node, uThisTask().getName(), &uThisTask(), node->task().getName(), &node->task(), priority, &uThisCluster() );
#endif // __U_DEBUG_H__
    // only perform inheritance for entry list
    if ( isEntryBlocked( node->task() ) && checkHookConditions( *owner, node->task() ) ) { // TEMP: entry queue??
	return( afterEntry( owner ) );		// perform any priority inheritance
    } else {
	return 0;
    } // if
} // uPriorityScheduleQueue::add

uBaseTaskDL *uPrioritySeq::drop() {				
    int highestPriority = ffs( mask ) - 1;

    if ( highestPriority >= 0 ) {
	uBaseTaskDL *node = objects[highestPriority].drop();
	if ( objects[highestPriority].empty() ) {
	    mask &= ~ ( 1ul << highestPriority );
	} // if
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uPriorityScheduleQueue &)0x%p.drop( 0x%p ) task %.256s (0x%p) removing task %.256s (0x%p) with priority %d on cluster 0x%p\n",
		   this, node, uThisTask().getName(), &uThisTask(), node->task().getName(), &node->task(), highestPriority, &uThisCluster() );
#endif // __U_DEBUG_H__
	return node;
    } else {
	return NULL;
    } // if
} // uPrioritySeq::drop

void uPrioritySeq::remove( uBaseTaskDL *node ) {		
	int priority = getActivePriority( node->task() );
	objects[priority].remove( node );
	if ( objects[priority].empty() ) {
	    mask &= ~ ( 1ul << priority );
	} // if
} // uPrioritySeq::remove

int uPrioritySeq::afterEntry( uBaseTask *owner ) {
    if ( ! empty() ) {
	uThisCluster().taskResetPriority( *owner, head()->task() );
    } // if
    return 0;
} // uPrioritySeq::afterEntry

void uPrioritySeq::onAcquire( uBaseTask &owner ) {
    oldInheritTask = &getInheritTask( owner );
    afterEntry( &owner );
} // uPrioritySeq::onAcquire

void uPrioritySeq::onRelease( uBaseTask &owner ) {
    // no queue adjustment as task is running
    setActivePriority( owner, *oldInheritTask );
} // uPrioritySeq::onRelease


//######################### uRealTimeBaseTask #########################


uRealTimeBaseTask::uRealTimeBaseTask( uCluster &cluster ) : uBaseTask( cluster ) {};

uRealTimeBaseTask::uRealTimeBaseTask( uTime _firstActivateTask, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uBaseTask( cluster ) {
    if ( _deadline < 0 ) {
	uAbort( "Attempt to create real time task with deadline less than 0." );
    } // if
    firstActivateTime = _firstActivateTask;
    endTime = _endTime;
    deadline = _deadline;
} // uRealTimeBaseTask::uRealTimeBaseTask

uRealTimeBaseTask::uRealTimeBaseTask( uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uBaseTask( cluster ) {
    if ( _deadline < 0 ) {
	uAbort( "Attempt to create real time task with deadline less than 0." );
    } // if
    firstActivateEvent = _firstActivateEvent;
    firstActivateTime = 0;
    endTime = _endTime;
    deadline = _deadline;
} // uRealTimeBaseTask::uRealTimeBaseTask

uRealTimeBaseTask::uRealTimeBaseTask( uTime _firstActivateTask, uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uBaseTask( cluster ) {
    if ( _deadline < 0 ) {
	uAbort( "Attempt to create real time task with deadline less than 0." );
    } // if
    firstActivateTime = _firstActivateTask;
    firstActivateEvent = _firstActivateEvent;
    endTime = _endTime;
    deadline = _deadline;
} // uRealTimeBaseTask::uRealTimeBaseTask

uRealTimeBaseTask::~uRealTimeBaseTask() {
    while( ! verCountSeq.empty() ) {			// remove list of version counts
	delete verCountSeq.dropHead();
    } // while
} // uRealTimeBaseTask::uRealTimeBaseTask

uDuration uRealTimeBaseTask::getDeadline() const {
    return deadline;
} // uRealTimeBaseTask::getDeadline

uDuration uRealTimeBaseTask::setDeadline( uDuration _deadline ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( "Attempt to change the deadline of task %.256s (0x%p).\n"
		"A task can only change its own deadline.\n",
		getName(), this );
    } // if
#endif // __U_DEBUG__

    // A simple optimization: changing the deadline of a task to its existing
    // value does not require a recalculation of priorities.
	
  if ( _deadline == deadline ) return deadline;

    uDuration temp = deadline;
    deadline = _deadline;
    uThisCluster().taskReschedule( *this );
    yield();
    return temp;
} // uRealTimeBaseTask::setDeadline

int uRealTimeBaseTask::getVersion( uCluster &cluster ) {
    uSeqIter<VerCount> iter;
    VerCount *node = NULL;

    for ( iter.over( verCountSeq ); iter >> node; ) { 
	if ( node->cluster == &cluster ) {
	    return node->version;
	} // if
    } // for

    return -1;
} // uRealTimeBaseTask::getVersion
    
int uRealTimeBaseTask::setVersion( uCluster &cluster, int version ) {
    uSeqIter<VerCount> iter;
    VerCount *ref = NULL, *node = NULL, *prev = NULL;
    int temp;

    for ( iter.over(verCountSeq), prev = NULL; iter >> node ; prev = node ) { // find place in the list to insert
	if ( &cluster < node->cluster ) break;
    } // for

    if ( prev != NULL && prev->cluster == &cluster ) {
	temp = prev->version; 
	prev->version = version;
    } else {
	temp = -1;
	ref = new VerCount;
	ref->cluster = &cluster;
	ref->version = version;
	verCountSeq.insertBef( ref, node );
    } // if

    return temp;
} // uRealTimeBaseTask::setVersion


//######################### uPeriodicBaseTask #########################


uPeriodicBaseTask::uPeriodicBaseTask( uDuration _period, uCluster &cluster ) : uRealTimeBaseTask( uTime(0), uTime(0), uDuration(0), cluster ) {
    period = _period;
} // uPeriodicBaseTask::uPeriodicBaseTask

uPeriodicBaseTask::uPeriodicBaseTask( uDuration _period, uTime _firstActivateTask, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateTask, _endTime, _deadline, cluster ) {
    period = _period;
} // uPeriodicBaseTask::uPeriodicBaseTask

uPeriodicBaseTask::uPeriodicBaseTask( uDuration _period, uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateEvent, _endTime, _deadline, cluster ) {
    period = _period;
} // uPeriodicBaseTask::uPeriodicBaseTask

uPeriodicBaseTask::uPeriodicBaseTask( uDuration _period, uTime _firstActivateTask, uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateTask, _firstActivateEvent, _endTime, _deadline, cluster ) {
    period = _period;
} // uPeriodicBaseTask::uPeriodicBaseTask

uDuration uPeriodicBaseTask::getPeriod() const {
    return period;
} // uPeriodicBaseTask::getPeriod

uDuration uPeriodicBaseTask::setPeriod( uDuration _period ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( "Attempt to change the period of task %.256s (0x%p).\n"
		"A task can only change its own period.\n",
		getName(), this );
    } // if
#endif // __U_DEBUG__

    // A simple optimization: changing the period of a task to its existing
    // value does not require a recalculation of priorities.
	
  if ( _period == period ) return period;

    uDuration temp = period;
    period = _period;
    uThisCluster().taskReschedule( *this );
    yield();
    return temp;
} // uPeriodicBaseTask::setPeriod


//######################### uSporadicBaseTask #########################


uSporadicBaseTask::uSporadicBaseTask( uDuration _frame, uCluster &cluster ) : uRealTimeBaseTask( uTime(0), uTime(0), uDuration(0), cluster ) {
    frame = _frame;
} // uSporadicBaseTask::uSporadicBaseTask

uSporadicBaseTask::uSporadicBaseTask( uDuration _frame, uTime _firstActivateTask, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateTask, _endTime, _deadline, cluster ) {
    frame = _frame;
} // uSporadicBaseTask::uSporadicBaseTask

uSporadicBaseTask::uSporadicBaseTask( uDuration _frame, uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateEvent, _endTime, _deadline, cluster ) {
    frame = _frame;
} // uSporadicBaseTask::uSporadicBaseTask

uSporadicBaseTask::uSporadicBaseTask( uDuration _frame, uTime _firstActivateTask, uEvent _firstActivateEvent, uTime _endTime, uDuration _deadline, uCluster &cluster ) : uRealTimeBaseTask( _firstActivateTask, _firstActivateEvent, _endTime, _deadline, cluster ) {
    frame = _frame;
} // uSporadicBaseTask::uSporadicBaseTask

uDuration uSporadicBaseTask::getFrame() const {
    return frame;
} // uSporadicBaseTask::getFrame

uDuration uSporadicBaseTask::setFrame( uDuration _frame ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( "Attempt to change the frame of task %.256s (0x%p).\n"
		"A task can only change its own frame.\n",
		getName(), this );
    } // if
#endif // __U_DEBUG__

    // A simple optimization: changing the frame of a task to its existing
    // value does not require a recalculation of priorities.
	
  if ( _frame == frame ) return frame;

    uDuration temp = frame;
    frame = _frame;
    uThisCluster().taskReschedule( *this );
    yield();
    return temp;
} // uSporadicBaseTask::setFrame


//######################### uRealTimeCluster #########################


uRealTimeCluster::uRealTimeCluster( uBaseSchedule<uBaseTaskDL> &rq, int size, const char *name ) : uCluster( rq, size, name ) {};
uRealTimeCluster::uRealTimeCluster( uBaseSchedule<uBaseTaskDL> &rq, const char *name ) : uCluster( rq, name ) {};
uRealTimeCluster::~uRealTimeCluster() {};


// Local Variables: //
// compile-command: "gmake install" //
// End: //
