//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 2004
// 
// ulocks.cc -- IRIX semaphore operations
// 
// Author           : Richard C. Bilson
// Created On       : Mon Mar 22 14:09:50 2004
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 12 08:08:29 2006
// Update Count     : 24
// 
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.


#if defined( __irix__ )

#include <uC++.h>
#include <ulocks.h>

//#include <uDebug.h>


extern "C" {
    // An IRIX semaphore behaves like a counting semaphore, but it has an additional
    // mode in which the process that sets the count to 0 can p the semaphore multiple
    // additional times without blocking; the count is unaffected, and only increments
    // to 1 after the owner has v'd as many times as it previously p'd.  Given a
    // semaphore "sem", the call "usctlsema( sem, CS_RECURSIVEON )" enables this behavior.

    // In practice, this semaphore is only used to provide libc locking as an owner
    // lock -- that is, the count is either 0 or 1.  This implementation uses uOwnerLock,
    // which means that the semaphore is unable to count -- an assertion in _usvsema
    // checks that no program attempts to v the semaphore when its count is 1.

    // All routines are prefixed by '_' relative to the documented API, so that the internal
    // functions used by libc can be overridden.

    usema_t *_usnewsema( usptr_t *handle, int val ) {
	// handle ignored -- separate arenas is unsupported
	assert( val == 1 );
	uOwnerLock *lock = new uOwnerLock();
#ifdef __U_DEBUG_H__
	uDebugPrt( "usnewsema( 0x%p , %d ) -> 0x%p\n", handle, val, lock );
#endif
	return (usema_t *)lock;
    } // _usnewsema

    int _usinitsema( usema_t *sem, int val ) {
	assert( val == 1 );
	new(sem) uOwnerLock();
	return 0;
    } // _usnewsema

    int _uspsema( usema_t *sem ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "uspsema( 0x%p )\n", sem );
#endif
	((uOwnerLock *)sem)->acquire();
	return 1;
    } // _uspsema

    int _uscpsema( usema_t *sem ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "uscpsema( 0x%p )\n", sem );
#endif
	return ((uOwnerLock *)sem)->tryacquire();
    } // _uscpsema

    int _usvsema( usema_t *sem ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "usvsema( 0x%p )\n", sem );
#endif
	assert( ((uOwnerLock *)sem)->times() > 0 );
	((uOwnerLock *)sem)->release();
	return 0;
    } // _usvsema

    int _ustestsema( usema_t *sem ) {
	if( ((uOwnerLock *)sem)->times() != 0 ) {
	    return 0;
	} else {
	    return 10;
	} // if
    } // _ustestsema

    void _usfreesema( usema_t *sem, usptr_t *handle ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "usfreesema( 0x%p , 0x%p )\n", sem, handle );
#endif
	// handle ignored -- we don't support separate arenas
	delete ((uOwnerLock *)sem);
    } // _usfreesema

    int _usctlsema( usema_t *sem, int cmd, ... ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "usctlsema( 0x%p , %d )\n", sem, cmd );
#endif
	if ( cmd != CS_RECURSIVEON ) {
	    uAbort( "invalid semaphore control command %d", cmd );
	} // if
	return 0;
    } // usnewpollsema

    int _usdumpsema( usema_t *, FILE *, const char * ) {
	uAbort( "usdumpsema : not implemented." );
    } // _usdumpsema

    usema_t *_usnewpollsema( usptr_t *, int ) {
	uAbort( "usnewpollsema : not implemented." );
    } // _usnewpollsema

    int _usfreepollsema( usema_t *, usptr_t * ) {
	uAbort( "usfreepollsema : not implemented." );
    } // _usfreepollsema

    int _usopenpollsema( usema_t *, mode_t ) {
	uAbort( "usopenpollsema : not implemented." );
    } // _usopenpollsema

    int _usclosepollsema( usema_t * ) {
	uAbort( "usclosepollsema : not implemented." );
    } // _usclosepollsema
} // extern "C"

#endif // __irix__

// Local Variables: //
// compile-command: "gmake install" //
// End: //
