//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Russell Mok 1997
// 
// uEHM.h -- 
// 
// Author           : Russell Mok
// Created On       : Mon Jun 30 16:46:18 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Sep 13 21:48:38 2006
// Update Count     : 267
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_EHM_H__
#define __U_EHM_H__

#include <typeinfo>

#define uRendezvousAcceptor uSerialMemberInstance.uAcceptor
#define uEHMMaxMsg 156					// room for "...\0"
#define uEHMMaxName 60					// room for "...\0"


//######################### uEHM ########################


class uEHM {
    friend class uKernelBoot;				// access: terminateHandler, unexpectedHandler
    friend class uMachContext;				// access: raiseKind, terminate
    friend class uBaseCoroutine;			// access: ResumeWorkHorseInit, uResumptionHandlers, uDeliverEStack, unexpected, strncpy
    friend class uBaseTask;				// access: terminateHandler

    class ResumeWorkHorseInit;
    class AutoResourceCleanup;
    class AsyncEMsg;
    class AsyncEMsgBuffer;

    enum raiseKind { uThrowF, uResumeF };

    static bool match_exception_type( const std::type_info *derived_type, const std::type_info *parent_type );
    static bool deliverable_exception( const std::type_info *event_type );
    static void terminate() __attribute__(( noreturn ));
    static void terminateHandler() __attribute__(( noreturn ));
    static void unexpected() __attribute__(( noreturn ));
    static void unexpectedHandler() __attribute__(( noreturn ));
  public:
    class uResumptionHandlers;				// usage generated by translator
    template< typename Exn > class uNullHandlerClause;
    template< typename Exn, typename Functor > class uHandlerClause;
    class uAnyHandlerClause;

    class uHandlerBase;
    class uDeliverEStack;
    class uDualClass;
    class uThrowClass;
    class uResumeClass;

    static void asyncToss( const uDualClass &ex, uBaseCoroutine &target, raiseKind f, bool rethrow = false );
    static void asyncReToss( uBaseCoroutine &target, raiseKind f );

    static void Throw( const uDualClass &ex );
    static void Throw( const uThrowClass &ex ) {
	Throw( (const uDualClass &)ex );
	// CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
	assert( false );
#endif // __U_DEBUG__
    } // uEHM::Throw
    static void Throw( const uThrowClass &ex, uBaseCoroutine &target ) {
	Throw( (const uDualClass &)ex, target );
	// CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
	assert( false );
#endif // __U_DEBUG__
    } // uEHM::Throw
    static void Throw( const uDualClass &ex, uBaseCoroutine &target ) {
	asyncToss( ex, target, uThrowF );
    } // uEHM::Throw
    static void Throw( uBaseCoroutine &target ) {	// asynchronous rethrow
	asyncReToss( target, uThrowF );
    } // uEHM::Throw
    static void ReThrow() __attribute__(( noreturn ));

    static void Resume( const uDualClass &ex );
    static void Resume( const uResumeClass &ex ) {
	Resume( (const uDualClass &)ex );
    } // uEHM::Resume
    static void Resume( const uResumeClass &ex, uBaseCoroutine &target ) {
	Resume( (const uDualClass &)ex, target );
    } // uEHM::Resume
    static void Resume( const uDualClass &ex, uBaseCoroutine &target ) {
	asyncToss( ex, target, uResumeF );
    } // uEHM::Resume
    static void Resume( uBaseCoroutine &target ) {	// asynchronous reraise
	asyncReToss( target, uResumeF );
    } // uEHM::Resume
    static void ReResume();

    static bool poll();
    static const std::type_info *getTopResumptionType();
    static uDualClass *getCurrentException();
    static uEHM::uDualClass *getCurrentResumption();
    static char *getCurrentEventName( raiseKind, char *s1, size_t n );
    static char *strncpy( char *s1, const char *s2, size_t n );
  private:
    static void resumeWorkHorse( const uDualClass &, const bool );
}; // uEHM


//######################### uEHM::AsyncEMsg ########################


class uEHM::AsyncEMsg : public uSeqable {
    friend class uEHM;
    friend class uEHM::AsyncEMsgBuffer;
    friend void uEHM::Throw( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::Throw( const uThrowClass &, uBaseCoroutine & );
    friend void uEHM::Resume( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::Resume( const uResumeClass &, uBaseCoroutine & );
    friend bool uEHM::poll();

    const raiseKind flag;
    bool hidden;
    uDualClass *asyncEvent;

    AsyncEMsg &operator=( const AsyncEMsg & );
    AsyncEMsg( const AsyncEMsg & );

    AsyncEMsg( const uDualClass &ex, const raiseKind f );
  public:
    ~AsyncEMsg();
}; // uEHM::AsyncEMsg


//######################### uEHM::AsyncEMsgBuffer ########################


// AsyncEMsgBuffer looks like public uQueue<AsyncEMsg> but with mutex

class uEHM::AsyncEMsgBuffer : public uSequence<uEHM::AsyncEMsg> {
    friend bool uEHM::poll();				// access lock
    friend class uTaskMain;
    friend class uCoroutineMain;

    AsyncEMsgBuffer( const AsyncEMsgBuffer & );
    AsyncEMsgBuffer& operator=( const AsyncEMsgBuffer & );
  public:
    uSpinLock lock;
    AsyncEMsgBuffer();
    ~AsyncEMsgBuffer();
    void uAddMsg( AsyncEMsg *msg );
    AsyncEMsg *uRmMsg();
    AsyncEMsg *uRmMsg( AsyncEMsg *msg );
    AsyncEMsg *nextVisible( AsyncEMsg *msg );
}; // uEHM::AsyncEMsgBuffer


//######################### uEHM::uDualClass ########################


class uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::AsyncEMsg;
    friend void uEHM::Throw( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::Throw( const uDualClass & );
    friend void uEHM::Resume( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::Resume( const uDualClass & );
    friend bool uEHM::poll();
    friend void uEHM::resumeWorkHorse( const uDualClass &, const bool );
  protected:
    const uBaseCoroutine *src;				// set at raise
    char srcName[uEHMMaxName + sizeof("...")];		// room for "...\0"
    char msg[uEHMMaxMsg];

    mutable const void *staticallyBoundObject;

    void setSrc( uBaseCoroutine & );
    const std::type_info *getEventType() const { return &typeid( *this ); };

    virtual void stackThrow() const = 0;		// translator generated => object specific
  public:
    uDualClass( const char *const msg = "" );
    virtual ~uDualClass();

    const char *message() const;
    const uBaseCoroutine &source() const;
    const char *sourceName() const;
    virtual uDualClass *duplicate() const = 0;		// translator generated => object specific
    virtual void defaultTerminate() const;
    virtual void defaultTerminate();
    virtual void defaultResume() const;
    virtual void defaultResume();

    // These members should be private but cannot be because they are
    // referenced from user code.

    const void *getOriginalThrower() const { return staticallyBoundObject; }
    const uDualClass &setOriginalThrower( const void *p ) const;

    void Resume() const { uEHM::resumeWorkHorse( *this, true ); }
    void Resume( uBaseCoroutine &target ) const { uEHM::asyncToss( *this, target, uResumeF ); }

    void Throw () const { uEHM::Throw( *this ); }
    void Throw ( uBaseCoroutine &target) const { uEHM::Throw( *this, target ); }
}; // uEHM::uDualClass


//######################### uEHM::uThrowClass ########################


// uThrowClass is the root class of all throwable exception-types

class uEHM::uThrowClass : protected uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::AsyncEMsg;			// enable conversion to uDualClass;
    friend void uEHM::Throw( const uThrowClass &, uBaseCoroutine & );
    friend void uEHM::Throw( const uThrowClass & );

#ifdef __DEBUG__
    virtual void defaultResume() const;
    virtual void defaultResume();
#endif // __DEBUG__
  protected:
    virtual void stackThrow() const = 0;		// translator generated => object specific
  public:
    uThrowClass( const char *const msg = "" );
    virtual ~uThrowClass();

    const uEHM::uThrowClass &setOriginalThrower( const void *p ) const {
	staticallyBoundObject = p;
	return *this;
    } // uEHM::uThrowClass::setOriginalThrower

    uEHM::uDualClass::message;				// pass through from uDualClass
    uEHM::uDualClass::source;
    uEHM::uDualClass::sourceName;
    virtual uDualClass *duplicate() const = 0;		// translator generated => object specific
    uEHM::uDualClass::defaultTerminate;

    uEHM::uDualClass::getOriginalThrower;
    uEHM::uDualClass::Throw;
}; // uEHM::uThrowClass


//######################### uEHM::uResumeClass ########################


class uEHM::uResumeClass : protected uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::AsyncEMsg;
    friend void uEHM::Resume( const uResumeClass &, uBaseCoroutine & );
    friend void uEHM::Resume( const uResumeClass & );

#ifdef __DEBUG__
    virtual void defaultTerminate() const;
    virtual void defaultTerminate();
#endif // __DEBUG__
  protected:
    virtual void stackThrow() const __attribute__(( noreturn )); // translator generated => object specific
  public:
    uResumeClass( const char *const msg = "" );
    virtual ~uResumeClass();

    const uEHM::uResumeClass &setOriginalThrower( const void *p ) const {
	staticallyBoundObject = p;
	return *this;
    } // uEHM::uResumeClass::setOriginalThrower

    uEHM::uDualClass::message;				// pass through from uDualClass
    uEHM::uDualClass::source;
    uEHM::uDualClass::sourceName;
    virtual uDualClass *duplicate() const = 0;		// translator generated => object specific
    virtual void defaultResume() const;			// calls uTerminate
    virtual void defaultResume();

    uEHM::uDualClass::getOriginalThrower;
    uEHM::uDualClass::Resume;
}; // uEHM::uResumeClass


//######################### internal class and function declarations ########################


// base class allowing a list of otherwise-heterogeneous uHandlerClauses
class uEHM::uHandlerBase {
    void *const matchBinding;
    const std::type_info *eventType;
  protected:
    uHandlerBase( void *matchBinding, const std::type_info *eventType ) : matchBinding( matchBinding ), eventType( eventType ) {}
    virtual ~uHandlerBase() {}
  public:
    virtual void uHandler( uEHM::uDualClass &exn ) = 0;
    void *getMatchBinding() const { return matchBinding; }
    const std::type_info *getEventType() const { return eventType; }
}; // uHandlerBase

template< typename Exn >
class uNullHandlerClause : public uEHM::uHandlerBase {
  public:
    uNullHandlerClause( void *originalThrower ) : uHandlerBase( originalThrower, &typeid( Exn ) ) {}
    virtual void uHandler( uEHM::uDualClass &exn ) {}
}; // uNullHandlerClause

template< typename Exn, typename Functor >
class uHandlerClause : public uEHM::uHandlerBase {
    Functor &functor;
  public:
    uHandlerClause( void *originalThrower, Functor &functor ) : uHandlerBase( originalThrower, &typeid( Exn ) ), functor( functor ) {}
    virtual void uHandler( uEHM::uDualClass &exn ) { functor( (Exn &)exn ); }
}; // uHandlerClause

// handlers for try < ... >

template< typename Functor >
class uAnyHandlerClause : public uEHM::uHandlerBase {
    Functor &functor;
  public:
    uAnyHandlerClause( void *dummy, Functor &functor ) : uHandlerBase ( 0, 0 ), functor( functor ) {}; // no binding possible, no id address either
    virtual void uHandler( uEHM::uDualClass & ) { functor(); } // NOTE: functor operator has no parameters
}; // uAnyHandlerClause

class uAnyNullHandlerClause : public uEHM::uHandlerBase {
   public:
    uAnyNullHandlerClause( void *dummy ) : uHandlerBase ( 0, 0 ) {}; // no binding possible, no id address either
    virtual void uHandler( uEHM::uDualClass & ) {}
}; // uAnyNullHandlerClause


// Every set of resuming handlers bound to a template try block is saved in a
// uEHM::uResumptionHandlers object. The resuming handler hierarchy is
// implemented as a linked list.

class uEHM::uResumptionHandlers {
    friend void uEHM::resumeWorkHorse( const uDualClass &, const bool );

    uResumptionHandlers *next, *conseqNext;		// uNext maintains a proper stack, while uConseqNext is used to skip
							// over handlers that have already been examined for resumption (to avoid recursion)

    const unsigned int size;				// number of handlers
    uHandlerBase *const *table;				// pointer to array of resumption handlers

    uResumptionHandlers( const uResumptionHandlers & );	// no copy
    uResumptionHandlers &operator=( const uResumptionHandlers & ); // no assignment
  public:
    uResumptionHandlers( uHandlerBase *const table[], const unsigned int size );
    ~uResumptionHandlers();
}; // uEHM::uResumptionHandlers


// The following actually implements a linked list of event_id's table.  Used
// in enable and disable block.

class uEHM::uDeliverEStack {
    friend bool uEHM::deliverable_exception( const std::type_info * );

    uDeliverEStack *next;
    bool deliverFlag;					// true when events in table is Enable, otherwise false
    int  table_size;                                    // number of events in the table, 0 implies everything
    const std::type_info **event_table;			// event id table

    uDeliverEStack( uDeliverEStack & );			// no copy
    uDeliverEStack &operator=( uDeliverEStack & );	// no assignment
  public:
    uDeliverEStack( bool f, const std::type_info **t = NULL, unsigned int msg = 0 ); // for enable and disable blocks
    ~uDeliverEStack();
}; // uEHM::uDeliverEStack


#endif // __U_EHM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
