//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Russell Mok 1997
// 
// uEHM.cc -- 
// 
// Author           : Russell Mok
// Created On       : Sun Jun 29 00:15:09 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Sep 24 19:00:42 2006
// Update Count     : 524
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>

#include <cxxabi.h>
#include "unwind-cxx.h"					// include file copied from gcc 3.4, needed for reraise from a catch-any
#include <cstring>					// strlen, strncpy, strcpy

#if __GNUC__ == 3 && __GNUC_MINOR__ < 4 && !defined( __INTEL_COMPILER ) // TEMPORARY: bug in uncaught_exception, correction copied from gcc 3.4
// Copyright (C) 2001 Free Software Foundation, Inc.
namespace __cxxabiv1 {
    // Returns the type_info for the currently handled exception [15.3/8], or
    // null if there is none.
    extern "C" void *
    __cxa_begin_catch (void *exc_obj_in) throw()
    {
	_Unwind_Exception *exceptionObject
	    = reinterpret_cast <_Unwind_Exception *>(exc_obj_in);
	__cxa_eh_globals *globals = __cxa_get_globals ();
	__cxa_exception *prev = globals->caughtExceptions;
	__cxa_exception *header = __get_exception_header_from_ue (exceptionObject);

	// Foreign exceptions can't be stacked here.  If the exception stack is
	// empty, then fine.  Otherwise we really have no choice but to terminate.
	// Note that this use of "header" is a lie.  It's fine so long as we only
	// examine header->unwindHeader though.
	if (header->unwindHeader.exception_class != __gxx_exception_class)
	    {
		if (prev != 0)
		    std::terminate ();

		// Remember for end_catch and rethrow.
		globals->caughtExceptions = header;

		// ??? No sensible value to return; we don't know what the 
		// object is, much less where it is in relation to the header.
		return 0;
	    }

	int count = header->handlerCount;
	if (count < 0)
	    // This exception was rethrown from an immediately enclosing region.
	    count = -count + 1;
	else
	    {
		count += 1;
		globals->uncaughtExceptions -= 1;
	    }
	header->handlerCount = count;

	if (header != prev)
	    {
		header->nextException = prev;
		globals->caughtExceptions = header;
	    }

	return header->adjustedPtr;
    }
} // namespace __cxxabiv1
#endif // __GNUC__ == 3 && __GNUC_MINOR__ < 4 && ! __INTEL_COMPILER


//######################### std::{C++ exception routines} ########################


void uEHM::terminate() {
    char ExName[uEHMMaxName + sizeof("...")];		// room for "...\0"
    char ResName[uEHMMaxName + sizeof("...")];

    getCurrentEventName( uThrowF, ExName, uEHMMaxName );
    getCurrentEventName( uResumeF, ResName, uEHMMaxName );

    bool exception = ExName[0] != '\0';			// optimization
    bool resumption = ResName[0] != '\0';
    
    if ( ! exception && ! resumption ) {
	uAbort( "Attempt to rethrow/reraise but no active exception.\n"
		"Possible cause is a rethrow/reraise not directly or indirectly performed from a catch clause." );
    } // if
    
    uAbort( "%s%s%s%s%s%s",
	    ( uThisCoroutine().unexpected ?
	      "Exception propagated through a function whose exception-specification does not permit exceptions of that type.\n" :
	      "Propagation failed to find a matching handler.\n"
	      "Possible cause is a missing try block with appropriate catch clause for specified or derived exception type\n"
	      "or throwing an exception from within a destructor while propagating an exception.\n" ),
	    (exception  ? "Type of last active exception: "  : ""), (exception  ? ExName  : ""), (exception && resumption ? "\n" : ""),
	    (resumption ? "Type of last active resumption: " : ""), (resumption ? ResName : "") ); // uAbort puts a "\n"
} // uEHM::terminate

void uEHM::terminateHandler() {
    try {
	(*uThisTask().terminateRtn)();
	uEHM::terminate();
    } catch( ... ) {
	uEHM::terminate();
    } // try
} // uEHM::terminateHandler

void uEHM::unexpected() {
    uThisCoroutine().unexpected = true;
    std::terminate();
} // uEHM::unexpected

void uEHM::unexpectedHandler() {
    (*uThisCoroutine().unexpectedRtn)();
    std::terminate();
} // uEHM::unexpectedHandler

std::terminate_handler std::set_terminate( std::terminate_handler func ) throw() {
    uBaseTask &task = uThisTask();
    std::terminate_handler prev = task.terminateRtn;
    task.terminateRtn = func;
    return prev;
} // std::set_terminate

std::unexpected_handler std::set_unexpected( std::unexpected_handler func ) throw() {
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    std::unexpected_handler prev = coroutine.unexpectedRtn;
    coroutine.unexpectedRtn = func;
    return prev;
} // std::set_unexpected


//######################### uEHM::AsyncEMsg ########################


uEHM::AsyncEMsg::AsyncEMsg( const uDualClass &ex, const raiseKind f ) : flag( f ), hidden( false ) {
    asyncEvent = ex.duplicate();
} // uEHM::AsyncEMsg::AsyncEMsg

uEHM::AsyncEMsg::~AsyncEMsg() {
    delete asyncEvent;
} // uEHM::AsyncEMsg::~AsyncEMsg


//######################### uEHM::AsyncEMsgBuffer ########################


// msg queue for nonlocal exceptions in a coroutine

uEHM::AsyncEMsgBuffer::AsyncEMsgBuffer() {
} // AsyncEMsgBuffer::AsyncEMsgBuffer

uEHM::AsyncEMsgBuffer::~AsyncEMsgBuffer() {
    uCSpinLock dummy( lock );
    for ( AsyncEMsg *tmp = drop(); tmp; tmp = drop() ) {
	delete tmp;
    } // for
} // uEHM::AsyncEMsgBuffer::~AsyncEMsgBuffer

void uEHM::AsyncEMsgBuffer::uAddMsg( AsyncEMsg *msg ) {
    uCSpinLock dummy( lock );
    add( msg );
} // uEHM::AsyncEMsgBuffer::uAddMsg

uEHM::AsyncEMsg *uEHM::AsyncEMsgBuffer::uRmMsg() {
    uCSpinLock dummy( lock );
    return drop();
} // uEHM::AsyncEMsgBuffer::uRmMsg

uEHM::AsyncEMsg *uEHM::AsyncEMsgBuffer::uRmMsg( AsyncEMsg *msg ) {
    // Only lock at the end or the start of the list as these are the only
    // places where interference can occur.

    if ( msg == tail() || msg == head() ) {
	uCSpinLock dummy( lock );
	remove( msg );
    } else {
	remove( msg );
    } // if
    return msg;
} // uEHM::AsyncEMsgBuffer::uRmMsg

uEHM::AsyncEMsg *uEHM::AsyncEMsgBuffer::nextVisible( AsyncEMsg *msg ) {
    // find the next msg node that is visible or null
    do {						// do-while because current node could be visible
	msg = succ( msg );
    } while ( msg && msg->hidden );
    return msg;
} // uEHM::AsyncEMsgBuffer::nextVisible


//######################### uDualClass ########################


uEHM::uDualClass::uDualClass( const char *const msg ) : src( NULL ) {
    strncpy( uEHM::uDualClass::msg, msg, uEHMMaxMsg );	// copy message
}; // uEHM::uDualClass::uDualClass

uEHM::uDualClass::~uDualClass() {}

const char *uEHM::uDualClass::message() const { return msg; }
const uBaseCoroutine &uEHM::uDualClass::source() const { return *src; }
const char *uEHM::uDualClass::sourceName() const { return src != NULL ? srcName : "*unnamed*"; }

void uEHM::uDualClass::setSrc( uBaseCoroutine &cor ) {
    src = &cor;
    strncpy( srcName, cor.getName(), uEHMMaxName );	// copy source name
} // uEHM::uDualClass::setSrc

const uEHM::uDualClass &uEHM::uDualClass::setOriginalThrower( const void * p ) const {
    staticallyBoundObject = p;
    return *this;
} // uEHM::uDualClass::setOriginalThrower

void uEHM::uDualClass::defaultTerminate() const {
} // uEHM::uDualClass::defaultTerminate

void uEHM::uDualClass::defaultTerminate() {
    const_cast<const uDualClass *>(this)->defaultTerminate();
} // uEHM::uDualClass::defaultTerminate

void uEHM::uDualClass::defaultResume() const {
    stackThrow();
    // CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
    assert( false );
#endif // __U_DEBUG__
} // uEHM::uDualClass::defaultResume

void uEHM::uDualClass::defaultResume() {
    const_cast<const uDualClass *>(this)->defaultResume();
} // uEHM::uDualClass::defaultResume


//######################### uEHM::uThrowClass ########################


uEHM::uThrowClass::uThrowClass( const char *const msg ) : uDualClass( msg ) {}
uEHM::uThrowClass::~uThrowClass() {}

#ifdef __DEBUG__
void uEHM::uThrowClass::defaultResume() const {
    uAbort( "uThrowClass object cannot be casted to a raise-able object." );
} // uEHM::uThrowClass::defaultResume

void uEHM::uThrowClass::defaultResume() {
    const_cast<const uThrowClass *>(this)->defaultResume();
} // uEHM::uThrowClass::defaultResume
#endif // __DEBUG__


//######################### uEHM::uResumeClass ########################


void uEHM::uResumeClass::stackThrow() const {
    uAbort( "uResumeClass object cannot be thrown." );
} // uEHM::uResumeClass::stackThrow

uEHM::uResumeClass::uResumeClass( const char *const msg ) : uDualClass( msg ) {}
uEHM::uResumeClass::~uResumeClass() {}

#ifdef __DEBUG__
void uEHM::uResumeClass::defaultTerminate() const {
    uAbort( "uResumeClass object cannot be casted to a throw-able object." );
} // uEHM::uResumeClass::defaultTerminate

void uEHM::uResumeClass::defaultTerminate() {
    const_cast<const uResumeClass *>(this)->defaultTerminate();
} // uEHM::uResumeClass::defaultTerminate
#endif // __DEBUG__

void uEHM::uResumeClass::defaultResume() const {
    terminate();
} // uEHM::uResumeClass::defaultResume

void uEHM::uResumeClass::defaultResume() {
    const_cast<const uResumeClass *>(this)->defaultResume();
} // uEHM::uResumeClass::defaultResume


//######################### uEHM::uResumptionHandlers ########################


uEHM::uResumptionHandlers::uResumptionHandlers( uHandlerBase *const table[], const unsigned int size ) : size( size ), table( table ) {
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    next = coroutine.handlerStackTop;
    conseqNext = coroutine.handlerStackVisualTop;
    coroutine.handlerStackTop = this;
    coroutine.handlerStackVisualTop = this;
} // uEHM::uResumptionHandlers::uResumptionHandlers

uEHM::uResumptionHandlers::~uResumptionHandlers() {
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    coroutine.handlerStackTop = next;
    coroutine.handlerStackVisualTop = conseqNext;
} // uEHM::uResumptionHandlers::~uResumptionHandlers


//######################### uEHM::uDeliverEStack ########################


uEHM::uDeliverEStack::uDeliverEStack( bool f, const std::type_info **t, unsigned int msg ) : deliverFlag( f ), table_size( msg ), event_table( t ) {
    // the current node applies to all exceptions when table_size is 0
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    next = coroutine.DEStack;
    coroutine.DEStack = this;
} // uEHM::uDeliverEStack::uDeliverEStack

uEHM::uDeliverEStack::~uDeliverEStack() {
    uThisCoroutine().DEStack = next;
} // uEHM::uDeliverEStack::~uDeliverEStack


//######################### uEHM::ResumeWorkHorseInit ########################


// Initialization and finalization when handling a signalled event after
// finding a handler. This ensures the two different resuming handler
// hierarchies are properly maintained.  As well, it maintains the currently
// handled resumption object for reraise.

class uEHM::ResumeWorkHorseInit {
    uResumptionHandlers *prevVisualTop;
    uDualClass *prevResumption;
  public:
    ResumeWorkHorseInit( uResumptionHandlers *h, uDualClass & newResumption ) {
	uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
	prevResumption = coroutine.resumedObj;
	coroutine.resumedObj = &newResumption;
	coroutine.topResumedType = &typeid(newResumption);
	uBaseCoroutine &current = coroutine;
	prevVisualTop = current.handlerStackVisualTop;
	current.handlerStackVisualTop = h;
    } // uEHM::ResumeWorkHorseInit::resumeWorkHorse

    ~ResumeWorkHorseInit() {
	uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
	coroutine.resumedObj = prevResumption;
	if ( ! std::uncaught_exception() ) {		// update top, unless it's a forceful unwind
	    coroutine.topResumedType = prevResumption ? &typeid(prevResumption) : NULL;
	} // if
	coroutine.handlerStackVisualTop = prevVisualTop;
    } // uEHM::ResumeWorkHorseInit::~resumeWorkHorse
}; // uEHM::ResumeWorkHorseInit


//######################### uEHM::AutoResourceCleanup ########################

// Used by poll to ensure a handled message is removed from the queue and its
// memory deallocated. These actions are done in the destructor to ensure the
// clean-up is performed even when an exception is thrown.  Unwinding the stack
// causes the AutoResourceCleanup object to be destroyed and hence the
// destructor to be called.

class uEHM::AutoResourceCleanup {
    AsyncEMsg *msg;
    AsyncEMsgBuffer &buf;
  public:
    AutoResourceCleanup( AsyncEMsg *msg, AsyncEMsgBuffer &buf ) : msg( msg ), buf( buf ) {}

    ~AutoResourceCleanup() {
	buf.uRmMsg(msg);
	delete msg;
    } // uEHM::AutoResourceCleanup::~AutoResourceCleanup
}; // uEHM::AutoResourceCleanup


//######################### uEHM ########################


#ifdef __U_DEBUG__
static void Check( uBaseCoroutine &target, const char *kind ) {
    if ( &target == NULL || &target == (uBaseCoroutine *)-1 || *((void **)&target) == NULL || *((void **)&target) == (void *)-1 ) {
	uAbort( "Attempt by task %.256s (0x%p) to %s a nonlocal exception at target 0x%p, but the target is invalid or has been deleted",
		uThisTask().getName(), &uThisTask(), kind, &target );
    } // if
} // Check
#endif // __U_DEBUG__


void uEHM::asyncToss( const uDualClass &ex, uBaseCoroutine &target, raiseKind f, bool rethrow ) {
#ifdef __U_DEBUG__
    Check( target, f == uResumeF ? "resume" : "throw" );
#endif // __U_DEBUG__

    if ( target.getState() != uBaseCoroutine::Halt ) {
	AsyncEMsg *temp = new AsyncEMsg( ex, f );
	uBaseCoroutine &cor = uThisCoroutine();
	if ( ! rethrow ) {				// reset current raiser ?
	    temp->asyncEvent->setOriginalThrower( (void *)&cor );
	    temp->asyncEvent->setSrc( cor );
	} // if
	target.asyncEBuf.uAddMsg( temp );
    } // if
} // uEHM::asyncToss

void uEHM::asyncReToss( uBaseCoroutine &target, raiseKind f ) {
    uDualClass *r;

    if (f == uResumeF) {
	r = getCurrentResumption();
	if ( r == NULL ) {
	    r = getCurrentException();
	}//if
    } else {
	r = getCurrentException();
	if ( r == NULL ) {
	    r = getCurrentResumption();
	} // if
    } // if
    
    if ( r == NULL ) {					// => there is nothing to resume => terminate
	terminateHandler();
    } else {
	asyncToss( *r, target, f, true );
    } // if
} // uEHM::asyncReToss


void uEHM::Throw( const uDualClass &ex ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uEHM::Throw( uDualClass::ex:0x%p ) from task %.256s (0x%p)\n", &ex, uThisTask().getName(), &uThisTask() );
#endif // __U_DEBUG_H__
    ex.stackThrow();
    // CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
    assert( false );
#endif // __U_DEBUG__
} // uEHM::Throw

void uEHM::ReThrow() {
    uDualClass *e = getCurrentException();		// optimization
    if ( e == NULL ) {
	e = getCurrentResumption();
    } // if

    if ( e != NULL ) {
	e->stackThrow();
    } // if
    throw;
} // uEHM::ReThrow


void uEHM::Resume( const uDualClass &ex ) {
    resumeWorkHorse( ex, true );
} // uEHM::Resume

void uEHM::ReResume() {
    uDualClass *r = getCurrentResumption();		// optimization

    if ( r == NULL ) {
	r = getCurrentException();
    } // if

    if ( r == NULL ) {					// => there is nothing to resume => terminate
	terminateHandler();
    } else {						// => there is something to resume
	resumeWorkHorse( *r, true );	
    } // if
}; // uEHM::ReResume


// Check for and handle pending nonlocal exceptions.

bool uEHM::poll() {
    uBaseCoroutine &cor = uThisCoroutine();
  if ( cor.cancelInProgress() ) return false;		// skip async handling if cancelling
    if ( cor.getCancelState() != uBaseCoroutine::CancelDisabled && cor.cancelled() ) { // check for cancellation first, but only if it is enabled	
	cor.unwindStack();				// not cancelling, so unwind stack
	// CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
	assert( false );
#endif // __U_DEBUG__
    } // if

    AsyncEMsgBuffer &msgbuf = cor.asyncEBuf;
    AsyncEMsg *asyncMsg = msgbuf.head();		// find first node in queue

  if ( asyncMsg == NULL ) return false;

    if ( asyncMsg->hidden ) {
	asyncMsg = msgbuf.nextVisible( asyncMsg );	// from there, find first visible node
    } // if

    // For each visible node, check if responsible for its delivery. If yes,
    // hide it from any recursive poll call, handle the event, and remove it
    // from the queue through the automatic resource clean-up.

    while ( asyncMsg != NULL ) {
    	if ( deliverable_exception( asyncMsg->asyncEvent->getEventType() ) ) {
	    // Note, implicit context switches only call uYieldNoPoll(), hence
	    // poll can only be called from resumeWorkHorse again, which is a
	    // safe recursion.
	    asyncMsg->hidden = true;			// hide node from recursive children of poll
	    uDualClass *asyncEvent = asyncMsg->asyncEvent;
	    
	    // Recover memory allocated for async event message. Resuming
	    // handler should not destroyed raised exception regardless of
	    // whether the exception is normal or nonlocal.

	    AutoResourceCleanup dummy_var( asyncMsg, msgbuf ); // This ensures removal and deletion of the node at end of block.
	                                                       // Necessary because of return or throw.

	    if ( asyncMsg->flag == uThrowF ) {		// throw the event
		asyncEvent->stackThrow();
		// CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
		assert( false );
#endif // __U_DEBUG__
	    } // if
	    resumeWorkHorse( *asyncEvent, false );	// handle event, potential recursion! also potential exception
	    
	    asyncMsg = msgbuf.nextVisible( asyncMsg );	// advance to next visible node

	    return true;
	    // NOTE: E_MSG IS DESTROYED HERE !!
	} else {
	    asyncMsg = msgbuf.nextVisible( asyncMsg );	// advance to next visible node (without deleting)
	} // if
    } // while

    // NOTE: finalizer is destroyed here, sets the progress flag to its old
    // value, i.e., the first level turns it off

    return false;
} // uEHM::poll


uEHM::uDualClass *uEHM::getCurrentException() {
    __cxxabiv1::__cxa_eh_globals *globals = __cxxabiv1::__cxa_get_globals();
    if ( globals != NULL ) {
	__cxxabiv1::__cxa_exception *header = globals->caughtExceptions;	
	if ( header != NULL ) {			// handling an exception and want to turn it into resumption
	    return (uEHM::uDualClass*)((char *)header + sizeof(__cxxabiv1::__cxa_exception)); 
	} // if
    } // if
    return NULL;
} // uEHM::getCurrentException

uEHM::uDualClass *uEHM::getCurrentResumption() {
    return uThisCoroutine().resumedObj;			// optimization
} // uEHM::getCurrentResumption

const std::type_info * uEHM::getTopResumptionType() {
    return uThisCoroutine().topResumedType;
} // uEHM::getCurrentResumptionType()


char *uEHM::getCurrentEventName( raiseKind f, char *s1, size_t n ) {
    const std::type_info *t;

    if ( f == uResumeF ) {
	t = uEHM::getTopResumptionType();
    } else {
	t = __cxxabiv1::__cxa_current_exception_type();
    } // if

    if ( t != NULL ) {
	int status;
	char *s2 = __cxxabiv1::__cxa_demangle( t->name(), 0, 0, &status );
	strncpy( s1, s2 ? s2 : "*unknown*", n );	// TEMPORARY: older g++ may generate a NULL name for elementary types
	free( s2 );
    } else {
	s1[0] = '\0';
    } // if
    return s1;
} // uEHM::getCurrentExceptionName


char *uEHM::strncpy( char *s1, const char *s2, size_t n ) {
    ::strncpy( s1, s2, n );
    if ( strlen( s2 ) > n ) {				// name too long ?
	strcpy( &s1[n], "..." );			// add 4 character ...
    } // if
    return s1;
} // uEHM::strncpy


bool uEHM::match_exception_type( const std::type_info *derived_type, const std::type_info *parent_type ) {
    // return true if derived_type event is derived from parent_type event
    void *dummy;
#ifdef __DEBUG__
    if ( ! parent_type ) uAbort( "internal error, error in setting up guarded region." );
#endif // __DEBUG__
    return parent_type->__do_catch( derived_type, &dummy, 0 );
} // uEHM::match_exception_type


bool uEHM::deliverable_exception( const std::type_info *event_type ) {
    for ( uDeliverEStack *tmp = uThisCoroutine().DEStack; tmp; tmp = tmp->next ) {
	if ( tmp->table_size == 0 ) {			// table_size == 0 is a short hand for all exceptions
	    return tmp->deliverFlag;
	} // if

	for ( int i = 0; i < tmp->table_size; i += 1 ) {
	    if ( match_exception_type( event_type, tmp->event_table[i] ) ) {
		return tmp->deliverFlag;
	    } // if
	} // for
    } // for
    return false;
} // uEHM::deliverable_exception


// Find and execute resumption handlers. If conseq == false, it means a
// non-consequential resumption (i.e., one newly raised outside of handling
// code) is being handled; hence, begin looking for handlers at the real top of
// the stack. If conseq == true, it means a consequential resumption is being
// handled, but in order to avoid recursive handling, should not consider
// earlier resumption handlers. In this case, the virtual top
// (handlerStackVisualTop) of the handler stack is used.

void uEHM::resumeWorkHorse( const uDualClass &ex, const bool conseq ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uEHM::resumeWorkHorse( ex:0x%p, conseq:%d ) from task %.256s (0x%p)\n",
	       &ex, conseq, uThisTask().getName(), &uThisTask() );
#endif // __U_DEBUG_H__

    const std::type_info *raisedtype = ex.getEventType();
    uResumptionHandlers *tmp = (conseq) ? uThisCoroutine().handlerStackVisualTop : uThisCoroutine().handlerStackTop;

    while ( tmp ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "uEHM::resumeWorkHorse tmp:0x%p, raisedtype:0x%p\n", tmp, raisedtype );
#endif // __U_DEBUG_H__

	uResumptionHandlers *next = (conseq) ? tmp->conseqNext : tmp->next;

	// search all resumption handlers in the same handler clause
	for ( unsigned int i = 0; i < tmp->size; i += 1 ) {
	    uHandlerBase *elem = tmp->table[i];		// optimization
	    const void *bound = ex.getOriginalThrower();
#ifdef __U_DEBUG_H__
	    uDebugPrt( "uEHM::resumeWorkHorse table[%d]:0x%p, originalThrower:0x%p, EventType:0x%p, bound:0x%p\n",
		       i, elem, elem->getOriginalThrower(), elem->EventType, bound );
#endif // __U_DEBUG_H__
	    // if (no binding OR binding match) AND (type match OR resume_any) => handler found
	    if ( ( elem->getMatchBinding() == NULL || bound == elem->getMatchBinding() ) &&
		 ( elem->getEventType() == NULL || match_exception_type( raisedtype, elem->getEventType() ) ) ) {
#ifdef __U_DEBUG_H__
		uDebugPrt( "uEHM::resumeWorkHorse match\n" );
#endif // __U_DEBUG_H__
		ResumeWorkHorseInit newStackVisualTop( next, (uDualClass &)ex );
		elem->uHandler( (uDualClass &)ex );
		return;					// return after handling the exception
	    } // if
	} // for
	tmp = next;					// next resumption handler clause
    } // while

    // cannot find a handler, use the default handler
    ResumeWorkHorseInit newStackVisualTop( NULL, (uDualClass &)ex ); // record the current resumption
    ex.defaultResume();					// default handler can change the exception
} // uEHM::resumeWorkHorse


// Local Variables: //
// compile-command: "gmake install" //
// End: //
