//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1997
// 
// uBaseCoroutine.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 27 16:46:37 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Sep 24 16:53:26 2006
// Update Count     : 457
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>


//######################### uBaseCoroutine #########################


// This routine must be called manually since our exception throwing interferes with normal deallocation
namespace __cxxabiv1 {
    extern "C" void __cxa_free_exception(void *vptr) throw();
} // namespace


uBaseCoroutine::UnwindStack::UnwindStack( bool e ) : exec_dtor( e ) {
} // uBaseCoroutine::UnwindStack::UnwindStack

uBaseCoroutine::UnwindStack::~UnwindStack() {
    if ( exec_dtor && ! std::uncaught_exception() ) { 	// if executed as part of an exceptional clean-up do nothing, otherwise terminate is called
	__cxxabiv1::__cxa_free_exception( this );	// if handler terminates and 'safety' is off, clean up the memory for old exception
	_Throw UnwindStack( true );			// and throw a new exception to continue unwinding
    } // if
} // uBaseCoroutine::UnwindStack::~UnwindStack


void uBaseCoroutine::unwindStack() {
    if ( ! _cancelInProgress ) {			// do not cancel if we're already cancelling
	_cancelInProgress = true;
	// NOTE: This throw fails and terminates the application if it occurs
	// in the middle of a destructor triggered by an exception.  While not
	// a serious restriction now, it could be one when time-slice polling
	// is introduced
	_Throw UnwindStack( true );			// start the cancellation unwinding
    } // if
} // uBaseCoroutine::unwindStack


void uBaseCoroutine::createCoroutine() {
    last = NULL;					// see ~uCoroutineDestructor
#ifdef __U_DEBUG__
    currSerialOwner = NULL;				// for error checking
    currSerialCount = 0;
#endif // __U_DEBUG__
    notHalted = true;					// must be a non-zero value so detectable after memory is scrubbed
    state = Inactive;

    // exception handling / cancellation

    handlerStackTop = handlerStackVisualTop = NULL;
    resumedObj = NULL;
    topResumedType = NULL;
    DEStack = NULL;
    unexpectedRtn = uEHM::unexpected;			// initialize default unexpected routine
    unexpected = false;

    _cancelled = false;
    _cancelInProgress = false;
    cancelState = CancelEnabled;
    cancelType = CancelPoll;				// not really used yet, but makes Pthread cancellation easier

    // profiling

    profileTaskSamplerInstance = NULL;
} // uBaseCoroutine::createCoroutine


uBaseCoroutine::uBaseCoroutine() : uMachContext( uThisCluster().getStackSize() ) {
    createCoroutine();
} // uBaseCoroutine::uBaseCoroutine


uBaseCoroutine::uBaseCoroutine( unsigned int stacksize ) : uMachContext( stacksize ) {
    createCoroutine();
} // uBaseCoroutine::uBaseCoroutine


void uBaseCoroutine::contextSw() {			// switch between a task and the kernel
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    uBaseTask &uCurrTask = uThisTask();

    if ( uCurrTask.profileActive && uProfiler::uProfiler_builtinRegisterTaskBlock ) { // uninterruptable hooks
	(*uProfiler::uProfiler_builtinRegisterTaskBlock)( uProfiler::profilerInstance, uCurrTask );
    } // if

    coroutine.setState( Inactive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.contextSw, coroutine:0x%p, coroutine.SP:0x%p, coroutine.storage:0x%p, storage:0x%p\n",
	       this, &coroutine, coroutine.stackPointer(), coroutine.storage, storage );
#endif // __U_DEBUG_H__
    coroutine.save();					// save user specified contexts

    uSwitch( coroutine.storage, storage );		// context switch to kernel
    coroutine.restore();				// restore user specified contexts
    coroutine.setState( Active );			// set state of new coroutine to active

    uCurrTask.setState( uBaseTask::Running );

    if ( uCurrTask.profileActive && uProfiler::uProfiler_builtinRegisterTaskUnblock ) { // uninterruptable hooks
	(*uProfiler::uProfiler_builtinRegisterTaskUnblock)( uProfiler::profilerInstance, uCurrTask );
    } // if
} // uBaseCoroutine::contextSw


void uBaseCoroutine::contextSw2() {			// switch between two coroutine contexts
    uBaseCoroutine &coroutine = uThisCoroutine();	// optimization
    uBaseTask &uCurrTask = uThisTask();

#ifdef __U_DEBUG__
    // reset task in current coroutine?
    if ( coroutine.currSerialCount == uCurrTask.currSerialLevel ) {
	coroutine.currSerialOwner = NULL;
    } // if
    
    // check and set for new owner
    if ( currSerialOwner != &uCurrTask ) {
	if ( currSerialOwner != NULL  ) {
	    if ( &currSerialOwner->getCoroutine() != this ) {
		uAbort( "Attempt by task %.256s (0x%p) to activate coroutine %.256s (0x%p) currently executing in a mutex object owned by task %.256s (0x%p).\n"
			"Possible cause is task attempting to logically change ownership of a mutex object via a coroutine.",
			uCurrTask.getName(), &uCurrTask, this->getName(), this, currSerialOwner->getName(), currSerialOwner );
	    } else {
		uAbort( "Attempt by task %.256s (0x%p) to resume coroutine %.256s (0x%p) currently being executed by task %.256s (0x%p).\n"
			"Possible cause is two tasks attempting simultaneous execution of the same coroutine.",
			uCurrTask.getName(), &uCurrTask, this->getName(), this, currSerialOwner->getName(), currSerialOwner );
	    } // if
	}  else {
	    currSerialOwner = &uCurrTask;
	    currSerialCount = uCurrTask.currSerialLevel;
	} // if
    } // if
#endif // __U_DEBUG__

    if ( uCurrTask.profileActive && uProfiler::uProfiler_registerCoroutineBlock ) {
	(*uProfiler::uProfiler_registerCoroutineBlock)( uProfiler::profilerInstance, uCurrTask, *this );
    } // if

    THREAD_GETMEM( This )->disableInterrupts();

    coroutine.setState( Inactive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.contextSw2, coroutine:0x%p, coroutine.SP:0x%p\n",
	       this, &coroutine, coroutine.stackPointer() );
#endif // __U_DEBUG_H__
    coroutine.save();					// save user specified contexts
    uCurrTask.currCoroutine = this;			// set new coroutine that task is executing

#if defined( __U_MULTI__ ) && defined( __U_SWAPCONTEXT__ )
#if defined( __linux__ ) && defined( __i386__ )
#if ! defined( __U_PTHREAD__ )
    ((ucontext_t *)(storage))->uc_mcontext.gregs[REG_GS] = THREAD_GETMEM( ldtValue );
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __x86_64__ )
#if ! defined( __U_PTHREAD__ )
    #error uC++ : internal error, unsupported architecture
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __ia64__ )
    ((ucontext_t *)(storage))->uc_mcontext.sc_gr[13] = (unsigned long)THREAD_GETMEM( threadPointer );
#elif defined( __solaris__ ) && defined( __sparc__ ) && ! defined( __U_PTHREAD__ )
    ((ucontext_t *)(storage))->uc_mcontext.gregs[REG_G7] = (int)(THREAD_GETMEM( This ) );
#elif defined( __irix__ ) && defined( __mips__ )
    // No thread register => nothing needs to be set in the mcontext
#elif defined( __freebsd__ ) && defined( __i386__ )
    ((ucontext_t *)storage)->uc_mcontext.mc_gs = THREAD_GETMEM( ldtValue );
#else
    #error uC++ : internal error, unsupported architecture
#endif
#ifdef __U_ONETIMER__
    if ( &uThisProcessor() == uKernelModule::systemProcessor ) {
	sigdelset( (sigset_t *)&(((ucontext_t *)(storage))->uc_sigmask), SIGALRM );
    } else {
	sigaddset( (sigset_t *)&(((ucontext_t *)(storage))->uc_sigmask), SIGALRM );
    } // if
#endif // __U_ONETIMER__
#endif // __U_MULTI__ && __U_SWAPCONTEXT__
#if  defined( __U_MULTI__ ) && defined( __U_ONETIMER__ ) && defined( __ia64__ )
    if ( &uThisProcessor() == uKernelModule::systemProcessor ) {
	sigdelset( &((uContext_t *)(storage))->sigMask, SIGALRM );
    } else {
	sigaddset( &((uContext_t *)(storage))->sigMask, SIGALRM );
    } // if
#endif // __U_MULTI__ && __U_ONETIMER__ && __ia64__

    uSwitch( coroutine.storage, storage );		// context switch to specified coroutine
    coroutine.restore();				// restore user specified contexts
    coroutine.setState( Active );			// set state of new coroutine to active

    THREAD_GETMEM( This )->enableInterrupts();

    // also appears in uCoroutineMain::uCoroutineMain
    if ( uCurrTask.profileActive && uProfiler::uProfiler_registerCoroutineUnblock ) {
	(*uProfiler::uProfiler_registerCoroutineUnblock)( uProfiler::profilerInstance, uCurrTask );
    } // if
} // uBaseCoroutine::contextSw2


void uBaseCoroutine::corFinish() {			// resumes the coroutine that first resumed this coroutine
    notHalted = false;
#ifdef __U_DEBUG__
    if ( ! _starter->notHalted ) {			// check if terminated
	    uAbort( "Attempt by coroutine %.256s (0x%p) to resume back to terminated starter coroutine %.256s (0x%p).\n"
		    "Possible cause is terminated coroutine's main routine has already returned.",
		    uThisCoroutine().getName(), &uThisCoroutine(), _starter->getName(), _starter );
    } // if
#endif // __U_DEBUG__
    _starter->contextSw2();
    // CONTROL NEVER REACHES HERE!
#ifdef __U_DEBUG__
    assert( false );
#endif // __U_DEBUG__
} // uBaseCoroutine::corFinish


void uBaseCoroutine::resume() {				// restarts the coroutine's main where last suspended
    uBaseCoroutine &c = uThisCoroutine();		// optimization

    if ( &c != this ) {					// resume to oneself ?
#ifdef __U_DEBUG__
        if ( ! notHalted ) {				// check if terminated
	    uAbort( "Attempt by coroutine %.256s (0x%p) to resume terminated coroutine %.256s (0x%p).\n"
		    "Possible cause is terminated coroutine's main routine has already returned.",
		    c.getName(), &c, getName(), this );
	} // if
#endif // __U_DEBUG__
	last = &c;
	contextSw2();
    } // if
    _Enable <uBaseCoroutine::Failure>;			// implicit poll
} // uBaseCoroutine::resume


void uBaseCoroutine::suspend() {			// restarts the coroutine that most recently resumed this coroutine
#ifdef __U_DEBUG__
    if ( last == NULL ) {
	uAbort( "Attempt to suspend coroutine %.256s (0x%p) that has never been resumed.\n"
		"Possible cause is a suspend executed in a member called by a coroutine user rather than by the coroutine main.",
		getName(), this );
    } // if
    if ( ! last->notHalted ) {				// check if terminated
	    uAbort( "Attempt by coroutine %.256s (0x%p) to suspend back to terminated coroutine %.256s (0x%p).\n"
		    "Possible cause is terminated coroutine's main routine has already returned.",
		    uThisCoroutine().getName(), &uThisCoroutine(), last->getName(), last );
    } // if
#endif // __U_DEBUG__
    last->contextSw2();
    _Enable <uBaseCoroutine::Failure>;			// implicit poll
} // uBaseCoroutine::suspend


const char *uBaseCoroutine::setName( const char *name ) {
    const char *prev = name;
    uBaseCoroutine::name = name;

    if ( uThisTask().profileActive && uProfiler::uProfiler_registerSetName ) { 
	(*uProfiler::uProfiler_registerSetName)( uProfiler::profilerInstance, *this, name ); 
    } // if
    return prev;
} // uBaseCoroutine::setName

const char *uBaseCoroutine::getName() const {
    // storage might be uninitialized or scrubbed
    return ( name == NULL || name == (const char *)-1 ) ? "*unknown*" : name;
} // uBaseCoroutine::getName


void uBaseCoroutine::setCancelState( CancellationState state ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( "Attempt to set the cancellation state of coroutine %.256s (0x%p) by coroutine %.256s (0x%p).\n"
		"A coroutine/task may only change its own cancellation state.",
		getName(), this, uThisCoroutine().getName(), &uThisCoroutine() );
    } // if
#endif // __U_DEBUG__
    cancelState = state;
} // uBaseCoroutine::setCancelState

void uBaseCoroutine::setCancelType( CancellationType type ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( "Attempt to set the cancellation state of coroutine %.256s (0x%p) by coroutine %.256s (0x%p).\n"
		"A coroutine/task may only change its own cancellation state.",
		getName(), this, uThisCoroutine().getName(), &uThisCoroutine() );
    } // if
#endif // __U_DEBUG__
    cancelType = type;
} // uBaseCoroutine::setCancelType


uBaseCoroutine::Failure::Failure( const char *const msg ) : uKernelFailure( msg ) {
} // uBaseCoroutine::Failure::Failure

uBaseCoroutine::Failure::~Failure() {
} // uBaseCoroutine::Failure::~Failure

void uBaseCoroutine::Failure::defaultTerminate() const {
    uAbort( "(uBaseCoroutine &)0x%p : %.256s.", &uThisCoroutine(), message() );
} // uBaseCoroutine::Failure::defaultTerminate


uBaseCoroutine::UnHandledException::UnHandledException( const char *const msg ) : Failure( msg ), origFailedCor( uThisCoroutine() ) {
    multiple = false;
    uEHM::strncpy( origFailedCorName, origFailedCor.getName(), uEHMMaxName );
} // uBaseCoroutine::Failure::Failure

uBaseCoroutine::UnHandledException::~UnHandledException() {
} // uBaseCoroutine::Failure::~Failure

const uBaseCoroutine &uBaseCoroutine::UnHandledException::origSource() const {
    return origFailedCor;
} // uBaseCoroutine::origSource

const char *uBaseCoroutine::UnHandledException::origName() const {
    return origFailedCorName;
} // uBaseCoroutine::origName

void uBaseCoroutine::UnHandledException::defaultTerminate() const {
    if ( ! multiple ) {
	uAbort( "(uBaseCoroutine &)0x%p : Unhandled exception in coroutine %.256s raised non-locally from resumed coroutine %.256s (0x%p), which was terminated due to %s.",
		&uThisCoroutine(), uThisCoroutine().getName(), sourceName(), &source(), message() );
    } else {
	uAbort( "(uBaseCoroutine &)0x%p : Unhandled exception in coroutine %.256s raised non-locally from coroutine %.256s (0x%p), "
		"which was terminated due to a series of unhandled exceptions -- originally %s inside coroutine %.256s (0x%p).",
		&uThisCoroutine(), uThisCoroutine().getName(), sourceName(), &source(), message(), origName(), &origSource() );
    } // if
} // uBaseCoroutine::UnHandledException::defaultTerminate


// Local Variables: //
// compile-command: "gmake install" //
// End: //
