//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.h -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Dec 21 14:01:24 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan 24 13:14:38 2006
// Update Count     : 170
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_ALARM_H__
#define __U_ALARM_H__


class uSignalHandler;					// forward declaration


//######################### uEventNode #########################


class uEventNode : public uSeqable {
    friend class uEventList;				// access: everything
    friend class uProcEventList;			// access: constructor
    friend class uEventListPop;				// access: everything
    friend _Coroutine uProcessorKernel;			// access: timerT, private constructor
    friend class uBaseTask;				// access: everything
    friend class uSerial;				// access: everything
    friend class uNBIO;					// access: everything
    friend class uKernelBoot;                           // access: new
    friend class uProcessor;                            // access: new
    friend class uCondLock;				// access: everything

    uTime timerT;					// time when alarm goes off (in internal clock time)
    uDuration timerD;					// if periodic, timerD contains period of alarm (after timerT)
    uSignalHandler *SigHandler;				// signal handler function when timer goes up
    uBaseTask *who;					// task that created the event
    bool executeLocked;					// indicates if handler is executed with uEventlock acquired
    uProcessor *processor;				// processor to handle event (NULL => unspecified processor)
    uProcessor *activeProcessor;			// processor actually handling event (NULL => inactive)

    uEventNode( uProcessor *processor = NULL );
    uEventNode( uBaseTask &task, uSignalHandler &sig, uTime tT, uDuration tD = 0, uProcessor *processor = NULL );
    uEventNode( uSignalHandler &sig, uProcessor *processor = NULL );

    void add( bool block = false );			// activate the event
    void remove();					// deactivate
    void setProcessor( uProcessor *processor = NULL );	// change proc
}; // uEventNode


//######################### uEventList #########################


class uEventList {
    friend _Coroutine uProcessorKernel;			// access: new
    friend class uSerial;				// access: addEvent, removeEvent
    friend class uCondLock;				// access: addEvent, removeEvent
    friend class uNBIO;					// access: addEvent, removeEvent, uNextAlarm
    friend class uBaseTask;				// access: addEvent
    friend class uCluster;				// access: uNextAlarm
    friend class uKernelBoot;				// access: new
    friend class uProcessor;				// access: new
    friend class uEventListPop;				// access: uL
    friend class uProcEventList;			// access: addEvent, removeEvent
    friend class uEventNode;				// access: addEvent, removeEvent
  protected:
    uSequence<uEventNode> eventlist;			// event list
    uSpinLock eventLock;				// protect EventQueue

    void *operator new( size_t, void *storage );
    void *operator new( size_t size );

    virtual ~uEventList() {}

    void addEvent( uEventNode &newAlarm, uProcessor &processor = uThisProcessor(), bool block = false );
    void removeEvent( uEventNode &oldNode, uProcessor &processor = uThisProcessor() );
    static uEventNode *nextEvent();
    static uTime nextAlarm();

#ifndef __U_MULTI__
    bool userEventPresent();
#endif // ! __U_MULTI__

    void acquireEventLock();
    void releaseEventLock();
    void acquireEventLockNoRF();
    void releaseEventLockNoRF();

    void setTimer( uTime time );
    virtual void setTimer( uDuration duration ) = 0;
  public:
}; // uEventList


//######################### uSysEventList #########################


class uSysEventList : public uEventList {
    virtual void setTimer( uDuration duration );
}; // uSysEventList


#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
//######################### uProcWakeupHndlr #########################


class uProcWakeupHndlr : public uSignalHandler {
    friend class uProcEventList;			// access: constructor

    uProcessor &processor;

    uProcWakeupHndlr( uProcessor &processor );
    void uHandler();
}; // uProcWakeupHndlr


//######################### uProcEventList #########################


class uProcEventList : public uEventList {
    friend class uProcessor;				// access: constructor
    friend class uEventList;				// access: wakeupEvent

    uProcWakeupHndlr procWakeupHandler;			// special time slice handler
    uEventNode wakeupEvent;				// wakeup node for global event list

    uProcEventList( uProcessor &processor );
    virtual void setTimer( uDuration duration );
}; // uProcEventList
#endif // __U_ONETIMER__ && __U_MULTI__


//######################### uEventListPop #########################


class uEventListPop {
    uEventList *eventlist;
    uTime currTime;
    uSignalHandler *cxtSwHandler;			// ContextSwitch encountered?
    bool inKernel;
    uQueue<uSignalHandler> deferredEvents;
  public:
    uEventListPop();
    uEventListPop( uEventList &eventlist, bool inKernel );
    ~uEventListPop();
    void over( uEventList &eventlist, bool inKernel );
    bool operator>>( uEventNode *&node );
}; // uEventListPop


#endif // __U_ALARM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
