//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.cc -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Jan  4 17:34:00 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan 24 13:16:00 2006
// Update Count     : 241
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>


//######################### uEventNode #########################


uEventNode::uEventNode( uBaseTask &task, uSignalHandler &sig, uTime tT, uDuration tD, uProcessor *processor ) {
    timerT = tT;
    timerD = tD;
    SigHandler = &sig;
    who = &task;
    executeLocked = false;
    uEventNode::processor = processor;
    activeProcessor = NULL;
} // uEventNode::uEventNode


uEventNode::uEventNode( uSignalHandler &sig, uProcessor *processor ) {
    timerT = 0;
    timerD = 0;
    SigHandler = &sig;
    who = NULL;
    executeLocked = false;
    uEventNode::processor = processor;
    activeProcessor = NULL;
} // uEventNode::uEventNode


uEventNode::uEventNode( uProcessor *processor ) {
    timerT = 0;
    timerD = 0;
    SigHandler = NULL;
    who = NULL;
    executeLocked = false;
    uEventNode::processor = processor;
    activeProcessor = NULL;
} // uEventNode::uEventNode


void uEventNode::add( bool block ) {
    if ( processor == NULL ) {
	activeProcessor = &uThisProcessor();
	activeProcessor->events->addEvent( *this, *activeProcessor, block );
    } else {
	activeProcessor = processor;
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	processor->procEvents->addEvent( *this, *processor, block );
#else
	processor->events->addEvent( *this, *processor, block );
#endif // __U_ONETIMER__ && __U_MULTI__
    } // if
} // uEventNode::add


void uEventNode::remove() {
    if ( processor == NULL ) {
	activeProcessor->events->removeEvent( *this, *activeProcessor );
    } else {
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	activeProcessor->procEvents->removeEvent( *this, *activeProcessor );
#else
	activeProcessor->events->removeEvent( *this, *activeProcessor );
#endif // __U_ONETIMER__ && __U_MULTI__
    } // if
    activeProcessor = NULL;
} // uEventNode::remove


void uEventNode::setProcessor( uProcessor *processor ) {
    if ( activeProcessor != NULL ) {
	uAbort( "(uEventNode &)0x%p.setProcessor() : internal error, attempt to set processor for an active event.", this );
    } // if
    uEventNode::processor = processor;
} // uEventNode::setProcessor


//######################### uEventList #########################


void *uEventList::operator new( size_t, void *storage ) {
    return storage;
} // uEventList::operator new

void *uEventList::operator new( size_t size ) {
    return ::operator new( size );
} // uEventList::operator new


void uEventList::addEvent( uEventNode &newAlarm, uProcessor &processor, bool block ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventList &)0x%p.addEvent, newAlarm:0x%p, processor:0x%p\n", this, &newAlarm, &processor );
#endif // __U_DEBUG_H__
    acquireEventLock();

    uSeqIter<uEventNode> iter(eventlist);
    uEventNode *node, *prev = NULL;
    int i;

    for ( i = 0; iter >> node && node->timerT <= newAlarm.timerT; prev = node, i += 1 );

    eventlist.insertBef( &newAlarm, node );		// insert in list

    if ( i == 0 ) {					// insert at the front ?
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	if ( this == uThisProcessor().events ) {	// same processor as event list ?
#endif // ! __U_ONETIMER__ && __U_MULTI__
	    setTimer( newAlarm.timerT );		// reset alarm
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	} else {
	    uThisCluster().wakeProcessor( processor.getPid() );
	} // if
#endif // ! __U_ONETIMER__ && __U_MULTI__
    } // if

    if ( block ) {
	uSCHEDULE( &eventLock );
    } else {
	releaseEventLock();
    } // if
} // uEventList::addEvent


// No yield after a removeEvent. This is handled by whatever code calls
// removeEvent.

void uEventList::removeEvent( uEventNode &oldNode, uProcessor &processor ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventList &)0x%p.removeEvent, newAlarm:0x%p, processor:0x%p\n", this, &oldNode, &processor );
#endif // __U_DEBUG_H__
    acquireEventLock();

    uEventNode *headNode;

    if ( ! oldNode.listed() ) {				// node already removed ?
	releaseEventLock();
	return;
    } // if
    headNode = eventlist.head();
    eventlist.remove( &oldNode );

    if ( headNode == &oldNode ) {			// removing at head ?  reset alarm
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	if ( this == uThisProcessor().events ) {	// same processor as event list ?
#endif // ! __U_ONETIMER__ && __U_MULTI__
	    headNode = eventlist.head();
	    if ( ! headNode ) {				// list empty ?
		setTimer( uDuration( 0 ) );		// cancel alarm
	    } else {
		setTimer( headNode->timerT );		// reset alarm
	    } // if
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	} else {
	    uThisCluster().wakeProcessor( processor.getPid() ); // send SIGALRM to reset alarm on other processor
	} // if
#endif // ! __U_ONETIMER__ && __U_MULTI__
    } // if
    releaseEventLock();
} // uEventList::removeEvent


uEventNode *uEventList::nextEvent( ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "uEventList::nextEvent\n" );
#endif // __U_DEBUG_H__

    uEventList *events;

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    uProcessor *p = &uThisProcessor();
    if ( p == uKernelModule::systemProcessor ) {
	events = uProcessor::events;
    } else {
	events = p->procEvents;
    } // if
#else
    events = uThisProcessor().events;
#endif // __U_ONETIMER__ && __U_MULTI__
    events->acquireEventLock();

    uEventNode *noder;
    uSeqIter<uEventNode> iter( events->eventlist );

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    if ( p == uKernelModule::systemProcessor ) {
	// loop executes at most 2 iterations
	for ( ; iter >> noder && noder == &uThisProcessor().procEvents->wakeupEvent; );
	if ( noder == NULL ) {
	    events->releaseEventLock();
	    events = p->procEvents;
	    events->acquireEventLock();
	    iter.over( events->eventlist );
	} // if
    } // if
    if ( p != uKernelModule::systemProcessor || noder == NULL ) {
#endif // __U_ONETIMER__ && __U_MULTI__
	// loop executes at most 2 iterations
	for ( ; iter >> noder && noder->SigHandler == (uSignalHandler *)(uThisProcessor().contextSwitchHandler); );
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    } // if
#endif // __U_ONETIMER__ && __U_MULTI__

    events->releaseEventLock();

    return noder;
} // uEventList::nextEvent


uTime uEventList::nextAlarm( ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "uEventList::nextAlarm\n" );
#endif // __U_DEBUG_H__
    uEventNode *noder = nextEvent();

    if ( noder ) {
	return noder->timerT;
    } else {
	return uTime( 0L );
    } // if
} // uEventList::nextAlarm


void uEventList::acquireEventLock() {
    eventLock.acquire();
} // uEventList::acquireEventLock

void uEventList::releaseEventLock() {
    eventLock.release();
} // uEventList::releaseEventLock

void uEventList::acquireEventLockNoRF() {
    eventLock.acquireNoRF();
} // uEventList::acquireEventLockNoRF

void uEventList::releaseEventLockNoRF() {
    eventLock.releaseNoRF();
} // uEventList::releaseEventLockNoRF


#ifndef __U_MULTI__
bool uEventList::userEventPresent() {
    acquireEventLock();

    uEventNode *noder;
    uSeqIter<uEventNode> iter(eventlist);

    // loop executes at most 3 iterations
    for ( ; iter >> noder && ( (uSignalHandler *)(uThisProcessor().contextSwitchHandler) == noder->SigHandler // ignore context switch events
			     || noder->who == (uBaseTask *)uKernelModule::systemTask ); // ignore system task
	 );
    releaseEventLock();

    return noder != NULL;
} // uEventList::userEventPresent
#endif // ! __U_MULTI__


void uEventList::setTimer( uTime time ) {
  if ( time == 0 ) return;				// if time is zero, it's invalid

    // Since this is private, and only uSysEventList is a friend, the assumption
    // is made that the time parameter is always in real-time (not virtual
    // time)

#if defined( REALTIME_POSIX )
    timespec curr;
    if ( clocktype < 0 ) type = CLOCK_REALTIME;
    clock_gettime( type, &curr );
#else
    timeval curr;
    GETTIMEOFDAY( &curr );
#endif // REALTIME_POSIX
    uTime currtime( curr.tv_sec, curr.tv_usec * 1000 );	// convert to nanoseconds

    uDuration dur = time - currtime;
    if ( dur <= 0 ) {					// if duration is negative (it has already past)
	// fill in the value to the next expiry by setting alarm to soonest
	// time an alarm may come
	setTimer( uDuration( 0, TIMEGRAN / 1000000L ) );
    } else {
	setTimer( dur );
    } // if
} // uEventList::setTimer


//######################### uSysEventList #########################


void uSysEventList::setTimer( uDuration duration ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uSysEventList &)0x%p.setTimer, duration %lld\n", this, duration.nanoseconds() );
#endif // __U_DEBUG_H__
    activeProcessorKernel->setTimer( duration );
} // uSysEventList::setTimer


#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
//######################### uProcWakeupHndlr #########################


uProcWakeupHndlr::uProcWakeupHndlr( uProcessor &processor ) : processor( processor ) {
} // uProcWakeupHndlr::uProcWakeupHndlr


void uProcWakeupHndlr::uHandler() {
    if ( &processor == &uThisProcessor() ) return;

#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uProcWakeupHndlr &)0x%p.uHandler: waking processor %lu\n", this, (unsigned long)processor.getPid() );
#endif // __U_DEBUG_H__

    uCluster::wakeProcessor( processor.getPid() );
} // uProcWakeupHndlr::uHandler


//######################### uProcEventList #########################


uProcEventList::uProcEventList( uProcessor &processor ) : procWakeupHandler( processor ), wakeupEvent( procWakeupHandler ) {
} // uProcEventList::uProcEventList


void uProcEventList::setTimer( uDuration duration ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uProcEventList &)0x%p.setTimer, duration %lld\n", this, duration.nanoseconds() );
#endif // __U_DEBUG_H__
    uTime wakeupTime = activeProcessorKernel->kernelClock.getTime() + duration;
    if ( ! wakeupEvent.listed() && duration != 0 ) {	// first wakekup event ?
	wakeupEvent.timerT = wakeupTime;
	uProcessor::events->addEvent( wakeupEvent );
    } else if ( duration > 0  && wakeupEvent.timerT != wakeupTime ) { // if event is different from previous ? change it
	uProcessor::events->removeEvent( wakeupEvent );
	wakeupEvent.timerT = wakeupTime;
	uProcessor::events->addEvent( wakeupEvent );
    } else if ( duration == 0 && wakeupEvent.timerT != 0 ) { // zero duration and current wakekup is nonzero ?
	uProcessor::events->removeEvent( wakeupEvent );
	wakeupEvent.timerT = 0;   
    } // if
} // uProcEventList::setTimer
#endif // __U_ONETIMER__ && __U_MULTI__


//######################### uEventListPop #########################


uEventListPop::uEventListPop( uEventList &eventlist, bool inKernel ) : eventlist( &eventlist ), inKernel( inKernel ) {
    THREAD_SETMEM( inKernelRF, 1 );			// detect if subsequent interrupts occur
    currTime = activeProcessorKernel->kernelClock.getTime();
    cxtSwHandler = NULL;
} // uEventListPop::uEventListPop

uEventListPop::~uEventListPop() {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.~uEventListPop\n", this );
#endif // __U_DEBUG_H__
    uSignalHandler *hndlr;
    for ( uQueueIter<uSignalHandler> iter( deferredEvents ); iter >> hndlr; ) {
#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>> process deferred handler 0x%p\n", this, hndlr );
#endif // __U_DEBUG_H__
	hndlr->uHandler();
	deferredEvents.remove( hndlr );
    } // for

    eventlist->acquireEventLockNoRF();
    // only reset the roll forward flag if no other interrupts occurred during
    // roll forward
    if ( THREAD_GETMEM( inKernelRF ) == 1 ) {
	THREAD_SETMEM( inKernelRF, 0 );
    } // if

    if ( ! eventlist->eventlist.empty() ) {
	eventlist->setTimer( eventlist->eventlist.head()->timerT );
    } // if
    eventlist->releaseEventLock();

    if ( ! inKernel ) {					// not in kernel ?
	if ( cxtSwHandler ) {				// context-switch event ?
	    cxtSwHandler->uHandler();			// should do a yield
	} else {
	    // Force a reschedule as a higher priority task may have become
	    // ready and is now at the front of the ready queue. Note,
	    // rescheduling can occur even if a lower priority task unblocks.
	    // As a side effect, if the current task has the same priority as
	    // the task on the front of the ready queue, the current task is
	    // preempted even if it has only just started execution.

	    uThisTask().uYieldInvoluntary();
	} // if
    } else {
	// roll-forward is only called from the kernel, after waking up from
	// sleeping, or an alarm occurred while in the process of going to
	// sleep.  Therefore, yielding is unnecessary, if going to sleep (or
	// have slept).  There were no tasks to execute or context switch from
	// in the first place.

	// A preemption event may be ignored because a reschedule is just about
	// to occur, anyway, when the kernel reschedules the next task.
    } // if
} // uEventListPop::~uEventListPop

void uEventListPop::over( uEventList &eventlist, bool inKernel ) {
    uEventListPop::eventlist = &eventlist;
    uEventListPop::inKernel = inKernel;
    currTime = activeProcessorKernel->kernelClock.getTime();
    cxtSwHandler = NULL;
} // uEventListPop::over

bool uEventListPop::operator>>( uEventNode *&node ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>>, event list 0x%p\n", this, eventlist );
#endif // __U_DEBUG_H__
    eventlist->acquireEventLockNoRF();

    node = eventlist->eventlist.head();			// get event at the start of the list with the shortest time delay

#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>>, node:0x%p\n", this, node );
#endif // __U_DEBUG_H__
  if ( ! node ) {					// no events ?
	eventlist->releaseEventLockNoRF();
	return false;
    } // if

  if ( node->timerT > currTime ) {			// event time delay greater than the start time for the iteration
	eventlist->releaseEventLockNoRF();
	return false;
    } // if

    eventlist->eventlist.remove( node );

    // Now see if the popped event is periodic.  If it is, insert another event
    // for next period.

    if ( node->timerD != 0 ) {
	node->timerT = currTime + node->timerD;		// Reset timerT value in clock object
	uSeqIter<uEventNode> i( eventlist->eventlist );
	uEventNode *prev;
	uEventNode *noder;

	// May have to order identical timed elements by priority (to keep up
	// the real-time spirit)

	for ( prev = NULL; i >> noder && noder->timerT <= node->timerT; prev = noder );

	eventlist->eventlist.insertBef( node, noder );	// insert into list
    } // if

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    if ( dynamic_cast<uProcWakeupHndlr *>( node->SigHandler ) != NULL ) {
#ifdef __U_DEBUG_H__
	uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>> defer event 0x%p handler 0x%p\n", this, node, node->SigHandler );
#endif // __U_DEBUG_H__
	deferredEvents.add( node->SigHandler );		// save for last
	eventlist->releaseEventLockNoRF();
    } else
#endif // __U_ONETIMER__ && __U_MULTI__
    if ( node->SigHandler == (uSignalHandler *)(uThisProcessor().contextSwitchHandler) ) {
	cxtSwHandler = node->SigHandler;		// remember the context switch event
	eventlist->releaseEventLockNoRF();
    } else {                                            // not a ContextSwitch event
	if ( node->executeLocked ) {			// should handler be called with lock
	    node->SigHandler->uHandler();		// invoke the handler code for the event
	    eventlist->releaseEventLockNoRF();
	} else {
	    eventlist->releaseEventLockNoRF();
	    node->SigHandler->uHandler();		// invoke the handler code for the event
	} // if
    } // if

    return true;
} // uEventListPop::operator>>


// Local Variables: //
// compile-command: "gmake install" //
// End: //
