//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1994
// 
// uContext.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Thu Jul  7 13:08:01 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jul 31 18:53:41 2005
// Update Count     : 14
// 

#include <uC++.h>
#include <cstdio>

// WARNING: Do not use cout or cerr in save or restore as they cause a
// recursive context switch (BAD!).

class uCoProcessorCxt1 : public uContext {
    static int uUniqueKey;
  public:
    uCoProcessorCxt1() : uContext( &uUniqueKey ) {};
    void save() {
	printf( "uCoProcessorCxt1::save\n" );
    }
    void restore() {
	printf( "uCoProcessorCxt1::restore\n" );
    }
}; // uCoProcessorCxt1

int uCoProcessorCxt1::uUniqueKey = 0;

class uCoProcessorCxt2 : public uContext {
  public:
    void save() {
	printf( "uCoProcessorCxt2::save\n" );
    }
    void restore() {
	printf( "uCoProcessorCxt2::restore\n" );
    }
}; // uCoProcessorCxt2

void uMain::main() {
    uCoProcessorCxt1 cpCxt11, cpCxt12;
    uCoProcessorCxt2 cpCxt21, cpCxt22;

    for ( int i = 0; i < 5; i += 1 ) {
	yield();
    } // for
} // uMain::main
    
// Local Variables: //
// compile-command: "u++ -O uContext.cc" //
// End: //
