//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1996
// 
// MutexOwner.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Feb  6 13:51:59 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Nov 30 08:42:05 2005
// Update Count     : 24
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_Cormonitor tom {
  public:
    tom() {
	reset();
    }
    void reset() {
	osacquire( cout ) << "(" << &uThisTask() << ") tom::reset" << endl;
    }
};    

_Cormonitor fred : public tom {
    void main() {
	for ( int i = 0; i < 3; i += 1 ) {
	    mem();
	} // for
	resume();
    }
  public:
    fred() {
	reset();
    }
    void reset() {
	osacquire( cout ) << "(" << &uThisTask() << ") fred::reset" << endl;
    }
    void mem() {
	resume();
    }
};

_Monitor mary {
    uCondition delay;
  public:
    void mem( int i ) {
	if ( i >= 0 ) {
	    mem( i - 1 );
	    osacquire( cout ) << "(" << &uThisTask() << ") mary::mem, i:" << i << endl;
	} else {
	    if ( delay.empty() ) {
		delay.wait();
	    } else {
		delay.signal();
	    } // if
	} // if
    } // mary::mem
}; // mary

_Task jane {
    mary &m;
  public:
    jane( mary &m ) : m( m ) {}
    void mem( int i ) {
	if ( i == 2 ) {
	    m.mem( i );
	} // if
    }
  protected:
    void main() {
	for ( int i = 0; i < 3; i += 1 ) {
	    osacquire( cout ) << "(" << &uThisTask() << ") jane::main, i:" << i << endl;
	    mem( i );
	} // for
    } // jane::main
}; // jane

void uMain::main() {
    fred f;
    f.mem();

    mary m;
    jane j1( m );
    jane j2( m );
} // uMain::main

// Local Variables: //
// compile-command: "../../bin/u++ -multi -g MutexOwner.cc" //
// End: //
